/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cgpt.supplier.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.qualification.model.BizQualificationLabel;
import com.artfess.cgpt.supplier.manager.BizSupplierOrgManager;
import com.artfess.cgpt.supplier.manager.BizSupplierOrgQualificationLabelManager;
import com.artfess.cgpt.supplier.manager.BizSupplierOrgSupplierTypeManager;
import com.artfess.cgpt.supplier.model.BizSupplierOrg;
import com.artfess.cgpt.supplier.model.BizSupplierOrgQualificationLabel;
import com.artfess.cgpt.supplier.model.BizSupplierOrgSupplierType;
import com.artfess.cgpt.supplier.model.BizSupplierType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/bizSupplierOrg/v1/"})
@Api(tags={"\u4f9b\u5e94\u5546\u8868"})
@ApiGroup(group={"group_biz"})
public class BizSupplierOrgController
extends BaseController<BizSupplierOrgManager, BizSupplierOrg> {
    @Autowired
    private BizSupplierOrgSupplierTypeManager bizSupplierOrgSupplierTypeManager;
    @Autowired
    private BizSupplierOrgQualificationLabelManager bizSupplierOrgQualificationLabelManager;

    @PostMapping(value={"/page"})
    @ApiOperation(value="S-\u5206\u9875\u67e5\u8be2\u6570\u636e")
    public CommonResult<PageList<BizSupplierOrg>> queryAllByPage(@ApiParam(name="queryfilter", value="\u901a\u7528\u67e5\u8be2\u5668") @RequestBody QueryFilter<BizSupplierOrg> queryFilter) {
        PageList<BizSupplierOrg> result = ((BizSupplierOrgManager)this.baseService).queryAllByPage(queryFilter);
        return new CommonResult(true, "\u67e5\u8be2\u6210\u529f", result);
    }

    @RequestMapping(value={"/saveSupplierOrg"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="M-\u6dfb\u52a0\u6216\u4fee\u6539\u4f9b\u5e94\u5546")
    public CommonResult<List<BizSupplierOrg>> saveSupplierOrg(@RequestBody BizSupplierOrg entity) {
        entity.setIsDele("0");
        ((BizSupplierOrgManager)this.baseService).saveOrUpdate((Object)entity);
        List<BizSupplierType> supplierTypeList = entity.getSupplierTypeList();
        List<BizQualificationLabel> qualificationLabelList = entity.getQualificationLabelList();
        ArrayList<BizSupplierOrgSupplierType> list = new ArrayList<BizSupplierOrgSupplierType>();
        for (BizSupplierType bizSupplierType : supplierTypeList) {
            BizSupplierOrgSupplierType model = new BizSupplierOrgSupplierType();
            model.setSupplierOrgId(entity.getId());
            model.setSupplierTypeId(bizSupplierType.getId());
            list.add(model);
        }
        ArrayList<BizSupplierOrgQualificationLabel> list1 = new ArrayList<BizSupplierOrgQualificationLabel>();
        for (BizQualificationLabel s : qualificationLabelList) {
            BizSupplierOrgQualificationLabel model = new BizSupplierOrgQualificationLabel();
            model.setSupplierOrgId(entity.getId());
            model.setQualificationLabelId(s.getId());
            list1.add(model);
        }
        this.bizSupplierOrgSupplierTypeManager.saveBatch(list);
        this.bizSupplierOrgQualificationLabelManager.saveBatch(list1);
        String string = "\u64cd\u4f5c\u6210\u529f";
        return new CommonResult(true, string);
    }

    @PostMapping(value={"/remove"})
    @ApiOperation(value="S-\u6279\u91cf\u5220\u9664")
    public CommonResult remove(@RequestParam List<String> ids) {
        ((BizSupplierOrgManager)this.baseService).removeByIds(ids);
        return new CommonResult(true, "\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/selectOne"})
    @ApiOperation(value="S-\u67e5\u8be2\u8be6\u60c5")
    public CommonResult<BizSupplierOrg> selectOne(@RequestParam String supplierId) {
        BizSupplierOrg result = (BizSupplierOrg)((Object)((BizSupplierOrgManager)this.baseService).getById((Serializable)((Object)supplierId)));
        List<BizSupplierType> orgSupplierTypes = ((BizSupplierOrgManager)this.baseService).querySupplierType(supplierId);
        List<BizQualificationLabel> queryQualifications = ((BizSupplierOrgManager)this.baseService).queryQualification(supplierId);
        result.setSupplierTypeList(orgSupplierTypes);
        result.setQualificationLabelList(queryQualifications);
        return new CommonResult(true, "\u67e5\u8be2\u6210\u529f", (Object)result);
    }
}

