/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cgpt.material.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.feign.UCFeignService;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.material.manager.BizMaterialCategoryManager;
import com.artfess.cgpt.material.model.BizMaterialCategory;
import com.artfess.cgpt.utils.BizUtils;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/bizMaterialCategory/v1/"})
@Api(tags={"\u7269\u6599\u5206\u7c7b"})
@ApiGroup(group={"group_biz"})
public class BizMaterialCategoryController
extends BaseController<BizMaterialCategoryManager, BizMaterialCategory> {
    @Autowired
    private UCFeignService ucFeignService;

    @RequestMapping(value={"/selectTree"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="M-\u67e5\u8be2\u7269\u6599\u5206\u7c7b\u6811\u7ed3\u6784", notes="\u53c2\u6570\u8bf4\u660e\uff1a\u901a\u7528\u67e5\u8be2\u5668", httpMethod="POST")
    public CommonResult<List<BizMaterialCategory>> queryOrganization() {
        List<BizMaterialCategory> result = ((BizMaterialCategoryManager)this.baseService).selectTree();
        return new CommonResult(true, "\u67e5\u8be2\u6210\u529f", result);
    }

    @RequestMapping(value={"/saveCategory"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="M-\u6dfb\u52a0\u6216\u4fee\u6539\u7269\u6599\u5206\u7c7b\u540d\u79f0")
    public CommonResult<List<BizMaterialCategory>> saveCategory(@RequestBody BizMaterialCategory category) {
        boolean admin = BizUtils.isAdmin(this.ucFeignService);
        String message = "\u64cd\u4f5c\u6210\u529f";
        if (admin) {
            message = "\u65e0\u6743\u9650\uff0c\u6dfb\u52a0\u5931\u8d25";
        } else if (category.getId() == null || category.getId().equals("")) {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"code_", (Object)category.getCode());
            int count = ((BizMaterialCategoryManager)this.baseService).count((Wrapper)wrapper);
            if (count > 0) {
                message = "\u8be5\u7f16\u53f7\u5df2\u5b58\u5728\u8bf7\u91cd\u65b0\u8f93\u5165";
            } else {
                ((BizMaterialCategoryManager)this.baseService).save((Object)category);
                UpdateWrapper wrapper1 = new UpdateWrapper();
                ((UpdateWrapper)wrapper1.eq((Object)"id_", (Object)category.getParentId())).set((Object)"HAS_CHILDREN_", (Object)1);
                ((BizMaterialCategoryManager)this.baseService).update((Wrapper)wrapper1);
            }
        } else {
            ((BizMaterialCategoryManager)this.baseService).update((Model)category);
        }
        return new CommonResult(true, message);
    }

    @RequestMapping(value={"/deletCategory"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="M-\u6279\u91cf\u5220\u9664\u7269\u6599\u5206\u7c7b\u540d\u79f0")
    public CommonResult<List<BizMaterialCategory>> deletCategory(@RequestParam List<String> ids) {
        boolean admin = BizUtils.isAdmin(this.ucFeignService);
        String message = "\u5220\u9664\u6210\u529f";
        if (admin) {
            message = "\u65e0\u6743\u9650\uff0c\u5220\u9664\u5931\u8d25";
        } else {
            ((BizMaterialCategoryManager)this.baseService).removeByIds(ids);
        }
        return new CommonResult(true, message);
    }

    @RequestMapping(value={"/updateStatus"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="M-\u4fee\u6539\u7269\u6599\u5206\u7c7b\u72b6\u6001")
    public CommonResult<List<BizMaterialCategory>> updateStatus(@RequestBody List<String> ids, @RequestParam String status) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        ((UpdateWrapper)updateWrapper.in((Object)"id_", ids)).set((Object)"status_", (Object)status);
        ((BizMaterialCategoryManager)this.baseService).update((Wrapper)updateWrapper);
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f");
    }

    @PostMapping(value={"/exportExcelData"})
    @ApiOperation(value="M-\u5bfc\u51fa\u6570\u636e\u5230Excel", notes="\u53c2\u6570\u8bf4\u660e\uff1a\u67e5\u8be2\u5668\u53ea\u4f7f\u5230\u4e86query\u7ec4\u4f20\u53c2\uff0c\u5176\u4ed6\u90fd\u53ef\u4ee5\u4e0d\u8981")
    public CommonResult exportExcelData(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5668") @RequestBody QueryFilter<BizMaterialCategory> queryFilter, HttpServletResponse response) throws Exception {
        ((BizMaterialCategoryManager)this.baseService).exportExcelData(queryFilter, response);
        return new CommonResult("\u5bfc\u51fa\u6210\u529f");
    }
}

