/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cgpt.expert.controller;

import cn.hutool.json.JSONObject;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.feign.SystemConfigFeignService;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.expert.manager.BizExpertDatabaseExpertTypeManager;
import com.artfess.cgpt.expert.manager.BizExpertDatabaseManager;
import com.artfess.cgpt.expert.manager.BizExpertDatabaseOrgManager;
import com.artfess.cgpt.expert.manager.BizExpertDatabaseQualificationLabelManager;
import com.artfess.cgpt.expert.model.BizExpertDatabase;
import com.artfess.cgpt.expert.model.BizExpertDatabaseExpertType;
import com.artfess.cgpt.expert.model.BizExpertDatabaseOrg;
import com.artfess.cgpt.expert.model.BizExpertDatabaseQualificationLabel;
import com.artfess.cgpt.expert.model.BizExpertType;
import com.artfess.cgpt.qualification.model.BizQualificationLabel;
import com.artfess.uc.model.Org;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/bizExpertDatabase/v1/"})
@Api(tags={"\u4e13\u5bb6\u5e93\u7ba1\u7406"})
@ApiGroup(group={"group_biz"})
public class BizExpertDatabaseController
extends BaseController<BizExpertDatabaseManager, BizExpertDatabase> {
    @Autowired
    private BizExpertDatabaseQualificationLabelManager bizExpertDatabaseQualificationLabelManager;
    @Autowired
    private SystemConfigFeignService service;
    @Autowired
    private BizExpertDatabaseExpertTypeManager bizExpertDatabaseExpertTypeManager;
    @Autowired
    private BizExpertDatabaseOrgManager bizExpertDatabaseOrgManager;

    @PostMapping(value={"/page"})
    @ApiOperation(value="S-\u5206\u9875\u67e5\u8be2\u6570\u636e")
    public CommonResult<PageList<BizExpertDatabase>> queryAllByPage(@ApiParam(name="queryfilter", value="\u901a\u7528\u67e5\u8be2\u5668") @RequestBody QueryFilter<BizExpertDatabase> queryFilter) {
        PageList<BizExpertDatabase> result = ((BizExpertDatabaseManager)this.baseService).queryAllByPage(queryFilter);
        return new CommonResult(true, "\u67e5\u8be2\u6210\u529f", result);
    }

    @PostMapping(value={"/selectOne"})
    @ApiOperation(value="S-\u67e5\u8be2\u8be6\u60c5")
    public CommonResult<BizExpertDatabase> selectOne(@ApiParam(name="queryfilter", value="\u901a\u7528\u67e5\u8be2\u5668") @RequestParam String id) {
        BizExpertDatabase result = (BizExpertDatabase)((Object)((BizExpertDatabaseManager)this.baseService).getById((Serializable)((Object)id)));
        return new CommonResult(true, "\u67e5\u8be2\u6210\u529f", (Object)result);
    }

    @PostMapping(value={"/remove"})
    @ApiOperation(value="S-\u6279\u91cf\u5220\u9664\u4e13\u5bb6")
    public CommonResult remove(@RequestParam List<String> ids) {
        UpdateWrapper wrapper = new UpdateWrapper();
        wrapper.in((Object)"EXPERT_DATABASE_ID_", ids);
        this.bizExpertDatabaseQualificationLabelManager.remove((Wrapper)wrapper);
        ((BizExpertDatabaseManager)this.baseService).removeByIds(ids);
        return new CommonResult(true, "\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/save"})
    @ApiOperation(value="S-\u6dfb\u52a0\u6216\u4fee\u6539\u4e13\u5bb6")
    public CommonResult save(@ApiParam(name="queryfilter", value="\u901a\u7528\u67e5\u8be2\u5668") @RequestBody BizExpertDatabase entity) {
        String message = "\u64cd\u4f5c\u6210\u529f";
        String nextIdByAlias = this.service.getNextIdByAlias("cgpt_zjkgl");
        JSONObject jsonObject = new JSONObject((Object)nextIdByAlias);
        Object value = jsonObject.get((Object)"value");
        String s = value.toString();
        entity.setUserNumber(s);
        ((BizExpertDatabaseManager)this.baseService).saveOrUpdate((Object)entity);
        UpdateWrapper updateWrapper1 = new UpdateWrapper();
        UpdateWrapper updateWrapper2 = new UpdateWrapper();
        UpdateWrapper updateWrapper3 = new UpdateWrapper();
        updateWrapper1.eq((Object)"EXPERT_DATABASE_ID_", (Object)entity.getId());
        updateWrapper2.eq((Object)"EXPERT_DATABASE_ID_", (Object)entity.getId());
        updateWrapper3.eq((Object)"EXPERT_DATABASE_ID_", (Object)entity.getId());
        this.bizExpertDatabaseExpertTypeManager.remove((Wrapper)updateWrapper1);
        this.bizExpertDatabaseQualificationLabelManager.remove((Wrapper)updateWrapper2);
        this.bizExpertDatabaseOrgManager.remove((Wrapper)updateWrapper3);
        List<BizExpertType> typeList = entity.getTypeList();
        List<BizQualificationLabel> qualificationLabelList = entity.getQualificationLabelList();
        List<Org> orgList = entity.getOrgList();
        if (typeList != null && typeList.size() > 0) {
            for (BizExpertType bizExpertType : typeList) {
                BizExpertDatabaseExpertType entity1 = new BizExpertDatabaseExpertType();
                entity1.setExpertDatabaseId(entity.getId());
                entity1.setExpertTypeId(bizExpertType.getId());
                this.bizExpertDatabaseExpertTypeManager.save((Object)entity1);
            }
        }
        if (qualificationLabelList != null && qualificationLabelList.size() > 0) {
            for (BizQualificationLabel bizQualificationLabel : qualificationLabelList) {
                BizExpertDatabaseQualificationLabel entity2 = new BizExpertDatabaseQualificationLabel();
                entity2.setExpertDatabaseId(entity.getId());
                entity2.setQualificationLabelId(bizQualificationLabel.getId());
                this.bizExpertDatabaseQualificationLabelManager.save((Object)entity2);
            }
        }
        if (orgList != null && orgList.size() > 0) {
            for (Org org : orgList) {
                BizExpertDatabaseOrg entity3 = new BizExpertDatabaseOrg();
                entity3.setExpertDatabaseId(entity.getId());
                entity3.setOrgId(org.getId());
                this.bizExpertDatabaseOrgManager.save((Object)entity3);
            }
        }
        return new CommonResult(true, message);
    }
}

