/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cgpt.universal.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.contract.manager.ContractCallBackManager;
import com.artfess.cgpt.universal.model.Accessory;
import com.artfess.cgpt.universal.model.Chunk;
import com.artfess.cgpt.universal.service.AccessoryService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"biz/universal/v1"})
@Api(tags={"\u901a\u7528\u9644\u4ef6\u7ba1\u7406\u63a5\u53e3"})
@ApiGroup(group={"group_biz"})
public class AccessoryController
extends BaseController<AccessoryService, Accessory> {
    private static final Logger log = LoggerFactory.getLogger(AccessoryController.class);
    @Autowired
    private ContractCallBackManager contractCallBackManager;

    @PostMapping(value={"/getBySourceId/{sourceId}"})
    @ApiOperation(value="S-\u901a\u8fc7\u8d44\u6e90Id\u4e0d\u5206\u9875\u67e5\u8be2\u9644\u4ef6\u4fe1\u606f", httpMethod="Post")
    public CommonResult<List<Accessory>> getBySourceId(@ApiParam(name="sourceId", value="\u8d44\u6e90Id") @PathVariable String sourceId) {
        List<Accessory> result = ((AccessoryService)this.baseService).getAccessoryBySourceId(sourceId);
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f", result);
    }

    @PostMapping(value={"/save"})
    @ApiOperation(value="S-\u6279\u91cf\u4fdd\u5b58\u9644\u4ef6\u4fe1\u606f", httpMethod="Post")
    public CommonResult<String> saveAccessory(@ApiParam(name="accessory", value="\u9644\u4ef6\u5bf9\u8c61") @RequestBody List<Accessory> list) {
        boolean status = ((AccessoryService)this.baseService).saveAccessory(list);
        String msg = status ? "\u4fdd\u5b58\u6210\u529f" : "\u4fdd\u5b58\u5931\u8d25";
        return new CommonResult(status, msg);
    }

    @PostMapping(value={"/minIoAllDownFile"})
    @ApiOperation(value="S-\u901a\u7528\u4e0b\u8f7d\u63a5\u53e3", httpMethod="POST", notes="\u901a\u7528\u4e0b\u8f7d\u63a5\u53e3")
    public void downTest(@ApiParam(name="ids", value="ids", required=true) @RequestParam(value="ids", required=true) String ids, @ApiParam(name="bizPath", value="bizPath", required=true) @RequestParam(value="bizPath", required=true) String bizPath, HttpServletResponse response) throws Exception {
        ((AccessoryService)this.baseService).minIoDownFile(ids, bizPath, response);
    }

    @PostMapping(value={"/ShardUpload"})
    @ApiOperation(value="S-\u5927\u6587\u4ef6\u5206\u7247\u4e0a\u4f20\u63a5\u53e3", httpMethod="POST", notes="\u5927\u6587\u4ef6\u5206\u7247\u4e0a\u4f20\u63a5\u53e3\uff08\u4e0a\u4f20\u5b8c\u6bd5\u9700\u8c03\u7528\u5408\u5e76\u63a5\u53e3\uff09")
    public CommonResult<String> minioUpload(@RequestBody MultipartFile upFile, @ApiParam(name="chunk", value="\u5206\u7247\u6587\u4ef6\u5bf9\u8c61", required=true) Chunk chunk, HttpServletResponse response) throws Exception {
        log.info("\u901a\u7528\u9644\u4ef6\u7ba1\u7406-\u9644\u4ef6\u4e0a\u4f20\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)chunk, (Object)response);
        chunk.setFile(upFile);
        String result = ((AccessoryService)this.baseService).fileUploadPost(chunk, response);
        boolean status = result.equals("over") || result.equals("ok");
        log.info("\u901a\u7528\u9644\u4ef6\u7ba1\u7406-\u9644\u4ef6\u4e0a\u4f20\u63a5\u53e3\u54cd\u5e94\u7ed3\u679c\uff1a{}", (Object)result);
        return new CommonResult(status, status ? "\u4e0a\u4f20\u6210\u529f" : "\u4e0a\u4f20\u5931\u8d25", (Object)result);
    }

    @PostMapping(value={"/mergeFileToMinIO"})
    @ApiOperation(value="S-\u5927\u6587\u4ef6\u5206\u7247\u4e0a\u4f20\u5408\u5e76\u63a5\u53e3", httpMethod="POST", notes="\u5927\u6587\u4ef6\u5206\u7247\u4e0a\u4f20\u5408\u5e76\u6587\u4ef6\u5f02\u6b65\u4e0a\u4f20MinIO")
    public CommonResult<Accessory> mergeFileToMinIO(@ApiParam(name="bizPath", value="MinIO\u4e2d\u7684\u4e1a\u52a1\u6587\u4ef6\u5939", required=true) @RequestParam String bizPath, @ApiParam(name="fileName", value="\u6587\u4ef6\u540d", required=true) @RequestParam String fileName) throws Exception {
        log.info("\u901a\u7528\u9644\u4ef6\u7ba1\u7406-\u5408\u5e76\u6587\u4ef6\u5f02\u6b65\u4e0a\u4f20MinIO\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)bizPath, (Object)fileName);
        Accessory accessory = ((AccessoryService)this.baseService).minioUpload(bizPath, fileName);
        log.info("\u901a\u7528\u9644\u4ef6\u7ba1\u7406-\u5408\u5e76\u6587\u4ef6\u5f02\u6b65\u4e0a\u4f20MinIO\u63a5\u53e3\u54cd\u5e94\u7ed3\u679c\uff1a{}", (Object)accessory);
        return new CommonResult(true, "\u4e0a\u4f20\u6210\u529f", (Object)accessory);
    }

    @RequestMapping(value={"/minioUpload"})
    @ApiOperation(value="\u666e\u901a\u9644\u4ef6\u4e0a\u4f20\u63a5\u53e3", httpMethod="POST", notes="\u666e\u901a\u9644\u4ef6\u4e0a\u4f20\u63a5\u53e3")
    public CommonResult<Accessory> minioUpload(MultipartFile file, String bizPath, HttpServletResponse response) throws Exception {
        Accessory accessory = ((AccessoryService)this.baseService).minioUpload(file, bizPath, response);
        return new CommonResult(true, "\u4e0a\u4f20\u6210\u529f", (Object)accessory);
    }

    @RequestMapping(value={"/minioBatchUpload"})
    @ApiOperation(value="\u666e\u901a\u9644\u4ef6\u6279\u91cf\u4e0a\u4f20\u63a5\u53e3", httpMethod="POST", notes="\u666e\u901a\u9644\u4ef6\u4e0a\u4f20\u63a5\u53e3")
    public CommonResult<List<Accessory>> minioBatchUpload(List<MultipartFile> fileList, String bizPath, HttpServletResponse response) throws Exception {
        List<Accessory> accessoryList = ((AccessoryService)this.baseService).minioBatchUpload(fileList, bizPath, response);
        return new CommonResult(true, "\u4e0a\u4f20\u6210\u529f", accessoryList);
    }

    @PostMapping(value={"/delete"})
    @ApiOperation(value="S-\u6279\u91cf\u5220\u9664\u9644\u4ef6\u4fe1\u606f", httpMethod="POST")
    public CommonResult<String> delete(@ApiParam(name="ids", value="ID\u96c6\u5408") @RequestParam(value="ids") String ids) throws Exception {
        log.info("\u901a\u7528\u9644\u4ef6\u7ba1\u7406-\u6279\u91cf\u5220\u9664\u9644\u4ef6\u4fe1\u606f\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)ids);
        Assert.notNull((Object)ids, (String)"\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        boolean state = ((AccessoryService)this.baseService).removeByIds(Arrays.asList(ids.split(",")));
        String msg = state ? "\u5220\u9664\u6210\u529f" : "\u5220\u9664\u5931\u8d25";
        log.debug("\u901a\u7528\u9644\u4ef6\u7ba1\u7406-\u6279\u91cf\u5220\u9664\u9644\u4ef6\u4fe1\u606f\u63a5\u53e3\u54cd\u5e94\u7ed3\u679c\uff1a{}", (Object)msg);
        return new CommonResult(state, msg);
    }

    @PostMapping(value={"/removeBySourceId/{sourceId}"})
    @ApiOperation(value="S-\u901a\u8fc7\u8d44\u6e90ID\u5220\u9664\u9644\u4ef6\u4fe1\u606f", httpMethod="POST")
    public CommonResult<String> removeBySourceId(@ApiParam(name="sourceId", value="\u8d44\u6e90ID") @PathVariable String sourceId) throws Exception {
        log.info("\u901a\u7528\u9644\u4ef6\u7ba1\u7406-\u901a\u8fc7\u8d44\u6e90ID\u5220\u9664\u9644\u4ef6\u4fe1\u606f\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)sourceId);
        boolean status = ((AccessoryService)this.baseService).removeBySourceId(sourceId);
        String msg = status ? "\u5220\u9664\u6210\u529f" : "\u5220\u9664\u5931\u8d25";
        log.info("\u901a\u7528\u9644\u4ef6\u7ba1\u7406-\u901a\u8fc7\u8d44\u6e90ID\u5220\u9664\u9644\u4ef6\u4fe1\u606f\u54cd\u5e94\u7ed3\u679c\uff1a{}", (Object)msg);
        return new CommonResult(true, msg);
    }

    @PostMapping(value={"/getPageBySourceId"})
    @ApiOperation(value="S-\u901a\u8fc7\u8d44\u6e90ID\u5206\u9875\u67e5\u8be2\u9644\u4ef6\u4fe1\u606f", notes="\u5fc5\u987b\u4f20\u5165SOURCE_ID_", httpMethod="POST")
    public CommonResult<PageList<Accessory>> getPageBySourceId(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5668") @RequestBody QueryFilter<Accessory> queryFilter) {
        log.info("\u901a\u7528\u9644\u4ef6\u7ba1\u7406-\u901a\u8fc7\u8d44\u6e90ID\u67e5\u8be2\u9644\u4ef6\u4fe1\u606f\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\uff1a{}", queryFilter);
        PageList<Accessory> result = ((AccessoryService)this.baseService).getAccessoryPageBySourceId(queryFilter);
        log.info("\u901a\u7528\u9644\u4ef6\u7ba1\u7406-\u901a\u8fc7\u8d44\u6e90ID\u67e5\u8be2\u9644\u4ef6\u4fe1\u606f\u54cd\u5e94\u7ed3\u679c\uff1a{}", result);
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f", result);
    }

    @ApiImplicitParams(value={@ApiImplicitParam(name="contractId", value="\u6587\u4ef6\u7f16\u53f7", dataType="String"), @ApiImplicitParam(name="sn", value="\u6587\u4ef6\u81ea\u5b9a\u4e49\u7f16\u53f7", dataType="String"), @ApiImplicitParam(name="status", value="\u6587\u4ef6\u72b6\u6001", dataType="String"), @ApiImplicitParam(name="type", value="\u56de\u8c03\u7c7b\u578b", dataType="String"), @ApiImplicitParam(name="contact", value="\u8054\u7cfb\u65b9\u5f0f", dataType="String"), @ApiImplicitParam(name="operatorName", value="\u64cd\u4f5c\u4eba\u59d3\u540d", dataType="String"), @ApiImplicitParam(name="operatorMobile", value="\u64cd\u4f5c\u4eba\u624b\u673a\u53f7", dataType="String"), @ApiImplicitParam(name="operatorNumber", value="\u64cd\u4f5c\u4eba\u5458\u5de5\u7f16\u53f7", dataType="String"), @ApiImplicitParam(name="receiverNumber", value="\u7ecf\u529e\u4eba\u5458\u5de5\u7f16\u53f7", dataType="String"), @ApiImplicitParam(name="accessKey", value="ak", dataType="String"), @ApiImplicitParam(name="secretKey", value="sk", dataType="String")})
    @PostMapping(value={"/signingCompleted"})
    @ApiOperation(value="M-\u7b7e\u7f72\u5b8c\u6210\uff08\u5408\u540c\u7cfb\u7edf\u56de\u8c03\u63a5\u53e3\uff09")
    public void signingCompleted(String contractId, String sn, String status, String type, String contact, String operatorName, String operatorMobile, String operatorNumber, String receiverNumber, String accessKey, String secretKey) {
        this.contractCallBackManager.signingCompleted(contractId, sn, status, type, contact, operatorName, operatorMobile, operatorNumber, receiverNumber, accessKey, secretKey, 2);
    }
}

