/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cgpt.purchasing.manager.impl;

import com.artfess.base.entity.BizModel;
import com.artfess.base.exception.BaseException;
import com.artfess.base.feign.SystemConfigFeignService;
import com.artfess.base.feign.UCFeignService;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.FieldRelation;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryField;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.bidding.manager.BizBidEvaluationManager;
import com.artfess.cgpt.bidding.manager.BizBidOpeningManager;
import com.artfess.cgpt.bidding.manager.BizBiddingQuotationManager;
import com.artfess.cgpt.bidding.manager.CalibrationDetailManager;
import com.artfess.cgpt.bidding.manager.CalibrationManager;
import com.artfess.cgpt.bidding.model.BizBidEvaluation;
import com.artfess.cgpt.bidding.model.BizBidOpening;
import com.artfess.cgpt.bidding.model.BizBiddingQuotation;
import com.artfess.cgpt.bidding.model.Calibration;
import com.artfess.cgpt.bidding.model.CalibrationDetail;
import com.artfess.cgpt.bidding.vo.EvaVo;
import com.artfess.cgpt.evaluation.manager.BizEvaluationSystemDescriptionManager;
import com.artfess.cgpt.evaluation.manager.BizEvaluationSystemManager;
import com.artfess.cgpt.evaluation.model.BizEvaluationSystem;
import com.artfess.cgpt.evaluation.model.BizEvaluationSystemDescription;
import com.artfess.cgpt.foreignApi.service.ForeignCallService;
import com.artfess.cgpt.foreignApi.vo.PushNoticeVO;
import com.artfess.cgpt.foreignApi.vo.WxNoticeTemplate;
import com.artfess.cgpt.project.manager.UserParticipationManager;
import com.artfess.cgpt.project.model.UserParticipation;
import com.artfess.cgpt.purchasing.dao.MatApprovalDao;
import com.artfess.cgpt.purchasing.manager.ApprovalInviteVendorManager;
import com.artfess.cgpt.purchasing.manager.MatApprovalDetailsManager;
import com.artfess.cgpt.purchasing.manager.MatApprovalManager;
import com.artfess.cgpt.purchasing.manager.MatApprovalQualificationManager;
import com.artfess.cgpt.purchasing.manager.ProjectEvaluationExpertManager;
import com.artfess.cgpt.purchasing.manager.PurchasingApplicationDetailsManager;
import com.artfess.cgpt.purchasing.manager.PurchasingApplicationManager;
import com.artfess.cgpt.purchasing.manager.QuotationTemplateDetailApprovalManager;
import com.artfess.cgpt.purchasing.manager.TenderDocumentManager;
import com.artfess.cgpt.purchasing.model.ApprovalInviteVendor;
import com.artfess.cgpt.purchasing.model.MatApproval;
import com.artfess.cgpt.purchasing.model.MatApprovalDetails;
import com.artfess.cgpt.purchasing.model.MatApprovalQualification;
import com.artfess.cgpt.purchasing.model.ProjectEvaluationExpert;
import com.artfess.cgpt.purchasing.model.PurchasingApplication;
import com.artfess.cgpt.purchasing.model.PurchasingApplicationDetails;
import com.artfess.cgpt.purchasing.model.QuotationTemplateDetailApproval;
import com.artfess.cgpt.purchasing.model.TenderDocument;
import com.artfess.cgpt.universal.model.Accessory;
import com.artfess.cgpt.universal.service.AccessoryService;
import com.artfess.cgpt.utils.BizUtils;
import com.artfess.cgpt.winbind.manager.BizWinBiddingNoticeDetaileManager;
import com.artfess.cgpt.winbind.manager.BizWinBiddingNoticeManager;
import com.artfess.cgpt.winbind.model.BizWinBiddingNotice;
import com.artfess.cgpt.winbind.model.BizWinBiddingNoticeDetaile;
import com.artfess.redis.util.RedisUtil;
import com.artfess.sysConfig.persistence.manager.SysDictionaryManager;
import com.artfess.sysConfig.persistence.param.DictModel;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IGroup;
import com.artfess.uc.api.model.IUser;
import com.artfess.uc.manager.OrgManager;
import com.artfess.uc.manager.OrgUserManager;
import com.artfess.uc.manager.UserManager;
import com.artfess.uc.model.Org;
import com.artfess.uc.model.User;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MatApprovalManagerImpl
extends BaseManagerImpl<MatApprovalDao, MatApproval>
implements MatApprovalManager {
    @Value(value="${cgpt.noticeUrl}")
    private String cgptPushNoticeUrl;
    @Value(value="${wxPublic.noticeTemplateId}")
    private String wxNoticeTemplateId;
    @Autowired
    UCFeignService ucFeignService;
    @Autowired
    SystemConfigFeignService systemConfigFeignService;
    @Autowired
    private MatApprovalDetailsManager matApprovalDetailsManager;
    @Autowired
    private QuotationTemplateDetailApprovalManager quotationTemplateDetailApprovalManager;
    @Autowired
    private TenderDocumentManager tenderDocumentManager;
    @Autowired
    private AccessoryService accessoryService;
    @Autowired
    private ProjectEvaluationExpertManager evaluationExpertManager;
    @Autowired
    private UserParticipationManager userParticipationManager;
    @Autowired
    private BizBidOpeningManager bidOpeningManager;
    @Autowired
    private ApprovalInviteVendorManager approvalInviteVendorManager;
    @Autowired
    private CalibrationManager calibraManager;
    @Autowired
    private CalibrationDetailManager calibraDetailManager;
    @Autowired
    private BizWinBiddingNoticeManager winBidNoticeManager;
    @Autowired
    private BizWinBiddingNoticeDetaileManager winBidNoticeDetailManager;
    @Autowired
    private MatApprovalQualificationManager matApprovalQualificationManager;
    @Autowired
    private PurchasingApplicationManager applicationManager;
    @Autowired
    private PurchasingApplicationDetailsManager applicationDetailsManager;
    @Autowired
    private UserManager userManager;
    @Autowired
    private BizBidEvaluationManager bidEvaluationManager;
    @Autowired
    private BizBiddingQuotationManager quotationManager;
    @Autowired
    private BizEvaluationSystemManager evaluationSystemManager;
    @Autowired
    private BizEvaluationSystemDescriptionManager evaluationSystemDescriptionManager;
    @Autowired
    private ForeignCallService foreignCallService;
    @Autowired
    private SysDictionaryManager sysDictionaryManager;
    @Autowired
    RedisUtil redisUtil;
    @Autowired
    private OrgManager orgManager;
    @Autowired
    private OrgUserManager orgUserManager;
    @Autowired
    private PurchasingApplicationManager purchasingApplicationManager;

    @Override
    public MatApproval getByIdNoTenantId(String id) {
        MatApproval result = ((MatApprovalDao)this.baseMapper).getByIdNoTenantId(id);
        return result;
    }

    @Override
    public PageList<MatApproval> queryByPage(QueryFilter<MatApproval> queryFilter) {
        BizUtils.addFilterByUserOrgAndRole(queryFilter, this.ucFeignService, "AFFILIATED_ORG_ID_");
        queryFilter.addFilter("IS_DELE_", (Object)"0", QueryOP.EQUAL);
        IPage<MatApproval> result = ((MatApprovalDao)this.baseMapper).queryAllByPage((IPage<MatApproval>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<MatApproval>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    public PageList<MatApproval> queryAllByPage(QueryFilter<MatApproval> queryFilter) {
        queryFilter.addFilter("IS_DELE_", (Object)"0", QueryOP.EQUAL);
        IPage<MatApproval> result = ((MatApprovalDao)this.baseMapper).queryAllByPage((IPage<MatApproval>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<MatApproval>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    @Transactional
    public void removeByIds(List<String> ids) {
        LambdaQueryWrapper detailsQW = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)detailsQW.in(MatApprovalDetails::getNoticeId, ids)).eq(BizModel::getIsDele, (Object)"0");
        List detailList = this.matApprovalDetailsManager.list((Wrapper)detailsQW);
        if (BeanUtils.isNotEmpty((Object)detailList) && detailList.size() > 0) {
            List purAppIds;
            List purAppDetailIds = detailList.stream().map(s -> s.getPurchasingApplicationDetailId()).distinct().collect(Collectors.toList());
            if (BeanUtils.isNotEmpty(purAppDetailIds) && purAppDetailIds.size() > 0) {
                LambdaUpdateWrapper purAppDetailUW = new LambdaUpdateWrapper();
                ((LambdaUpdateWrapper)purAppDetailUW.set(PurchasingApplicationDetails::getStatus, (Object)1)).in(PurchasingApplicationDetails::getId, purAppDetailIds);
                this.applicationDetailsManager.update((Wrapper)purAppDetailUW);
            }
            if (BeanUtils.isNotEmpty(purAppIds = detailList.stream().map(s -> s.getPurchasingApplicationId()).distinct().collect(Collectors.toList())) && purAppIds.size() > 0) {
                LambdaUpdateWrapper purAppUW = new LambdaUpdateWrapper();
                ((LambdaUpdateWrapper)((LambdaUpdateWrapper)purAppUW.set(PurchasingApplication::getStatus, (Object)3)).in(PurchasingApplication::getId, purAppIds)).eq(BizModel::getIsDele, (Object)"0");
                this.applicationManager.update((Wrapper)purAppUW);
            }
            this.matApprovalDetailsManager.remove((Wrapper)detailsQW);
        }
        super.removeByIds(ids);
    }

    @Override
    @Transactional
    public MatApproval saveOrUpdateEntity(MatApproval entity) {
        List<MatApprovalDetails> detailsList = entity.getDetailsList();
        List<QuotationTemplateDetailApproval> quotationTemplateDetailApprovalList = entity.getQuotationTemplateDetailApprovalList();
        TenderDocument zbDocument = entity.getZbDocument();
        List<ProjectEvaluationExpert> evaluationExpertList = entity.getProjectEvaluationExpertList();
        List<ApprovalInviteVendor> approvalInviteVendorList = entity.getApprovalInviteVendorList();
        List<MatApprovalQualification> matApprovalQualificationList = entity.getMatApprovalQualificationList();
        BizEvaluationSystem evaTemplate = entity.getEvaTemplate();
        if (BeanUtils.isEmpty((Object)entity.getId())) {
            entity.setProjectNumber(BizUtils.getNextSerialNumber(this.systemConfigFeignService, "cgpt_cglx"));
            if (BeanUtils.isEmpty((Object)entity.getAffiliatedUserId())) {
                entity.setAffiliatedUserId(ContextUtil.getCurrentUserId());
            }
            if (BeanUtils.isEmpty((Object)entity.getNoticeReleaseUserAccount())) {
                entity.setNoticeReleaseUserAccount(ContextUtil.getCurrentUserAccount());
            }
            IGroup org = ContextUtil.getCurrentGroup();
            entity.setAffiliatedOrgId(org.getGroupId());
            entity.setAffiliatedOrgCode(org.getGroupCode());
            entity.setAffiliatedOrgName(org.getName());
            if (entity.getReleaseStatus() == 2) {
                entity.setBidStatus(3);
            } else {
                entity.setBidStatus(2);
            }
            if (BeanUtils.isEmpty((Object)entity.getCalibraStatus())) {
                entity.setCalibraStatus(0);
            }
            if (BeanUtils.isEmpty((Object)entity.getWinNoticeStatus())) {
                entity.setWinNoticeStatus(1);
            }
            if (BeanUtils.isEmpty((Object)entity.getPublicityStatus())) {
                entity.setPublicityStatus(1);
            }
            if (BeanUtils.isEmpty((Object)entity.getAllocationOfShares())) {
                entity.setAllocationOfShares(1);
            }
        } else {
            LambdaQueryWrapper detailsQW = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)detailsQW.eq(MatApprovalDetails::getNoticeId, (Object)entity.getId())).eq(BizModel::getIsDele, (Object)"0");
            List hisDetailList = this.matApprovalDetailsManager.list((Wrapper)detailsQW);
            if (BeanUtils.isNotEmpty((Object)hisDetailList) && hisDetailList.size() > 0) {
                if (entity.getDetailSourceType() == 1) {
                    List purAppDetailIds = hisDetailList.stream().map(s -> s.getPurchasingApplicationDetailId()).distinct().collect(Collectors.toList());
                    LambdaUpdateWrapper purAppDetailUW = new LambdaUpdateWrapper();
                    ((LambdaUpdateWrapper)purAppDetailUW.set(PurchasingApplicationDetails::getStatus, (Object)1)).in(PurchasingApplicationDetails::getId, purAppDetailIds);
                    this.applicationDetailsManager.update((Wrapper)purAppDetailUW);
                    List purAppIds = hisDetailList.stream().map(s -> s.getPurchasingApplicationId()).distinct().collect(Collectors.toList());
                    LambdaUpdateWrapper purAppUW = new LambdaUpdateWrapper();
                    ((LambdaUpdateWrapper)((LambdaUpdateWrapper)purAppUW.set(PurchasingApplication::getStatus, (Object)3)).in(PurchasingApplication::getId, purAppIds)).eq(BizModel::getIsDele, (Object)"0");
                    this.applicationManager.update((Wrapper)purAppUW);
                }
                this.matApprovalDetailsManager.remove((Wrapper)detailsQW);
            }
            LambdaQueryWrapper quotationTemplateDetailApprovalQW = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)quotationTemplateDetailApprovalQW.eq(QuotationTemplateDetailApproval::getNoticeId, (Object)entity.getId())).eq(QuotationTemplateDetailApproval::getProjectApprovalType, (Object)1);
            this.quotationTemplateDetailApprovalManager.remove((Wrapper)quotationTemplateDetailApprovalQW);
            LambdaQueryWrapper evaluationExpertQW = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)evaluationExpertQW.eq(ProjectEvaluationExpert::getProjectApprovalId, (Object)entity.getId())).eq(ProjectEvaluationExpert::getProjectApprovalType, (Object)1);
            this.evaluationExpertManager.remove((Wrapper)evaluationExpertQW);
            LambdaQueryWrapper tenderDocumentQW = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)tenderDocumentQW.select(new SFunction[]{TenderDocument::getId}).eq(TenderDocument::getProjectApprovalId, (Object)entity.getId())).eq(TenderDocument::getProjectApprovalType, (Object)1)).eq(BizModel::getIsDele, (Object)"0");
            List objs = this.tenderDocumentManager.listObjs((Wrapper)tenderDocumentQW);
            if (BeanUtils.isNotEmpty((Object)objs) && objs.size() > 0) {
                List<String> tenderIds = objs.stream().map(s -> String.valueOf(s)).collect(Collectors.toList());
                this.tenderDocumentManager.removeByIds(tenderIds);
            }
            LambdaQueryWrapper approvalInviteVendorQW = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)approvalInviteVendorQW.eq(ApprovalInviteVendor::getProjectApprovalId, (Object)entity.getId())).eq(ApprovalInviteVendor::getProjectApprovalType, (Object)1);
            this.approvalInviteVendorManager.remove((Wrapper)approvalInviteVendorQW);
            LambdaQueryWrapper qualificationLabelQW = new LambdaQueryWrapper();
            qualificationLabelQW.eq(MatApprovalQualification::getProjectId, (Object)entity.getId());
            this.matApprovalQualificationManager.remove((Wrapper)qualificationLabelQW);
            LambdaQueryWrapper evaTemplateQW = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)evaTemplateQW.eq(BizEvaluationSystem::getNoticeId, (Object)entity.getId())).eq(BizEvaluationSystem::getNoticeType, (Object)1)).orderByDesc(BizEvaluationSystem::getPreparedTime)).last("limit 1");
            BizEvaluationSystem bizEvaluationSystem = (BizEvaluationSystem)((Object)this.evaluationSystemManager.getBaseMapper().selectOne((Wrapper)evaTemplateQW));
            if (BeanUtils.isNotEmpty((Object)((Object)bizEvaluationSystem))) {
                LambdaQueryWrapper evaTemplateDetailQW = new LambdaQueryWrapper();
                evaTemplateDetailQW.eq(BizEvaluationSystemDescription::getEvaluationSystemId, (Object)bizEvaluationSystem.getId());
                this.evaluationSystemDescriptionManager.remove((Wrapper)evaTemplateDetailQW);
            }
            this.evaluationSystemManager.remove((Wrapper)evaTemplateQW);
        }
        if (BeanUtils.isNotEmpty(evaluationExpertList)) {
            entity.setEvaluationExpertNumber(evaluationExpertList.size());
        }
        if (BeanUtils.isEmpty((Object)entity.getQuotationRoundsNum())) {
            entity.setQuotationRoundsNum(1);
        }
        super.saveOrUpdate((Object)entity);
        PurchasingApplication application = null;
        if (BeanUtils.isNotEmpty(detailsList) && detailsList.size() > 0) {
            detailsList.stream().forEach(s -> s.setNoticeId(entity.getId()));
            if (entity.getDetailSourceType() == 1) {
                ArrayList appIds = new ArrayList();
                List<String> disPurAppIdList = detailsList.stream().map(s -> s.getPurchasingApplicationId()).distinct().collect(Collectors.toList());
                List appDetailIds = detailsList.stream().map(s -> s.getPurchasingApplicationDetailId()).distinct().collect(Collectors.toList());
                if (BeanUtils.isNotEmpty(disPurAppIdList) && disPurAppIdList.size() > 0) {
                    disPurAppIdList.forEach(s -> {
                        LambdaQueryWrapper countQW = new LambdaQueryWrapper();
                        ((LambdaQueryWrapper)((LambdaQueryWrapper)countQW.eq(PurchasingApplicationDetails::getStatus, (Object)1)).eq(PurchasingApplicationDetails::getPurchasingApplicationId, s)).notIn(PurchasingApplicationDetails::getId, (Collection)appDetailIds);
                        if (this.applicationDetailsManager.count((Wrapper)countQW) == 0) {
                            appIds.add(s);
                        }
                    });
                }
                if (BeanUtils.isNotEmpty(appDetailIds) && appDetailIds.size() > 0) {
                    LambdaUpdateWrapper purAppDetailUW = new LambdaUpdateWrapper();
                    ((LambdaUpdateWrapper)purAppDetailUW.set(PurchasingApplicationDetails::getStatus, (Object)2)).in(PurchasingApplicationDetails::getId, appDetailIds);
                    this.applicationDetailsManager.update((Wrapper)purAppDetailUW);
                    if (appIds.size() > 0) {
                        LambdaUpdateWrapper applicationUW = new LambdaUpdateWrapper();
                        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)applicationUW.set(PurchasingApplication::getStatus, (Object)4)).in(PurchasingApplication::getId, appIds)).eq(BizModel::getIsDele, (Object)"0");
                        this.applicationManager.update((Wrapper)applicationUW);
                    }
                }
                application = (PurchasingApplication)((Object)this.applicationManager.getById((Serializable)((Object)detailsList.get(0).getPurchasingApplicationId())));
            }
            this.matApprovalDetailsManager.saveBatch(detailsList);
        }
        if (BeanUtils.isNotEmpty(quotationTemplateDetailApprovalList) && quotationTemplateDetailApprovalList.size() > 0) {
            quotationTemplateDetailApprovalList.stream().forEach(s -> {
                s.setId(null);
                s.setProjectApprovalType(1);
                s.setNoticeId(entity.getId());
            });
            this.quotationTemplateDetailApprovalManager.saveBatch(quotationTemplateDetailApprovalList);
        }
        if (BeanUtils.isEmpty(evaluationExpertList) || evaluationExpertList.size() <= 0) {
            evaluationExpertList = new ArrayList<ProjectEvaluationExpert>();
            ProjectEvaluationExpert temp = new ProjectEvaluationExpert();
            if (entity.getDetailSourceType() == 1 && application.getIsAgencyProcure() == 0) {
                temp.setEvaluatorType(2);
                temp.setExpertId(application.getPreparedUserId());
                temp.setFullname(application.getPreparedUserName());
                temp.setAccount(((User)this.userManager.getById((Serializable)((Object)application.getPreparedUserId()))).getAccount());
            } else {
                IUser currentUser = ContextUtil.getCurrentUser();
                temp.setEvaluatorType(3);
                temp.setExpertId(currentUser.getUserId());
                temp.setFullname(currentUser.getFullname());
                temp.setAccount(currentUser.getAccount());
            }
            evaluationExpertList.add(temp);
        }
        if (evaluationExpertList.size() > 0) {
            evaluationExpertList.stream().forEach(s -> {
                s.setId(null);
                s.setProjectApprovalId(entity.getId());
                s.setProjectApprovalType(1);
            });
            this.evaluationExpertManager.saveBatch(evaluationExpertList);
        }
        ArrayList<Accessory> accessoryData = new ArrayList<Accessory>();
        if (BeanUtils.isNotEmpty((Object)((Object)zbDocument))) {
            List<Accessory> accessoryList = zbDocument.getAccessoryList();
            zbDocument.setProjectApprovalType(1);
            zbDocument.setProjectApprovalId(entity.getId());
            zbDocument.setReleaseStatus(2);
            this.tenderDocumentManager.save((Object)zbDocument);
            accessoryList.stream().forEach(accessory -> accessory.setSourceId(zbDocument.getId()));
            accessoryData.addAll(accessoryList);
        }
        this.accessoryService.saveBatch(accessoryData);
        if (BeanUtils.isNotEmpty(approvalInviteVendorList) && approvalInviteVendorList.size() > 0) {
            approvalInviteVendorList.stream().forEach(s -> {
                s.setProjectApprovalId(entity.getId());
                s.setProjectApprovalType(1);
            });
            this.approvalInviteVendorManager.saveBatch(approvalInviteVendorList);
        }
        if (BeanUtils.isNotEmpty(matApprovalQualificationList) && matApprovalQualificationList.size() > 0) {
            matApprovalQualificationList.stream().forEach(s -> s.setProjectId(entity.getId()));
            this.matApprovalQualificationManager.saveBatch(matApprovalQualificationList);
        }
        if (BeanUtils.isNotEmpty((Object)((Object)evaTemplate))) {
            evaTemplate.setNoticeId(entity.getId());
            evaTemplate.setNoticeType(1);
            evaTemplate.setEvaType(1);
            evaTemplate.setPreparedOrgId(ContextUtil.getCurrentOrgId());
            evaTemplate.setPreparedTime(LocalDateTime.now());
            List<BizEvaluationSystemDescription> descriptionList = evaTemplate.getDescriptionList();
            this.evaluationSystemManager.save((Object)evaTemplate);
            descriptionList.stream().forEach(s -> s.setEvaluationSystemId(evaTemplate.getId()));
            this.evaluationSystemDescriptionManager.saveBatch(descriptionList);
            LambdaUpdateWrapper matApprovalUW = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)((LambdaUpdateWrapper)matApprovalUW.set(MatApproval::getEvaluationTemplateId, (Object)evaTemplate.getId())).eq(MatApproval::getId, (Object)entity.getId())).eq(BizModel::getIsDele, (Object)"0");
            super.update((Wrapper)matApprovalUW);
        }
        return entity;
    }

    @Override
    @Transactional
    public void uploadTenderDoc(MatApproval entity) {
        List<TenderDocument> byDocumentList = entity.getByDocument();
        if (BeanUtils.isNotEmpty(byDocumentList) && byDocumentList.size() > 0) {
            for (TenderDocument byDocument : byDocumentList) {
                List<Accessory> accessoryList = byDocument.getAccessoryList();
                if (!BeanUtils.isNotEmpty(accessoryList) || accessoryList.size() <= 0) continue;
                byDocument.setProjectApprovalType(1);
                byDocument.setType(2);
                byDocument.setReleaseStatus(1);
                byDocument.setProjectApprovalId(entity.getId());
                this.tenderDocumentManager.save((Object)byDocument);
                accessoryList.stream().forEach(accessory -> accessory.setSourceId(byDocument.getId()));
                this.accessoryService.saveBatch(accessoryList);
            }
        }
    }

    @Override
    @Transactional
    public void modifyBidStatus(String ids, String status) {
        List<String> idList = Arrays.asList(ids.split(","));
        LambdaUpdateWrapper approvalUW = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)approvalUW.set(MatApproval::getBidStatus, (Object)status)).in(MatApproval::getId, idList)).eq(BizModel::getIsDele, (Object)"0");
        super.update((Wrapper)approvalUW);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public void modifyReleaseStatus(String ids, String status) {
        LocalDateTime nowTime = LocalDateTime.now();
        List<String> idList = Arrays.asList(ids.split(","));
        LambdaUpdateWrapper approvalUW = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)approvalUW.set(MatApproval::getReleaseStatus, (Object)status)).in(MatApproval::getId, idList)).eq(BizModel::getIsDele, (Object)"0");
        if (status.equals("2")) {
            ((LambdaUpdateWrapper)approvalUW.set(MatApproval::getBidStatus, (Object)3)).set(MatApproval::getNoticeReleaseTime, (Object)nowTime);
        }
        if (status.equals("3")) {
            LambdaQueryWrapper userParticipationQW = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)userParticipationQW.in(UserParticipation::getNoticeId, idList)).notIn(UserParticipation::getStatus, Arrays.asList("5,6"))).eq(BizModel::getIsDele, (Object)"0");
            if (this.userParticipationManager.count((Wrapper)userParticipationQW) > 0) {
                throw new BaseException("\u5df2\u6709\u7528\u6237\u53c2\u4e0e\u62a5\u540d\uff0c\u4e0b\u67b6\u5931\u8d25");
            }
            ((LambdaUpdateWrapper)approvalUW.set(MatApproval::getBidStatus, (Object)2)).set(MatApproval::getNoticeOffTime, (Object)LocalDateTime.now());
        }
        super.update((Wrapper)approvalUW);
        if (status.equals("2")) {
            LambdaQueryWrapper matApprovalQW = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)matApprovalQW.in(MatApproval::getId, idList)).eq(BizModel::getIsDele, (Object)"0");
            List matApprovalList = super.list((Wrapper)matApprovalQW);
            List cglxDic = this.sysDictionaryManager.queryDictListItemsByCode("cglx-cglx");
            for (MatApproval notice : matApprovalList) {
                String noticeRedisKey = "matApproval:" + notice.getId();
                long endTime = notice.getResponseTimeDeadline().toEpochSecond(ZoneOffset.of("+8"));
                long currentTime = nowTime.toEpochSecond(ZoneOffset.of("+8"));
                this.redisUtil.set(noticeRedisKey, (Object)0, endTime - currentTime - 60L);
                this.redisUtil.set("backups" + noticeRedisKey, (Object)0);
                try {
                    PushNoticeVO mhNoticeVO = new PushNoticeVO();
                    mhNoticeVO.setProjectCode(notice.getProjectNumber());
                    mhNoticeVO.setContent(notice.getEstablishmentName());
                    mhNoticeVO.setNoticeTitle(notice.getNoticeTitle());
                    mhNoticeVO.setAffCompany(notice.getProcureOrgName());
                    if (notice.getProcureType() == 2) {
                        mhNoticeVO.setNoticeType(2);
                    } else if (notice.getProcureType() == 4) {
                        mhNoticeVO.setNoticeType(3);
                    } else {
                        mhNoticeVO.setNoticeType(1);
                    }
                    mhNoticeVO.setCategory(1);
                    mhNoticeVO.setReleaseTime(notice.getNoticeReleaseTime());
                    mhNoticeVO.setStartRegistrationTime(notice.getNoticeReleaseTime());
                    mhNoticeVO.setEndRegistrationTime(notice.getResponseTimeDeadline());
                    mhNoticeVO.setStartAuctionTime(notice.getBiddingStartTime());
                    mhNoticeVO.setEndAuctionTime(notice.getBiddingEndTime());
                    mhNoticeVO.setStatus(1);
                    mhNoticeVO.setDetailedUrl(this.cgptPushNoticeUrl + notice.getId());
                    this.foreignCallService.pushNoticeToMh(mhNoticeVO);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.out.println("\u7acb\u9879\u516c\u544a\u53d1\u5e03\u5230\u95e8\u6237\u5931\u8d25\uff1a" + e.getMessage());
                }
                String wxResult = "";
                try {
                    DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                    String s = notice.getProcureType().toString();
                    String cglxStr = BizUtils.getDicValueByCode((List<DictModel>)cglxDic, s);
                    WxNoticeTemplate wxTemplate = new WxNoticeTemplate(notice.getProcureOrgName(), notice.getNoticeTitle(), cglxStr, notice.getNoticeReleaseTime().format(formatter));
                    wxTemplate.setTemplateId(this.wxNoticeTemplateId);
                    wxResult = this.foreignCallService.pushWxMessage(wxTemplate).toString();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    wxResult = e.getMessage();
                }
                finally {
                    System.out.println("\u63a8\u9001\u7acb\u9879\u516c\u544a\u5230\u5fae\u4fe1\u516c\u4f17\u53f7\uff1a" + wxResult);
                }
            }
        }
    }

    @Override
    @Transactional
    public void modifyCalibraStatus(String ids, String status) {
        List<String> idList = Arrays.asList(ids.split(","));
        List matApprovals = super.listByIds(idList);
        Integer evaStatus = null;
        evaStatus = status.equals("1") ? Integer.valueOf(2) : (status.equals("2") ? Integer.valueOf(3) : Integer.valueOf(1));
        for (MatApproval approval : matApprovals) {
            List evaList;
            QueryFilter evaQF;
            if (approval.getEvaluationMethod() == 1) {
                evaQF = QueryFilter.build();
                evaQF.setPageBean(new PageBean(Integer.valueOf(0), Integer.valueOf(-1), Boolean.valueOf(false)));
                evaQF.addFilter("a.NOTICE_ID_", (Object)approval.getId(), QueryOP.EQUAL);
                evaList = this.bidEvaluationManager.getCalibraDetailById((QueryFilter<BizBidEvaluation>)evaQF).getRows();
                LambdaUpdateWrapper evaUW = new LambdaUpdateWrapper();
                ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)evaUW.set(BizBidEvaluation::getStatus, (Object)evaStatus)).in(BizBidEvaluation::getNoticeId, idList)).eq(BizBidEvaluation::getNoticeType, (Object)1)).eq(BizModel::getIsDele, (Object)"0");
                this.bidEvaluationManager.update((Wrapper)evaUW);
                continue;
            }
            if (approval.getEvaluationMode() == 1) {
                evaQF = QueryFilter.build();
                evaQF.setPageBean(new PageBean(Integer.valueOf(0), Integer.valueOf(-1), Boolean.valueOf(false)));
                evaQF.addFilter("a.NOTICE_ID_", (Object)approval.getId(), QueryOP.EQUAL);
                evaList = this.bidEvaluationManager.getCalibraDetailComprehensive((QueryFilter<BizBidEvaluation>)evaQF).getRows();
                Integer finalEvaStatus = evaStatus;
                evaList.stream().forEach(s -> s.setStatus(finalEvaStatus));
                this.bidEvaluationManager.updateBatchById(evaList);
                continue;
            }
            List<BizBidEvaluation> evaList2 = this.bidEvaluationManager.getCalibraDetailMaxScoreById(approval.getId());
            Integer finalEvaStatus = evaStatus;
            evaList2.stream().forEach(s -> s.setStatus(finalEvaStatus));
            this.bidEvaluationManager.updateBatchById(evaList2);
        }
        LambdaUpdateWrapper approvalUW = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)approvalUW.set(MatApproval::getCalibraStatus, (Object)status)).in(MatApproval::getId, idList)).eq(BizModel::getIsDele, (Object)"0");
        super.update((Wrapper)approvalUW);
    }

    @Override
    @Transactional
    public void modifyPublicityStatus(String ids, String status) {
        LambdaUpdateWrapper approvalUW = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)approvalUW.set(MatApproval::getPublicityStatus, (Object)status)).in(MatApproval::getId, Arrays.asList(ids.split(",")))).eq(BizModel::getIsDele, (Object)"0");
        super.update((Wrapper)approvalUW);
    }

    @Override
    public MatApproval getDataById(String id) {
        MatApproval result = (MatApproval)((Object)super.getById((Serializable)((Object)id)));
        LambdaQueryWrapper detailsQW = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)detailsQW.eq(MatApprovalDetails::getNoticeId, (Object)id)).eq(BizModel::getIsDele, (Object)"0");
        result.setDetailsList(this.matApprovalDetailsManager.list((Wrapper)detailsQW));
        LambdaQueryWrapper quotationTemplateDetailApprovalQW = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)quotationTemplateDetailApprovalQW.eq(QuotationTemplateDetailApproval::getNoticeId, (Object)id)).eq(QuotationTemplateDetailApproval::getProjectApprovalType, (Object)1)).eq(BizModel::getIsDele, (Object)"0");
        result.setQuotationTemplateDetailApprovalList(this.quotationTemplateDetailApprovalManager.list((Wrapper)quotationTemplateDetailApprovalQW));
        LambdaQueryWrapper evaluationExpertQW = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)evaluationExpertQW.eq(ProjectEvaluationExpert::getProjectApprovalId, (Object)id)).eq(ProjectEvaluationExpert::getProjectApprovalType, (Object)1)).eq(BizModel::getIsDele, (Object)"0");
        result.setProjectEvaluationExpertList(this.evaluationExpertManager.list((Wrapper)evaluationExpertQW));
        LambdaQueryWrapper approvalInviteVendorQW = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)approvalInviteVendorQW.eq(ApprovalInviteVendor::getProjectApprovalId, (Object)id)).eq(ApprovalInviteVendor::getProjectApprovalType, (Object)1);
        result.setApprovalInviteVendorList(this.approvalInviteVendorManager.list((Wrapper)approvalInviteVendorQW));
        LambdaQueryWrapper qualificationLabelQW = new LambdaQueryWrapper();
        qualificationLabelQW.eq(MatApprovalQualification::getProjectId, (Object)id);
        result.setMatApprovalQualificationList(this.matApprovalQualificationManager.list((Wrapper)qualificationLabelQW));
        LambdaQueryWrapper tenderDocumentQW = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)tenderDocumentQW.eq(TenderDocument::getProjectApprovalId, (Object)id)).eq(TenderDocument::getProjectApprovalType, (Object)1)).isNotNull(TenderDocument::getType)).eq(BizModel::getIsDele, (Object)"0");
        List documentList = this.tenderDocumentManager.list((Wrapper)tenderDocumentQW);
        if (BeanUtils.isNotEmpty((Object)documentList) && documentList.size() > 0) {
            List<TenderDocument> byDocument;
            Map<Integer, List<TenderDocument>> collect = documentList.stream().collect(Collectors.groupingBy(TenderDocument::getType));
            List<TenderDocument> zbDocument = collect.get(1);
            if (BeanUtils.isNotEmpty(zbDocument) && zbDocument.size() > 0) {
                TenderDocument tenderDocument = zbDocument.get(0);
                tenderDocument.setAccessoryList(this.accessoryService.getAccessoryBySourceId(tenderDocument.getId()));
                result.setZbDocument(tenderDocument);
            }
            if (BeanUtils.isNotEmpty(byDocument = collect.get(2)) && byDocument.size() > 0) {
                byDocument.stream().forEach(s -> s.setAccessoryList(this.accessoryService.getAccessoryBySourceId(s.getId())));
                result.setByDocument(byDocument);
            }
        }
        LambdaQueryWrapper evaluationSystemQW = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)evaluationSystemQW.eq(BizEvaluationSystem::getNoticeId, (Object)result.getId())).eq(BizEvaluationSystem::getNoticeType, (Object)1)).orderByDesc(BizEvaluationSystem::getPreparedTime)).last("limit 1");
        BizEvaluationSystem evaluationSystem = (BizEvaluationSystem)((Object)this.evaluationSystemManager.getBaseMapper().selectOne((Wrapper)evaluationSystemQW));
        if (BeanUtils.isNotEmpty((Object)((Object)evaluationSystem))) {
            LambdaQueryWrapper descriptionQW = new LambdaQueryWrapper();
            descriptionQW.eq(BizEvaluationSystemDescription::getEvaluationSystemId, (Object)evaluationSystem.getId());
            evaluationSystem.setDescriptionList(this.evaluationSystemDescriptionManager.list((Wrapper)descriptionQW));
            result.setEvaTemplate(evaluationSystem);
        }
        return result;
    }

    @Override
    public MatApproval getReleaseDataById(String id) {
        MatApproval result = (MatApproval)((Object)super.getById((Serializable)((Object)id)));
        LambdaQueryWrapper detailsQW = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)detailsQW.eq(MatApprovalDetails::getNoticeId, (Object)id)).eq(BizModel::getIsDele, (Object)"0");
        result.setDetailsList(this.matApprovalDetailsManager.list((Wrapper)detailsQW));
        LambdaQueryWrapper quotationTemplateDetailApprovalQW = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)quotationTemplateDetailApprovalQW.eq(QuotationTemplateDetailApproval::getNoticeId, (Object)id)).eq(QuotationTemplateDetailApproval::getProjectApprovalType, (Object)1)).eq(BizModel::getIsDele, (Object)"0");
        result.setQuotationTemplateDetailApprovalList(this.quotationTemplateDetailApprovalManager.list((Wrapper)quotationTemplateDetailApprovalQW));
        LambdaQueryWrapper evaluationExpertQW = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)evaluationExpertQW.eq(ProjectEvaluationExpert::getProjectApprovalId, (Object)id)).eq(ProjectEvaluationExpert::getProjectApprovalType, (Object)1)).eq(BizModel::getIsDele, (Object)"0");
        result.setProjectEvaluationExpertList(this.evaluationExpertManager.list((Wrapper)evaluationExpertQW));
        LambdaQueryWrapper approvalInviteVendorQW = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)approvalInviteVendorQW.eq(ApprovalInviteVendor::getProjectApprovalId, (Object)id)).eq(ApprovalInviteVendor::getProjectApprovalType, (Object)1);
        result.setApprovalInviteVendorList(this.approvalInviteVendorManager.list((Wrapper)approvalInviteVendorQW));
        LambdaQueryWrapper tenderDocumentQW = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)tenderDocumentQW.eq(TenderDocument::getProjectApprovalId, (Object)id)).eq(TenderDocument::getProjectApprovalType, (Object)1)).eq(TenderDocument::getReleaseStatus, (Object)2)).isNotNull(TenderDocument::getType)).eq(BizModel::getIsDele, (Object)"0");
        List documentList = this.tenderDocumentManager.list((Wrapper)tenderDocumentQW);
        if (BeanUtils.isNotEmpty((Object)documentList) && documentList.size() > 0) {
            List<TenderDocument> byDocument;
            Map<Integer, List<TenderDocument>> collect = documentList.stream().collect(Collectors.groupingBy(TenderDocument::getType));
            List<TenderDocument> zbDocument = collect.get(1);
            if (BeanUtils.isNotEmpty(zbDocument) && zbDocument.size() > 0) {
                TenderDocument tenderDocument = zbDocument.get(0);
                tenderDocument.setAccessoryList(this.accessoryService.getAccessoryBySourceId(tenderDocument.getId()));
                result.setZbDocument(tenderDocument);
            }
            if (BeanUtils.isNotEmpty(byDocument = collect.get(2)) && byDocument.size() > 0) {
                byDocument.stream().forEach(s -> s.setAccessoryList(this.accessoryService.getAccessoryBySourceId(s.getId())));
                result.setByDocument(byDocument);
            }
        }
        LambdaQueryWrapper evaluationSystemQW = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)evaluationSystemQW.eq(BizEvaluationSystem::getNoticeId, (Object)result.getId())).eq(BizEvaluationSystem::getNoticeType, (Object)1)).orderByDesc(BizEvaluationSystem::getPreparedTime)).last("limit 1");
        BizEvaluationSystem evaluationSystem = (BizEvaluationSystem)((Object)this.evaluationSystemManager.getBaseMapper().selectOne((Wrapper)evaluationSystemQW));
        if (BeanUtils.isNotEmpty((Object)((Object)evaluationSystem))) {
            LambdaQueryWrapper descriptionQW = new LambdaQueryWrapper();
            descriptionQW.eq(BizEvaluationSystemDescription::getEvaluationSystemId, (Object)evaluationSystem.getId());
            evaluationSystem.setDescriptionList(this.evaluationSystemDescriptionManager.list((Wrapper)descriptionQW));
            result.setEvaTemplate(evaluationSystem);
        }
        return result;
    }

    @Override
    public PageList<MatApproval> signData(QueryFilter<MatApproval> queryFilter) {
        IPage<MatApproval> result;
        List records;
        Integer joinStatus = 0;
        List querys = queryFilter.getQuerys();
        if (BeanUtils.isNotEmpty((Object)querys) && querys.size() > 0) {
            for (QueryField qf : querys) {
                if (!qf.getProperty().equals("joinStatus")) continue;
                if ((Integer)qf.getValue() == 1) {
                    joinStatus = 1;
                }
                qf.setProperty("1");
                qf.setValue((Object)"1");
            }
        }
        queryFilter.addFilter("IS_DELE_", (Object)"0", QueryOP.EQUAL);
        ArrayList<String> noticeIds = new ArrayList<String>();
        QueryWrapper userPartNoticeQW = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)userPartNoticeQW.select(new String[]{"DISTINCT NOTICE_ID_"}).lambda().eq(UserParticipation::getCompanyId, (Object)ContextUtil.getCurrentOrgId())).eq(UserParticipation::getNoticeType, (Object)1)).eq(UserParticipation::getStatus, (Object)1)).eq(BizModel::getIsDele, (Object)0);
        if (joinStatus == 1) {
            List noticeIdObjs = this.userParticipationManager.listObjs((Wrapper)userPartNoticeQW);
            if (BeanUtils.isNotEmpty((Object)noticeIdObjs) && noticeIdObjs.size() > 0) {
                noticeIds.addAll(noticeIdObjs.stream().map(s -> String.valueOf(s)).collect(Collectors.toList()));
            }
        } else {
            List<String> list = ((MatApprovalDao)this.baseMapper).queryIds((Wrapper<MatApproval>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
            if (BeanUtils.isEmpty(list) || list.size() <= 0) {
                return new PageList(new ArrayList());
            }
            userPartNoticeQW.lambda().in(UserParticipation::getNoticeId, list);
            List noticeIdObjs = this.userParticipationManager.listObjs((Wrapper)userPartNoticeQW);
            if (BeanUtils.isNotEmpty((Object)noticeIdObjs) && noticeIdObjs.size() > 0) {
                list.removeAll(noticeIdObjs.stream().map(s -> String.valueOf(s)).collect(Collectors.toList()));
            }
            noticeIds.addAll(list);
        }
        if (noticeIds.size() > 0) {
            queryFilter.addFilter("ID_", noticeIds, QueryOP.IN, FieldRelation.OR, "yq");
        }
        if (BeanUtils.isNotEmpty((Object)(records = (result = ((MatApprovalDao)this.baseMapper).queryAllByPage((IPage<MatApproval>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<MatApproval>)this.convert2Wrapper(queryFilter, this.currentModelClass()))).getRecords())) && records.size() > 0) {
            if (joinStatus == 1) {
                records.forEach(s -> s.setJoinStatus(1));
            } else {
                for (MatApproval notice : records) {
                    LambdaQueryWrapper userParticipationQW = new LambdaQueryWrapper();
                    ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)userParticipationQW.eq(UserParticipation::getCompanyId, (Object)ContextUtil.getCurrentOrgId())).eq(UserParticipation::getNoticeType, (Object)1)).eq(UserParticipation::getNoticeId, (Object)notice.getId())).eq(BizModel::getIsDele, (Object)0)).last("limit 1");
                    UserParticipation participation = (UserParticipation)((Object)this.userParticipationManager.getBaseMapper().selectOne((Wrapper)userParticipationQW));
                    if (BeanUtils.isNotEmpty((Object)((Object)participation)) && BeanUtils.isNotEmpty((Object)participation.getStatus())) {
                        notice.setJoinStatus(participation.getStatus());
                        notice.setPartId(participation.getId());
                        continue;
                    }
                    notice.setJoinStatus(0);
                }
            }
        }
        return new PageList(result);
    }

    @Override
    public MatApproval getInfoById(String id) {
        MatApproval result = (MatApproval)((Object)super.getById((Serializable)((Object)id)));
        LambdaQueryWrapper tenderDocumentQW = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)tenderDocumentQW.eq(TenderDocument::getProjectApprovalId, (Object)id)).eq(TenderDocument::getProjectApprovalType, (Object)1)).eq(TenderDocument::getReleaseStatus, (Object)2)).isNotNull(TenderDocument::getType)).eq(BizModel::getIsDele, (Object)"0");
        List documentList = this.tenderDocumentManager.list((Wrapper)tenderDocumentQW);
        if (BeanUtils.isNotEmpty((Object)documentList) && documentList.size() > 0) {
            List<TenderDocument> byDocument;
            Map<Integer, List<TenderDocument>> collect = documentList.stream().collect(Collectors.groupingBy(TenderDocument::getType));
            List<TenderDocument> zbDocument = collect.get(1);
            if (BeanUtils.isNotEmpty(zbDocument) && zbDocument.size() > 0) {
                TenderDocument tenderDocument = zbDocument.get(0);
                tenderDocument.setAccessoryList(this.accessoryService.getAccessoryBySourceId(tenderDocument.getId()));
                result.setZbDocument(tenderDocument);
            }
            if (BeanUtils.isNotEmpty(byDocument = collect.get(2)) && byDocument.size() > 0) {
                byDocument.stream().forEach(s -> s.setAccessoryList(this.accessoryService.getAccessoryBySourceId(s.getId())));
                result.setByDocument(byDocument);
            }
        }
        result.setJoinStatus(0);
        IUser currentUserOrNull = ContextUtil.getCurrentUserOrNull();
        if (BeanUtils.isNotEmpty((Object)currentUserOrNull)) {
            LambdaQueryWrapper userParticipationQW = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)userParticipationQW.eq(UserParticipation::getCompanyId, (Object)ContextUtil.getCurrentOrgId())).eq(UserParticipation::getNoticeType, (Object)1)).eq(UserParticipation::getNoticeId, (Object)result.getId())).eq(BizModel::getIsDele, (Object)0)).last("limit 1");
            UserParticipation participation = (UserParticipation)((Object)this.userParticipationManager.getBaseMapper().selectOne((Wrapper)userParticipationQW));
            if (BeanUtils.isNotEmpty((Object)((Object)participation)) && BeanUtils.isNotEmpty((Object)participation.getStatus())) {
                result.setJoinStatus(participation.getStatus());
            }
        }
        return result;
    }

    @Override
    public MatApproval getInfoByIdAndUserId(String id, String userId) {
        List orgList;
        MatApproval result = (MatApproval)((Object)super.getById((Serializable)((Object)id)));
        LambdaQueryWrapper tenderDocumentQW = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)tenderDocumentQW.eq(TenderDocument::getProjectApprovalId, (Object)id)).eq(TenderDocument::getProjectApprovalType, (Object)1)).eq(TenderDocument::getReleaseStatus, (Object)2)).isNotNull(TenderDocument::getType)).eq(BizModel::getIsDele, (Object)"0");
        List documentList = this.tenderDocumentManager.list((Wrapper)tenderDocumentQW);
        if (BeanUtils.isNotEmpty((Object)documentList) && documentList.size() > 0) {
            List<TenderDocument> byDocument;
            Map<Integer, List<TenderDocument>> collect = documentList.stream().collect(Collectors.groupingBy(TenderDocument::getType));
            List<TenderDocument> zbDocument = collect.get(1);
            if (BeanUtils.isNotEmpty(zbDocument) && zbDocument.size() > 0) {
                TenderDocument tenderDocument = zbDocument.get(0);
                tenderDocument.setAccessoryList(this.accessoryService.getAccessoryBySourceId(tenderDocument.getId()));
                result.setZbDocument(tenderDocument);
            }
            if (BeanUtils.isNotEmpty(byDocument = collect.get(2)) && byDocument.size() > 0) {
                byDocument.stream().forEach(s -> s.setAccessoryList(this.accessoryService.getAccessoryBySourceId(s.getId())));
                result.setByDocument(byDocument);
            }
        }
        result.setJoinStatus(0);
        if (BeanUtils.isNotEmpty((Object)userId) && BeanUtils.isNotEmpty((Object)(orgList = this.orgManager.getOrgListByUserId(userId))) && orgList.size() > 0) {
            String orgId = ((Org)orgList.get(0)).getId();
            List orgIds = orgList.stream().filter(s -> BeanUtils.isNotEmpty((Object)s.getIsMaster()) && s.getIsMaster() == 1).map(s -> s.getId()).collect(Collectors.toList());
            if (BeanUtils.isNotEmpty(orgIds) && orgIds.size() > 0) {
                orgId = (String)orgIds.get(0);
            }
            LambdaQueryWrapper userParticipationQW = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)userParticipationQW.eq(UserParticipation::getCompanyId, (Object)orgId)).eq(UserParticipation::getNoticeType, (Object)1)).eq(UserParticipation::getNoticeId, (Object)result.getId())).eq(BizModel::getIsDele, (Object)0)).last("limit 1");
            UserParticipation participation = (UserParticipation)((Object)this.userParticipationManager.getBaseMapper().selectOne((Wrapper)userParticipationQW));
            if (BeanUtils.isNotEmpty((Object)((Object)participation)) && BeanUtils.isNotEmpty((Object)participation.getStatus())) {
                result.setJoinStatus(participation.getStatus());
            }
        }
        return result;
    }

    @Override
    public PageList<MatApproval> quoData(QueryFilter<MatApproval> queryFilter) {
        queryFilter.addFilter("notice.RELEASE_STATUS_", (Object)"2", QueryOP.EQUAL);
        queryFilter.addFilter("notice.IS_DELE_", (Object)"0", QueryOP.EQUAL);
        queryFilter.addFilter("notice.BID_STATUS_", (Object)"3", QueryOP.EQUAL);
        queryFilter.addFilter("part.IS_DELE_", (Object)"0", QueryOP.EQUAL);
        queryFilter.addFilter("part.NOTICE_TYPE_", (Object)1, QueryOP.EQUAL);
        queryFilter.addFilter("part.STATUS_", (Object)1, QueryOP.EQUAL);
        queryFilter.addFilter("part.COMPANY_ID_", (Object)ContextUtil.getCurrentOrgId(), QueryOP.EQUAL);
        queryFilter.addFilter("notice.BIDDING_END_TIME_", (Object)LocalDateTime.now(), QueryOP.GREAT_EQUAL);
        IPage<MatApproval> result = ((MatApprovalDao)this.baseMapper).getQuoData((IPage<MatApproval>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<MatApproval>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        List records = result.getRecords();
        if (BeanUtils.isNotEmpty((Object)records) && records.size() > 0) {
            records.stream().forEach(s -> {
                LambdaQueryWrapper quoQW = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)quoQW.eq(BizBiddingQuotation::getQuotationRounds, (Object)s.getQuotationRoundsNum())).eq(BizBiddingQuotation::getNoticeId, (Object)s.getId())).eq(BizBiddingQuotation::getNoticeType, (Object)1)).eq(BizBiddingQuotation::getQuotationCompanyId, (Object)ContextUtil.getCurrentOrgId());
                if (this.quotationManager.count((Wrapper)quoQW) > 0) {
                    s.setIsQuo(1);
                } else {
                    s.setIsQuo(0);
                }
            });
        }
        return new PageList(result);
    }

    @Override
    public PageList<MatApproval> quoManageData(QueryFilter<MatApproval> queryFilter) {
        queryFilter.addFilter("IS_DELE_", (Object)"0", QueryOP.EQUAL);
        queryFilter.addFilter("RELEASE_STATUS_", (Object)"2", QueryOP.EQUAL);
        if (BizUtils.isAdmin(this.ucFeignService)) {
            LambdaQueryWrapper applicationQW = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)applicationQW.select(new SFunction[]{PurchasingApplication::getId}).eq(PurchasingApplication::getPreparedOrgId, (Object)ContextUtil.getCurrentOrgId())).eq(PurchasingApplication::getIsAgencyProcure, (Object)1)).eq(BizModel::getIsDele, (Object)"0");
            List objectList = this.purchasingApplicationManager.listObjs((Wrapper)applicationQW);
            if (BeanUtils.isNotEmpty((Object)objectList) && objectList.size() > 0) {
                List applicationId = objectList.stream().map(s -> String.valueOf(s)).collect(Collectors.toList());
                QueryWrapper noticeIdsQW = new QueryWrapper();
                ((LambdaQueryWrapper)noticeIdsQW.select(new String[]{"distinct NOTICE_ID_"}).lambda().in(MatApprovalDetails::getPurchasingApplicationId, applicationId)).eq(BizModel::getIsDele, (Object)"0");
                List noticeIdObjs = this.matApprovalDetailsManager.listObjs((Wrapper)noticeIdsQW);
                if (BeanUtils.isNotEmpty((Object)noticeIdObjs) && noticeIdObjs.size() > 0) {
                    List noticeIds = noticeIdObjs.stream().map(s -> String.valueOf(s)).collect(Collectors.toList());
                    queryFilter.addFilter("ID_", noticeIds, QueryOP.IN, FieldRelation.OR, "org");
                }
            }
            queryFilter.addFilter("AFFILIATED_ORG_ID_", (Object)ContextUtil.getCurrentOrgId(), QueryOP.EQUAL, FieldRelation.OR, "org");
            queryFilter.addFilter("PROCURE_ORG_ID_", (Object)ContextUtil.getCurrentOrgId(), QueryOP.EQUAL, FieldRelation.OR, "org");
            QueryWrapper quoQW = new QueryWrapper();
            ((LambdaQueryWrapper)quoQW.select(new String[]{"DISTINCT NOTICE_ID_"}).lambda().eq(BizBiddingQuotation::getQuotationCompanyId, (Object)ContextUtil.getCurrentOrgId())).eq(BizBiddingQuotation::getNoticeType, (Object)1);
            List quoNoticeIdsObj = this.quotationManager.listObjs((Wrapper)quoQW);
            if (BeanUtils.isNotEmpty((Object)quoNoticeIdsObj) && quoNoticeIdsObj.size() > 0) {
                List collect = quoNoticeIdsObj.stream().map(s -> String.valueOf(s)).collect(Collectors.toList());
                queryFilter.addFilter("ID_", collect, QueryOP.IN, FieldRelation.OR, "org");
            }
        }
        IPage<MatApproval> result = ((MatApprovalDao)this.baseMapper).queryAllByPage((IPage<MatApproval>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<MatApproval>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    public PageList<MatApproval> bidOpenData(QueryFilter<MatApproval> queryFilter) {
        queryFilter.addFilter("RELEASE_STATUS_", (Object)"2", QueryOP.EQUAL);
        queryFilter.addFilter("IS_DELE_", (Object)"0", QueryOP.EQUAL);
        BizUtils.addFilterByUserOrgAndRole(queryFilter, this.ucFeignService, "AFFILIATED_ORG_ID_");
        IPage<MatApproval> result = ((MatApprovalDao)this.baseMapper).queryAllByPage((IPage<MatApproval>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<MatApproval>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    @Transactional
    public void openingBid(MatApproval entity) {
        List<ProjectEvaluationExpert> evaluationExpertList = entity.getProjectEvaluationExpertList();
        if (BeanUtils.isNotEmpty(evaluationExpertList) && evaluationExpertList.size() > 0) {
            LambdaQueryWrapper evaluationExpertQW = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)evaluationExpertQW.eq(ProjectEvaluationExpert::getProjectApprovalId, (Object)entity.getId())).eq(ProjectEvaluationExpert::getProjectApprovalType, (Object)1);
            this.evaluationExpertManager.remove((Wrapper)evaluationExpertQW);
            evaluationExpertList.stream().forEach(s -> {
                s.setId(null);
                s.setProjectApprovalId(entity.getId());
                s.setProjectApprovalType(1);
            });
            this.evaluationExpertManager.saveBatch(evaluationExpertList);
        }
        BizBidOpening bidOpening = new BizBidOpening();
        bidOpening.setOperateType(1);
        bidOpening.setOperateTime(LocalDateTime.now());
        bidOpening.setOperateUserId(ContextUtil.getCurrentUserId());
        bidOpening.setOperateUserAccount(ContextUtil.getCurrentUserAccount());
        bidOpening.setOperateUserName(ContextUtil.getCurrentUserName());
        bidOpening.setQuotationRounds(entity.getQuotationRoundsNum());
        bidOpening.setOperateMethod(1);
        bidOpening.setNoticeId(entity.getId());
        bidOpening.setNoticeType(1);
        bidOpening.setNoticeCode(entity.getProjectNumber());
        bidOpening.setOperateUserName(entity.getNoticeTitle());
        bidOpening.setEvaluationMethod(entity.getEvaluationMethod());
        this.bidOpeningManager.save((Object)bidOpening);
        Integer noticeStatus = 5;
        LambdaQueryWrapper quoQW = new LambdaQueryWrapper();
        quoQW.eq(BizBiddingQuotation::getNoticeId, (Object)entity.getId());
        if (this.quotationManager.count((Wrapper)quoQW) == 0) {
            noticeStatus = 8;
            LambdaUpdateWrapper approvalDetailUW = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)((LambdaUpdateWrapper)approvalDetailUW.set(MatApprovalDetails::getBidStatus, (Object)6)).eq(MatApprovalDetails::getNoticeId, (Object)entity.getId())).eq(BizModel::getIsDele, (Object)"0");
            this.matApprovalDetailsManager.update((Wrapper)approvalDetailUW);
        }
        LambdaUpdateWrapper approvalUW = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)approvalUW.set(MatApproval::getBidStatus, (Object)noticeStatus)).set(BeanUtils.isNotEmpty((Object)entity.getEvaluationMethod()), MatApproval::getEvaluationMethod, (Object)entity.getEvaluationMethod()).set(MatApproval::getEvaluationStartTime, (Object)bidOpening.getOperateTime())).eq(MatApproval::getId, (Object)entity.getId())).eq(BizModel::getIsDele, (Object)"0");
        super.update((Wrapper)approvalUW);
        if (entity.getEvaluationMethod() == 1 && entity.getEvaluationMode() == 1) {
            EvaVo evaVo = new EvaVo();
            evaVo.setNoticeId(entity.getId());
            evaVo.setNoticeType("1");
            this.bidEvaluationManager.bidEvaLowestAuto(evaVo);
        }
    }

    @Override
    @Transactional
    public void newRoundQuo(MatApproval entity) {
        MatApproval notice = (MatApproval)((Object)super.getById((Serializable)((Object)entity.getId())));
        BizBidOpening bidOpening = new BizBidOpening();
        Integer roundsNum = BeanUtils.isNotEmpty((Object)notice.getQuotationRoundsNum()) ? notice.getQuotationRoundsNum() : 1;
        if (entity.getBidStatus() == 3) {
            if (notice.getBidStatus() != 5 && notice.getBidStatus() != 6) {
                throw new BaseException("\u5f53\u524d\u9879\u76ee\u72b6\u6001\u65e0\u6cd5\u53d1\u8d77\u65b0\u4e00\u8f6e\u62a5\u4ef7");
            }
            if (BeanUtils.isNotEmpty((Object)notice.getCalibraStatus()) && notice.getCalibraStatus() != 0) {
                throw new BaseException("\u5df2\u53d1\u8d77\u5b9a\u6807\u5ba1\u6279\uff0c\u65e0\u6cd5\u53d1\u8d77\u65b0\u4e00\u8f6e\u62a5\u4ef7");
            }
            notice.setBiddingStartTime(entity.getBiddingStartTime());
            notice.setBiddingEndTime(entity.getBiddingEndTime());
            notice.setQuotationRoundsNum(roundsNum + 1);
            if (BeanUtils.isNotEmpty((Object)entity.getNewQuoReason())) {
                notice.setNewQuoReason(entity.getNewQuoReason());
                bidOpening.setRemarks(entity.getNewQuoReason());
            }
            bidOpening.setOperateType(3);
        } else if (entity.getBidStatus() == 8) {
            if (BeanUtils.isNotEmpty((Object)notice.getCalibraStatus()) && notice.getCalibraStatus() != 0) {
                throw new BaseException("\u5df2\u53d1\u8d77\u5b9a\u6807\u5ba1\u6279\uff0c\u65e0\u6cd5\u6d41\u6807");
            }
            if (BeanUtils.isNotEmpty((Object)entity.getFailBidReason())) {
                notice.setFailBidReason(entity.getFailBidReason());
                bidOpening.setRemarks(entity.getFailBidReason());
            }
            bidOpening.setOperateType(2);
        }
        notice.setBidStatus(entity.getBidStatus());
        super.updateById((Object)notice);
        bidOpening.setOperateTime(LocalDateTime.now());
        bidOpening.setOperateUserId(ContextUtil.getCurrentUserId());
        bidOpening.setOperateUserAccount(ContextUtil.getCurrentUserAccount());
        bidOpening.setOperateUserName(ContextUtil.getCurrentUserName());
        bidOpening.setQuotationRounds(roundsNum);
        bidOpening.setOperateMethod(1);
        bidOpening.setNoticeId(notice.getId());
        bidOpening.setNoticeType(1);
        bidOpening.setNoticeCode(notice.getProjectNumber());
        bidOpening.setOperateUserName(notice.getNoticeTitle());
        bidOpening.setEvaluationMethod(notice.getEvaluationMethod());
        this.bidOpeningManager.save((Object)bidOpening);
    }

    @Override
    public PageList<MatApproval> bidEvaData(QueryFilter<MatApproval> queryFilter) {
        queryFilter.addFilter("IS_DELE_", (Object)"0", QueryOP.EQUAL);
        List<String> idList = ((MatApprovalDao)this.baseMapper).queryIds((Wrapper<MatApproval>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        if (BeanUtils.isEmpty(idList) || idList.size() <= 0) {
            return new PageList(this.convert2IPage(queryFilter.getPageBean()));
        }
        QueryWrapper evaExpertQW = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)evaExpertQW.select(new String[]{"distinct PROJECT_APPROVAL_ID_"}).lambda().eq(ProjectEvaluationExpert::getAccount, (Object)ContextUtil.getCurrentUserAccount())).eq(ProjectEvaluationExpert::getProjectApprovalType, (Object)"1")).in(ProjectEvaluationExpert::getProjectApprovalId, idList)).eq(BizModel::getIsDele, (Object)"0");
        List noticeIdObjs = this.evaluationExpertManager.listObjs((Wrapper)evaExpertQW);
        if (BeanUtils.isEmpty((Object)noticeIdObjs) || noticeIdObjs.size() <= 0) {
            return new PageList();
        }
        List noticeIds = noticeIdObjs.stream().map(s -> String.valueOf(s)).collect(Collectors.toList());
        queryFilter.addFilter("ID_", noticeIds, QueryOP.IN);
        IPage<MatApproval> result = ((MatApprovalDao)this.baseMapper).queryAllByPage((IPage<MatApproval>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<MatApproval>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    @Transactional
    public void releaseWinBidNotice(String id) throws Exception {
        MatApproval approval = (MatApproval)((Object)super.getById((Serializable)((Object)id)));
        approval.setBidStatus(11);
        super.updateById((Object)approval);
        LambdaQueryWrapper calibraQW = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)calibraQW.eq(Calibration::getNoticeId, (Object)id)).eq(Calibration::getNoticeType, (Object)1)).eq(BizModel::getIsDele, (Object)"0");
        List calibraList = this.calibraManager.list((Wrapper)calibraQW);
        if (BeanUtils.isNotEmpty((Object)calibraList) && calibraList.size() > 0) {
            ArrayList<BizWinBiddingNoticeDetaile> winNoticeDetailList = new ArrayList<BizWinBiddingNoticeDetaile>();
            for (Calibration ca : calibraList) {
                BizWinBiddingNotice winNotice = new BizWinBiddingNotice();
                BeanUtils.copyNotNullProperties((Object)((Object)winNotice), (Object)((Object)ca));
                winNotice.setId(null);
                winNotice.setProcureOrgId(approval.getProcureOrgId());
                winNotice.setProcureOrgCode(approval.getProcureOrgCode());
                winNotice.setProcureOrgName(approval.getProcureOrgName());
                winNotice.setSendTime(LocalDateTime.now());
                winNotice.setStatus(1);
                this.winBidNoticeManager.save((Object)winNotice);
                LambdaQueryWrapper caDetailQW = new LambdaQueryWrapper();
                caDetailQW.eq(CalibrationDetail::getCalibrationId, (Object)ca.getId());
                List caDetailList = this.calibraDetailManager.list((Wrapper)caDetailQW);
                if (!BeanUtils.isNotEmpty((Object)caDetailList) || caDetailList.size() <= 0) continue;
                for (CalibrationDetail caDetail : caDetailList) {
                    BizWinBiddingNoticeDetaile winNoticeDetail = new BizWinBiddingNoticeDetaile();
                    BeanUtils.copyNotNullProperties((Object)((Object)winNoticeDetail), (Object)((Object)caDetail));
                    winNoticeDetail.setId(null);
                    winNoticeDetail.setWinNoticeId(winNotice.getId());
                    winNoticeDetail.setApplicationMethod(approval.getProcureType());
                    winNoticeDetail.setIsTax(approval.getIsTax());
                    winNoticeDetail.setStatus(1);
                    winNoticeDetailList.add(winNoticeDetail);
                }
            }
            if (winNoticeDetailList.size() > 0) {
                this.winBidNoticeDetailManager.saveBatch(winNoticeDetailList);
            }
        }
    }

    @Override
    public PageList<MatApproval> bidEvaAgencyData(QueryFilter<MatApproval> queryFilter) {
        LambdaQueryWrapper applicationQW = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)applicationQW.select(new SFunction[]{PurchasingApplication::getId}).eq(PurchasingApplication::getPreparedOrgId, (Object)ContextUtil.getCurrentOrgId())).eq(PurchasingApplication::getIsAgencyProcure, (Object)1)).eq(BizModel::getIsDele, (Object)"0");
        List objectList = this.purchasingApplicationManager.listObjs((Wrapper)applicationQW);
        if (BeanUtils.isEmpty((Object)objectList) || objectList.size() <= 0) {
            return new PageList(new ArrayList());
        }
        List applicationId = objectList.stream().map(s -> String.valueOf(s)).collect(Collectors.toList());
        QueryWrapper noticeIdsQW = new QueryWrapper();
        ((LambdaQueryWrapper)noticeIdsQW.select(new String[]{"distinct NOTICE_ID_"}).lambda().in(MatApprovalDetails::getPurchasingApplicationId, applicationId)).eq(BizModel::getIsDele, (Object)"0");
        List noticeIdObjs = this.matApprovalDetailsManager.listObjs((Wrapper)noticeIdsQW);
        if (BeanUtils.isEmpty((Object)noticeIdObjs) || noticeIdObjs.size() <= 0) {
            return new PageList(new ArrayList());
        }
        List noticeIds = noticeIdObjs.stream().map(s -> String.valueOf(s)).collect(Collectors.toList());
        queryFilter.addFilter("ID_", noticeIds, QueryOP.IN);
        queryFilter.addFilter("IS_DELE_", (Object)"0", QueryOP.EQUAL);
        IPage<MatApproval> result = ((MatApprovalDao)this.baseMapper).queryAllByPage((IPage<MatApproval>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<MatApproval>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    public Integer getNoticeTypeById(String id) {
        if (BeanUtils.isEmpty((Object)super.getById((Serializable)((Object)id)))) {
            return 2;
        }
        return 1;
    }
}

