/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cgpt.material.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.material.dao.MaterialHierarchicalManagementDao;
import com.artfess.cgpt.material.manager.MaterialHierarchicalManagementManager;
import com.artfess.cgpt.material.model.MaterialHierarchicalManagement;
import com.artfess.cgpt.material.vo.MaterialHierarchicalManagementQueryVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class MaterialHierarchicalManagementManagerImpl
extends BaseManagerImpl<MaterialHierarchicalManagementDao, MaterialHierarchicalManagement>
implements MaterialHierarchicalManagementManager {
    private MaterialHierarchicalManagementDao materialHierarchicalManagementDao;

    @Override
    public PageList<MaterialHierarchicalManagementQueryVo> queryAllByPage(QueryFilter<MaterialHierarchicalManagement> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        Class currentModelClass = this.currentModelClass();
        IPage<MaterialHierarchicalManagementQueryVo> result = this.materialHierarchicalManagementDao.queryAllByPage((IPage<MaterialHierarchicalManagement>)this.convert2IPage(pageBean), (Wrapper<MaterialHierarchicalManagement>)this.convert2Wrapper(queryFilter, currentModelClass));
        List records = result.getRecords();
        PageList materialHierarchicalManagementQueryVoPageList = new PageList(result);
        materialHierarchicalManagementQueryVoPageList.setRows(this.getChildren(records));
        return materialHierarchicalManagementQueryVoPageList;
    }

    @Override
    public List<MaterialHierarchicalManagementQueryVo> queryAllByParentId(String parentId) {
        return this.materialHierarchicalManagementDao.queryAllByParentId(parentId);
    }

    @Override
    public int countByMatId(MaterialHierarchicalManagement t) {
        if (null == t) {
            return 0;
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)"IS_DELE_", (Object)"0")).eq((Object)"MAT_ID_", (Object)t.getMatId())).eq((Object)"PARENT_ID_", (Object)t.getParentId());
        int count = this.count((Wrapper)queryWrapper);
        return count;
    }

    @Override
    public List<MaterialHierarchicalManagement> getParentById(String id) {
        MaterialHierarchicalManagement mh = (MaterialHierarchicalManagement)((Object)this.getById((Serializable)((Object)id)));
        if (null == mh) {
            return new ArrayList<MaterialHierarchicalManagement>();
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"IS_DELE_", (Object)"0")).eq((Object)"PARENT_ID_", (Object)mh.getId());
        List materialHierarchicalList = this.list((Wrapper)queryWrapper);
        return this.getParent(materialHierarchicalList, materialHierarchicalList);
    }

    private List<MaterialHierarchicalManagement> getParent(List<MaterialHierarchicalManagement> resultList, List<MaterialHierarchicalManagement> list) {
        if (null == list || list.size() == 0) {
            return list;
        }
        for (MaterialHierarchicalManagement t : list) {
            if (StringUtils.isBlank((CharSequence)t.getParentId()) || t.getParentId().equalsIgnoreCase("root")) continue;
            QueryWrapper queryWrapper = new QueryWrapper();
            ((QueryWrapper)queryWrapper.eq((Object)"IS_DELE_", (Object)"0")).eq((Object)"PARENT_ID_", (Object)t.getId());
            List materialHierarchicalList = this.list((Wrapper)queryWrapper);
            if (null == materialHierarchicalList || materialHierarchicalList.size() <= 0) continue;
            resultList.addAll(materialHierarchicalList);
            this.getParent(resultList, materialHierarchicalList);
        }
        return resultList;
    }

    private List getChildren(List<MaterialHierarchicalManagementQueryVo> list) {
        if (null == list || list.size() == 0) {
            return list;
        }
        for (MaterialHierarchicalManagementQueryVo m : list) {
            List<MaterialHierarchicalManagementQueryVo> materialHierarchicalList = this.materialHierarchicalManagementDao.queryAllByParentId(m.getId());
            if (null == list || list.size() <= 0) continue;
            this.getChildren(materialHierarchicalList);
            m.setChildren(materialHierarchicalList);
        }
        return list;
    }
}

