/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cgpt.material.controller;

import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.exception.BaseException;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.material.manager.MaterialHierarchicalManagementManager;
import com.artfess.cgpt.material.manager.MaterialHierarchicalManagementRangeManager;
import com.artfess.cgpt.material.model.MaterialHierarchicalManagement;
import com.artfess.cgpt.material.model.MaterialHierarchicalManagementRange;
import com.artfess.cgpt.material.vo.MaterialHierarchicalManagementQueryVo;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/material/bizMaterialHierarchicalManagement/v1/"})
public class MaterialHierarchicalManagementController
extends BaseController<MaterialHierarchicalManagementManager, MaterialHierarchicalManagement> {
    @Resource
    private MaterialHierarchicalManagementRangeManager materialHierarchicalManagementRangeManager;

    @PostMapping(value={"/"})
    @ApiOperation(value="\u6dfb\u52a0\u6570\u636e\u7684\u63a5\u53e3")
    public CommonResult<String> create(@ApiParam(name="model", value="\u6570\u636e\u4fe1\u606f") @RequestBody MaterialHierarchicalManagement t) {
        if (((MaterialHierarchicalManagementManager)this.baseService).countByMatId(t) > 0) {
            throw new BaseException("\u7269\u6599\u4ee5\u5b58\u5728\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0\uff01");
        }
        try {
            boolean result = ((MaterialHierarchicalManagementManager)this.baseService).save((Object)t);
            List<MaterialHierarchicalManagementRange> materialHierarchicalManagementRangelList = t.getMaterialHierarchicalManagementRangelList();
            if (null != materialHierarchicalManagementRangelList && materialHierarchicalManagementRangelList.size() > 0) {
                materialHierarchicalManagementRangelList.forEach(obj -> obj.setMaterialHierarchicalId(t.getId()));
                this.materialHierarchicalManagementRangeManager.saveBatch(materialHierarchicalManagementRangelList);
            }
        }
        catch (Exception e) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)e.getMessage());
        }
        return new CommonResult(true, "\u6570\u636e\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @PostMapping(value={"/batch"})
    @ApiOperation(value="\u6279\u91cf\u6dfb\u52a0\u6570\u636e\u7684\u63a5\u53e3")
    public CommonResult<String> createBatch(@ApiParam(name="model", value="\u6570\u636e\u4fe1\u606f") @RequestBody List<MaterialHierarchicalManagement> list) {
        try {
            Iterator<MaterialHierarchicalManagement> iter = list.iterator();
            while (iter.hasNext()) {
                MaterialHierarchicalManagement t = iter.next();
                if (((MaterialHierarchicalManagementManager)this.baseService).countByMatId(t) <= 0) continue;
                iter.remove();
            }
            boolean result = ((MaterialHierarchicalManagementManager)this.baseService).saveBatch(list);
            ArrayList<MaterialHierarchicalManagementRange> saveMaterialHierarchicalManagementRangeList = new ArrayList<MaterialHierarchicalManagementRange>();
            for (MaterialHierarchicalManagement t : list) {
                List<MaterialHierarchicalManagementRange> materialHierarchicalManagementRangelList = t.getMaterialHierarchicalManagementRangelList();
                if (null == materialHierarchicalManagementRangelList || materialHierarchicalManagementRangelList.size() <= 0) continue;
                materialHierarchicalManagementRangelList.forEach(obj -> obj.setMaterialHierarchicalId(t.getId()));
                saveMaterialHierarchicalManagementRangeList.addAll(materialHierarchicalManagementRangelList);
            }
            if (saveMaterialHierarchicalManagementRangeList.size() > 0) {
                this.materialHierarchicalManagementRangeManager.saveBatch(saveMaterialHierarchicalManagementRangeList);
            }
        }
        catch (Exception e) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)e.getMessage());
        }
        return new CommonResult(true, "\u6570\u636e\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @PostMapping(value={"/queryAllByPage"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u5206\u7ea7\u7269\u6599\u6570\u636e")
    public PageList<MaterialHierarchicalManagementQueryVo> queryAllByPage(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<MaterialHierarchicalManagement> queryFilter) {
        return ((MaterialHierarchicalManagementManager)this.baseService).queryAllByPage(queryFilter);
    }

    @PostMapping(value={"/queryAllByParentId"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4e0d\u5206\u9875\u67e5\u8be2\u4e0b\u7ea7\u7269\u6599\u6570\u636e")
    public List<MaterialHierarchicalManagementQueryVo> queryAllByParentId(@ApiParam(name="parentId", value="\u4e0d\u5206\u9875\u67e5\u8be2\u4e0b\u7ea7\u7269\u6599\u6570\u636e") @RequestParam String parentId) {
        return ((MaterialHierarchicalManagementManager)this.baseService).queryAllByParentId(parentId);
    }

    @GetMapping(value={"/{id}"})
    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2\u6570\u636e")
    public MaterialHierarchicalManagement getById(@ApiParam(name="id", value="\u6570\u636eid") @PathVariable String id) {
        MaterialHierarchicalManagement t = (MaterialHierarchicalManagement)((Object)((MaterialHierarchicalManagementManager)this.baseService).getById((Serializable)((Object)id)));
        if (null != t) {
            t.setMaterialHierarchicalManagementRangelList(this.materialHierarchicalManagementRangeManager.queryListByMaterialHierarchicalId(id));
        }
        return t;
    }

    @GetMapping(value={"/getParentById"})
    @ApiOperation(value="\u6839\u636eid\u9012\u5f52\u67e5\u8be2\u6240\u6709\u7236\u7ea7\u6570\u636e\u96c6\u5408")
    public List<MaterialHierarchicalManagement> getParentById(@ApiParam(name="id", value="\u6570\u636e\u96c6\u5408") @RequestParam String id) {
        List<MaterialHierarchicalManagement> list = ((MaterialHierarchicalManagementManager)this.baseService).getParentById(id);
        return list;
    }

    @PutMapping(value={"/"})
    @ApiOperation(value="\u66f4\u65b0\u6570\u636e")
    public CommonResult<String> updateById(@ApiParam(name="model", value="\u6570\u636e\u4fe1\u606f") @RequestBody MaterialHierarchicalManagement t) {
        try {
            boolean result = ((MaterialHierarchicalManagementManager)this.baseService).updateById((Object)t);
            this.materialHierarchicalManagementRangeManager.deleteByMaterialHierarchicalId(t.getId());
            List<MaterialHierarchicalManagementRange> materialHierarchicalManagementRangelList = t.getMaterialHierarchicalManagementRangelList();
            if (null != materialHierarchicalManagementRangelList && materialHierarchicalManagementRangelList.size() > 0) {
                materialHierarchicalManagementRangelList.forEach(obj -> obj.setMaterialHierarchicalId(t.getId()));
                this.materialHierarchicalManagementRangeManager.saveBatch(materialHierarchicalManagementRangelList);
            }
        }
        catch (Exception e) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)e.getMessage());
        }
        return new CommonResult(true, "\u6570\u636e\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @DeleteMapping(value={"/{id}"})
    @ApiOperation(value="\u6839\u636eid\u5220\u9664")
    public CommonResult<String> deleteById(@ApiParam(name="id", value="\u6570\u636eid") @PathVariable String id) {
        boolean result = ((MaterialHierarchicalManagementManager)this.baseService).removeById((Serializable)((Object)id));
        this.materialHierarchicalManagementRangeManager.deleteByMaterialHierarchicalId(id);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u5220\u9664\u6570\u636e\u5931\u8d25");
        }
        return new CommonResult(true, "\u6570\u636e\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @DeleteMapping(value={"/"})
    @ApiOperation(value="\u6839\u636eid\u96c6\u5408\u6279\u91cf\u5220\u9664")
    public CommonResult<String> deleteByIds(String ... ids) {
        boolean result = ((MaterialHierarchicalManagementManager)this.baseService).removeByIds(Arrays.asList(ids));
        this.materialHierarchicalManagementRangeManager.deleteByMaterialHierarchicalIds(Arrays.asList(ids));
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u5220\u9664\u6570\u636e\u5931\u8d25");
        }
        return new CommonResult(true, "\u6570\u636e\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @DeleteMapping(value={"/deleteByIdList"})
    @ApiOperation(value="\u6839\u636eid\u96c6\u5408\u6279\u91cf\u5220\u9664")
    public CommonResult<String> deleteByIdList(@ApiParam(name="ids", value="\u6570\u636e\u96c6\u5408") @RequestParam List<String> ids) {
        boolean result = ((MaterialHierarchicalManagementManager)this.baseService).removeByIds(ids);
        this.materialHierarchicalManagementRangeManager.deleteByMaterialHierarchicalIds(ids);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u5220\u9664\u6570\u636e\u5931\u8d25");
        }
        return new CommonResult(true, "\u6570\u636e\u64cd\u4f5c\u6210\u529f\uff01");
    }
}

