/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cgpt.foreignApi.controller;

import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.foreignApi.service.ForeignCallService;
import com.artfess.cgpt.foreignApi.vo.Response;
import com.artfess.cgpt.foreignApi.vo.WxNoticeTemplate;
import com.artfess.cgpt.material.manager.BizMaterialCategoryManager;
import com.artfess.cgpt.material.manager.BizMaterialManager;
import com.artfess.cgpt.purchasing.manager.PurchasingApplicationManager;
import com.artfess.cgpt.purchasing.model.MatApprovalDetails;
import com.artfess.cgpt.supplier.manager.EnterpriseManager;
import com.artfess.cgpt.utils.HttpUtil;
import com.artfess.uc.manager.OrgManager;
import com.artfess.uc.model.User;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5bf9\u5916\u63a5\u53e3"})
@ApiGroup(group={"group_biz"})
@RequestMapping(value={"api"})
public class ForeignApiController {
    @Value(value="${zsj.checkTokenKeyUrl}")
    private String checkTokenKeyUrl;
    @Value(value="${zsj.getUserByTokenUrl}")
    private String getUserByTokenUrl;
    @Autowired
    private ForeignCallService foreignCallService;
    @Autowired
    private EnterpriseManager enterpriseManager;
    @Autowired
    private OrgManager orgManager;
    @Autowired
    private BizMaterialCategoryManager matCategoryManager;
    @Autowired
    private BizMaterialManager materialManager;
    @Autowired
    private PurchasingApplicationManager purchasingApplicationManager;

    @PostMapping(value={"/valid/{tokenKey}"})
    @ApiOperation(value="M-\u8c03\u7528\u95e8\u6237\u7f51\u7ad9\u6821\u9a8ctokenKey", httpMethod="POST")
    public CommonResult validTokenKey(@PathVariable String tokenKey) throws Exception {
        if (BeanUtils.isEmpty((Object)tokenKey)) {
            return new CommonResult(false, "tokenKey\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tokenKey", tokenKey);
        String token = HttpUtil.get(this.checkTokenKeyUrl, map);
        com.alibaba.fastjson.JSONObject jsonObject = JSON.parseObject((String)token);
        Object value = jsonObject.get((Object)"value");
        if (BeanUtils.isEmpty((Object)value)) {
            return new CommonResult(false, "\u65e0\u6548\u7684token");
        }
        HashMap<String, String> tokenMap = new HashMap<String, String>();
        tokenMap.put("Authorization", "Bearer " + value.toString());
        String userInfo = HttpUtil.post(this.getUserByTokenUrl, null, tokenMap, "application/json", 3000, 3000, "UTF-8");
        com.alibaba.fastjson.JSONObject userJsonObject = JSON.parseObject((String)userInfo);
        Object resultObj = userJsonObject.get((Object)"value");
        if (BeanUtils.isEmpty((Object)resultObj)) {
            return new CommonResult(false, "\u65e0\u6548\u7684token");
        }
        com.alibaba.fastjson.JSONObject result = JSON.parseObject((String)resultObj.toString());
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f", (Object)result);
    }

    @GetMapping(value={"/createTokenKey"})
    @ApiOperation(value="M-\u521b\u5efatokenKey\u5e76\u5b58\u5165redis")
    public CommonResult createTokenKey() {
        String tokenKey = this.foreignCallService.createTokenKey();
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f", (Object)tokenKey);
    }

    @GetMapping(value={"/checkTokenKey"})
    @ApiOperation(value="M-\u6821\u9a8ctokenKey\u5e76\u8fd4\u56detoken")
    public CommonResult checkTokenKey(@RequestParam(name="tokenKey") String tokenKey) {
        if (BeanUtils.isEmpty((Object)tokenKey)) {
            return new CommonResult(false, "\u65e0\u6548\u7684tokenKey");
        }
        CommonResult result = this.foreignCallService.checkToken(tokenKey);
        return result;
    }

    @PostMapping(value={"/getUserByToken"})
    @ApiOperation(value="M-\u6839\u636etoken\u83b7\u53d6\u7528\u6237\u4fe1\u606f")
    public CommonResult getUserByToken() {
        return this.foreignCallService.getUserByTOKEN();
    }

    @PostMapping(value={"/pushSucBidNotice"})
    @ApiOperation(value="M-\u63a8\u9001\u4e2d\u9009\u516c\u793a\u5230\u95e8\u6237\uff08\u7269\u8d44\uff09")
    public CommonResult pushSucBidNotice(@RequestBody List<MatApprovalDetails> detailedList) {
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f");
    }

    @PostMapping(value={"/setMasterOrg"})
    @ApiOperation(value="M-\u53d8\u66f4\u4eba\u5458\u4e3b\u7ec4\u7ec7", httpMethod="POST")
    public Response setMasterOrg(@RequestBody JSONObject param) {
        try {
            this.orgManager.setMaster(param.get((Object)"account").toString(), param.get((Object)"orgCode").toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.error("601", e.getMessage());
        }
        return Response.ok();
    }

    @PostMapping(value={"/pushWxMessage"})
    @ApiOperation(value="M-\u63a8\u9001\u5fae\u4fe1\u516c\u4f17\u53f7\u6d88\u606f", httpMethod="POST")
    public Response pushWxMessage(@RequestBody WxNoticeTemplate wxNoticeTemplate) {
        JSONObject result = this.foreignCallService.pushWxMessage(wxNoticeTemplate);
        return Response.ok(result);
    }

    @PostMapping(value={"/user/query"})
    @ApiOperation(value="M-\u83b7\u53d6\u4e3b\u6570\u636e\u7528\u6237\u4fe1\u606f")
    public CommonResult queryUser(@RequestBody User queryVO) {
        JSONObject result = this.foreignCallService.queryUser(queryVO);
        if (BeanUtils.isNotEmpty((Object)result)) {
            if (BeanUtils.isNotEmpty((Object)result.getStr((Object)"code"))) {
                if (result.getStr((Object)"code").equals("0")) {
                    return new CommonResult(true, "\u67e5\u8be2\u6210\u529f", result.get((Object)"data"));
                }
                return new CommonResult(false, "\u67e5\u8be2\u5931\u8d25\uff1a" + result.getStr((Object)"msg"));
            }
            return new CommonResult(false, "\u67e5\u8be2\u5931\u8d25\uff1a" + result);
        }
        return new CommonResult(false, "\u67e5\u8be2\u5931\u8d25");
    }

    @PostMapping(value={"/matCategory/saveOrUpdate"})
    @ApiOperation(value="\u7269\u6599\u5206\u7c7b\u5bfc\u5165")
    public Response saveOrUpdateMatCategory(@RequestBody JSONObject param) {
        System.out.println("\u5bfc\u5165\u7269\u6599\u5206\u7c7b\u62a5\u6587:" + JSONUtil.toJsonStr((cn.hutool.json.JSON)param));
        return this.matCategoryManager.saveOrUpdateByApi(param);
    }

    @PostMapping(value={"/material/saveOrUpdate"})
    @ApiOperation(value="\u7269\u6599\u6570\u636e\u5bfc\u5165")
    public Response saveOrUpdateMaterial(@RequestBody JSONObject param) {
        System.out.println("\u5bfc\u5165\u7269\u6599\u62a5\u6587:" + JSONUtil.toJsonStr((cn.hutool.json.JSON)param));
        return this.materialManager.saveOrUpdateByApi(param);
    }

    @PostMapping(value={"/enterprise/saveOrUpdate"})
    @ApiOperation(value="M-\u4fdd\u5b58\u6216\u66f4\u65b0\u7ec4\u7ec7")
    public Response saveOrUpdateEnterprise(@RequestBody JSONObject param) {
        System.out.println("\u5bfc\u5165\u7ec4\u7ec7\u62a5\u6587:" + JSONUtil.toJsonStr((cn.hutool.json.JSON)param));
        return this.enterpriseManager.saveOrUpdateByApi(param);
    }

    @PostMapping(value={"/user/saveOrUpdate"})
    @ApiOperation(value="M-\u4fdd\u5b58\u6216\u66f4\u65b0\u7528\u6237")
    public Response saveOrUpdateUser(@RequestBody JSONObject param) {
        System.out.println("\u5bfc\u5165\u7528\u6237\u62a5\u6587:" + JSONUtil.toJsonStr((cn.hutool.json.JSON)param));
        return this.enterpriseManager.saveOrUpdateUserByApi(param);
    }

    @PostMapping(value={"/pur/saveOrUpdate"})
    @ApiOperation(value="M-\u4fdd\u5b58\u6216\u66f4\u65b0\u91c7\u8d2d\u7533\u8bf7\u5355")
    public Response saveOrUpdatePur(@RequestBody JSONObject param) {
        System.out.println("\u5bfc\u5165\u91c7\u8d2d\u7533\u8bf7\u5355\u62a5\u6587:" + JSONUtil.toJsonStr((cn.hutool.json.JSON)param));
        return this.purchasingApplicationManager.saveOrUpdateByApi(param);
    }
}

