/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.base.webSocket;

import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.artfess.base.conf.NettyConfig;
import com.artfess.base.jwt.JwtTokenHandler;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.DateUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.TokenUtils;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelId;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketCloseStatus;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.LinkedHashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
@ChannelHandler.Sharable
public class WebSocketHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger log = LoggerFactory.getLogger(WebSocketHandler.class);
    public static int online;
    private WebSocketServerHandshaker handshaker;
    String wsFactoryUri = "";
    @Value(value="${netty.ws.endPoint:/websocket}")
    private String wsUri;

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        log.trace("\u3010webSocket\u3011\uff1ahandlerAdded \u88ab\u8c03\u7528" + ctx.channel().id().asLongText());
        NettyConfig.getChannelGroup().add((Object)ctx.channel());
        online = NettyConfig.getChannelGroup().size();
        log.info("\u3010webSocket\u3011\uff1a" + ctx.channel().remoteAddress() + "\u4e0a\u7ebf\u4e86!");
        log.trace("\u3010webSocket\u3011\uff1a========\u4e0a\u7ebf\u7ebf\uff1a\u5728\u7ebf\u4eba\u6570\uff1a" + online + "!========");
        ctx.channel().id();
        log.trace("\u3010webSocket\u3011\uff1a========" + ctx.channel().id() + "!========");
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof FullHttpRequest) {
            this.handleHttpRequest(ctx, (FullHttpRequest)msg);
        } else if (msg instanceof WebSocketFrame) {
            this.handlerWebSocketFrame(ctx, (WebSocketFrame)msg);
        }
    }

    public void handlerWebSocketFrame(ChannelHandlerContext ctx, WebSocketFrame frame) throws Exception {
        if (frame instanceof CloseWebSocketFrame) {
            this.handshaker.close(ctx.channel(), (CloseWebSocketFrame)frame.retain());
            return;
        }
        if (frame instanceof PingWebSocketFrame) {
            ctx.channel().write((Object)new PongWebSocketFrame(frame.content().retain()));
            return;
        }
        if (frame instanceof TextWebSocketFrame) {
            String jsrAccounts;
            TextWebSocketFrame txFrame = (TextWebSocketFrame)frame;
            log.trace("\u3010webSocket\u3011\uff1a\u670d\u52a1\u5668\u63a5\u6536\u5230\uff1a{}", (Object)("\u6765\u81ea\uff1a\u3010" + ctx.channel().remoteAddress() + "\u3011 \u7684\u6570\u636e\uff1a" + txFrame.text()));
            JSONObject jsonObject = JSONUtil.parseObj((String)txFrame.text());
            String messageType = jsonObject.getStr((Object)"messageType");
            String account = jsonObject.getStr((Object)"account");
            if (StringUtil.isNotEmpty(account)) {
                Set<ChannelId> channelIdList = NettyConfig.getUserChanIdMap().get(account);
                if (BeanUtils.isNotEmpty(channelIdList)) {
                    channelIdList.add(ctx.channel().id());
                } else {
                    channelIdList = new LinkedHashSet<ChannelId>();
                    channelIdList.add(ctx.channel().id());
                    NettyConfig.getUserChanIdMap().put(account, channelIdList);
                }
            }
            if (messageType.equals("heartcheck")) {
                com.alibaba.fastjson.JSONObject obj = new com.alibaba.fastjson.JSONObject();
                obj.put("msgTxt", (Object)("\u5fc3\u8df3\u54cd\u5e94\u65f6\u95f4\uff1a" + DateUtils.now()));
                ctx.channel().writeAndFlush((Object)new TextWebSocketFrame(obj.toJSONString()));
            } else if (messageType.equals("topic")) {
                NettyConfig.getChannelGroup().writeAndFlush((Object)new TextWebSocketFrame(jsonObject.toString()));
            } else if (messageType.equals("user") && StringUtil.isNotEmpty(jsrAccounts = jsonObject.getStr((Object)"chatId"))) {
                String[] accountStr;
                for (String jsraccount : accountStr = jsrAccounts.split(",")) {
                    Set<ChannelId> channelIdList = NettyConfig.getUserChanIdMap().get(jsraccount);
                    if (!BeanUtils.isNotEmpty(channelIdList)) continue;
                    for (ChannelId chanId : channelIdList) {
                        Channel userChannel = NettyConfig.getChannelGroup().find(chanId);
                        if (userChannel == null) continue;
                        userChannel.writeAndFlush((Object)new TextWebSocketFrame(jsonObject.toString()));
                    }
                }
            }
        }
    }

    public void handleHttpRequest(ChannelHandlerContext ctx, FullHttpRequest request) throws Exception {
        String uri = request.uri();
        String token = WebSocketHandler.getUrlParams(uri);
        log.trace("\u3010webSocket\u3011\uff1a\u767b\u5f55\u7684\u7528\u6237Token\u662f\uff1a{}", (Object)token);
        if (!TokenUtils.verifyToken(token)) {
            NettyConfig.getChannelGroup().remove((Object)ctx.channel());
            this.sendUserNotLoginMsg(ctx);
            this.removeUserId(ctx);
            log.error("\u3010webSocket\u3011\uff1aToken\u4e0d\u5408\u6cd5\uff01");
            return;
        }
        JwtTokenHandler jwtTokenHandler = AppUtil.getBean(JwtTokenHandler.class);
        String username = jwtTokenHandler.getUsernameFromToken(token);
        LinkedHashSet<ChannelId> list = new LinkedHashSet<ChannelId>();
        list.add(ctx.channel().id());
        NettyConfig.getUserChanIdMap().put(username, list);
        if (uri.contains("?")) {
            String newUri = uri.substring(0, uri.indexOf("?"));
            request.setUri(newUri);
        }
        if (request instanceof HttpRequest) {
            HttpMethod method = request.getMethod();
            if (this.wsUri.equalsIgnoreCase(request.getUri())) {
                System.out.println(" \u3010webSocket\u3011\uff1areq instanceof HttpRequest");
                WebSocketServerHandshakerFactory wsFactory = new WebSocketServerHandshakerFactory(this.wsFactoryUri, null, false);
                this.handshaker = wsFactory.newHandshaker((HttpRequest)request);
                if (this.handshaker == null) {
                    WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse((Channel)ctx.channel());
                }
                this.handshaker.handshake(ctx.channel(), request);
            }
        }
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        log.trace("\u3010webSocket\u3011\uff1ahandlerRemoved \u88ab\u8c03\u7528" + ctx.channel().id().asLongText());
        NettyConfig.getChannelGroup().remove((Object)ctx.channel());
        online = NettyConfig.getChannelGroup().size();
        this.removeUserId(ctx);
        log.trace("\u3010webSocket\u3011\uff1a========\u4e0b\u7ebf\uff1a\u5728\u7ebf\u4eba\u6570\uff1a" + online + "!========");
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        log.error("\u3010webSocket\u3011\uff1a\u5f02\u5e38\uff1a{}", (Object)cause.getMessage(), (Object)cause);
        NettyConfig.getChannelGroup().remove((Object)ctx.channel());
        this.removeUserId(ctx);
        ctx.close();
    }

    private static String getUrlParams(String url) {
        if (!url.contains("=")) {
            return null;
        }
        String token = url.substring(url.indexOf("=") + 1);
        return token;
    }

    private void removeUserId(ChannelHandlerContext ctx) {
        AttributeKey key = AttributeKey.valueOf((String)"account");
        String account = (String)ctx.channel().attr(key).get();
        if (StringUtil.isNotEmpty(account)) {
            Set<ChannelId> channelIdList = NettyConfig.getUserChanIdMap().get(account);
            if (BeanUtils.isNotEmpty(channelIdList)) {
                channelIdList.remove(ctx.channel().id());
            }
            if (channelIdList.size() == 0) {
                NettyConfig.getUserChanIdMap().remove(account);
            }
        }
        log.info("\u3010webSocket\u3011\uff1a" + ctx.channel().remoteAddress() + "\u65ad\u5f00\u8fde\u63a5!");
    }

    public void sendUserNotLoginMsg(ChannelHandlerContext ctx) {
        ChannelFuture future = ctx.writeAndFlush((Object)new CloseWebSocketFrame(WebSocketCloseStatus.POLICY_VIOLATION, "\u672a\u767b\u5f55\uff01"));
        future.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }
}

