/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cgpt.universal.service.impl;

import com.artfess.base.context.BaseContext;
import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryField;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.FileUtil;
import com.artfess.base.util.HttpUtil;
import com.artfess.cgpt.universal.dao.AccessoryDao;
import com.artfess.cgpt.universal.model.Accessory;
import com.artfess.cgpt.universal.model.Chunk;
import com.artfess.cgpt.universal.service.AccessoryService;
import com.artfess.cgpt.universal.service.UtilsManager;
import com.artfess.cgpt.utils.BizUtils;
import com.artfess.file.util.MinioUtil;
import com.artfess.file.util.OfficeToPdf;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import io.jsonwebtoken.lang.Assert;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.text.DecimalFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpServletResponse;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.model.ZipParameters;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class AccessoryServiceImpl
extends BaseManagerImpl<AccessoryDao, Accessory>
implements AccessoryService {
    @Autowired
    private UtilsManager utils;
    @Autowired
    private BaseContext baseContext;
    @Autowired
    private OfficeToPdf officeToPdf;

    @Override
    public List<Accessory> getAccessoryBySourceId(String sourceId) {
        QueryFilter queryFilter = QueryFilter.build();
        queryFilter.addFilter("SOURCE_ID_", (Object)sourceId, QueryOP.EQUAL);
        if (BeanUtils.isEmpty((Object)queryFilter.getPageBean())) {
            queryFilter.setPageBean(new PageBean(Integer.valueOf(1), Integer.valueOf(-1)));
        }
        IPage<Accessory> accessoryIPage = ((AccessoryDao)this.baseMapper).queryByPageAndSourceID((IPage<Accessory>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<Accessory>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return accessoryIPage.getRecords();
    }

    @Override
    public boolean saveAccessory(List<Accessory> list) {
        for (Accessory ele : list) {
            String currentUserId = this.baseContext.getCurrentUserId();
            String currentUserName = this.baseContext.getCurrentUserName();
            if (StringUtils.isBlank((CharSequence)ele.getId())) {
                ele.setCreateBy(currentUserId);
                ele.setCreateName(currentUserName);
                ele.setCreateTime(LocalDateTime.now());
                continue;
            }
            ele.setUpdateName(currentUserName);
            ele.setUpdateBy(currentUserId);
            ele.setUpdateTime(LocalDateTime.now());
        }
        boolean result = this.saveBatch(list);
        return result;
    }

    @Override
    public String fileUploadPost(Chunk chunk, HttpServletResponse response) throws IOException {
        String path = this.utils.getFileDir(chunk.getFilename());
        File file = new File(path, "" + chunk.getChunkNumber());
        if (!file.exists()) {
            new File(path).mkdirs();
            file.createNewFile();
        }
        try (InputStream fos = chunk.getFile().getInputStream();
             RandomAccessFile raf = new RandomAccessFile(file, "rw");){
            int len = -1;
            byte[] buffer = new byte[1024];
            while ((len = fos.read(buffer)) != -1) {
                raf.write(buffer, 0, len);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            if (chunk.getChunkNumber() == 1) {
                file.delete();
            }
            response.setStatus(507);
            return "exception:\u6587\u4ef6\u5199\u5165\u5f02\u5e38";
        }
        if (chunk.getChunkNumber().equals(chunk.getTotalChunks())) {
            response.setStatus(200);
            return "over";
        }
        response.setStatus(201);
        return "ok";
    }

    @Override
    public List<Accessory> minioBatchUpload(List<MultipartFile> fileList, String bizPath, HttpServletResponse response) throws Exception {
        ArrayList<Accessory> accessoryList = new ArrayList<Accessory>(fileList.size());
        for (MultipartFile file : fileList) {
            accessoryList.add(this.minioUpload(file, bizPath, response));
        }
        return accessoryList;
    }

    @Override
    public PageList<Accessory> getAccessoryPageBySourceId(QueryFilter<Accessory> queryFilter) {
        String sourceID = null;
        List test = queryFilter.getQuerys();
        for (QueryField ele : test) {
            if (!"SOURCE_ID_".equals(ele.getProperty())) continue;
            sourceID = String.valueOf(ele.getValue());
            break;
        }
        Assert.notNull(sourceID, (String)"SOURCE_ID_\u4e0d\u80fd\u4e3a\u7a7a");
        queryFilter.addFilter("IS_DELE_", (Object)"0", QueryOP.EQUAL);
        IPage<Accessory> accessoryIPage = ((AccessoryDao)this.baseMapper).queryByPageAndSourceID((IPage<Accessory>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<Accessory>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        List records = accessoryIPage.getRecords();
        return new PageList(accessoryIPage);
    }

    @Override
    public boolean removeBySourceId(String sourceId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(Accessory::getSourceId, (Object)sourceId);
        boolean remove = this.remove((Wrapper)wrapper);
        return remove;
    }

    @Override
    public boolean removeBySourceIds(List<String> sourceIds) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.in(Accessory::getSourceId, sourceIds);
        boolean remove = this.remove((Wrapper)wrapper);
        return remove;
    }

    @Override
    public Accessory minioUpload(String bizPath, String fileName) throws Exception {
        Assert.notNull((Object)fileName, (String)"\u6587\u4ef6\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        File file = this.mergeFile(fileName);
        Accessory accessory = new Accessory();
        if (null == file || file.length() == 0L || !file.exists()) {
            throw new BaseException("\u6587\u4ef6\u4e3a\u7a7a");
        }
        accessory.setName(fileName);
        String name = DigestUtils.md5Hex((String)UUID.randomUUID().toString()) + fileName.substring(fileName.lastIndexOf("."));
        if (StringUtils.isEmpty((CharSequence)bizPath)) {
            bizPath = "default";
        }
        accessory.setSuffix(fileName.substring(fileName.lastIndexOf(".") + 1));
        String url = MinioUtil.getMinIoUrl((String)bizPath, (String)name);
        accessory.setUrl(url);
        String userId = this.baseContext.getCurrentUserId();
        String userName = this.baseContext.getCurrentUserName();
        accessory.setCreateBy(userId);
        accessory.setUpdateBy(userId);
        accessory.setCreateName(userName);
        accessory.setUpdateName(userName);
        accessory.setCreateTime(LocalDateTime.now());
        accessory.setUpdateTime(LocalDateTime.now());
        accessory.setType(BizUtils.handleFileType(accessory.getSuffix()));
        accessory.setFileSize(new DecimalFormat("#,##0.##").format((double)file.length() / 1024.0 / 1024.0) + " MB");
        this.utils.startMinIOUpload(file, bizPath, name);
        boolean a = false;
        return accessory;
    }

    @Override
    public String minIoDownFile(Accessory accessory, String bizPath) throws Exception {
        if (StringUtils.isEmpty((CharSequence)bizPath)) {
            bizPath = "default";
        }
        String customBucket = "fjwzcz";
        String filePath = "download/" + bizPath + "/" + accessory.getId();
        File file = new File(filePath);
        if (!file.exists()) {
            file.mkdirs();
        }
        String url = accessory.getUrl();
        String dir = url.substring(url.lastIndexOf("/"));
        String suffix = accessory.getSuffix();
        File fileFullPath = new File(file + "/" + accessory.getName());
        if (fileFullPath.exists()) {
            return filePath + "/";
        }
        FileOutputStream out = new FileOutputStream(file + "/" + accessory.getName());
        MinioUtil.downFile((String)customBucket, (String)(bizPath + dir), (OutputStream)out, (boolean)false);
        String downPath = filePath + "/";
        return downPath;
    }

    @Override
    public void minIoDownFile(String ids, String bizPath, HttpServletResponse response) throws Exception {
        String customBucket = "fjwzcz";
        String filePath = "download/" + bizPath;
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            List<String> idList;
            List accessories;
            File path = new File(filePath);
            if (!path.exists()) {
                path.mkdirs();
            }
            if ((accessories = this.listByIds(idList = Arrays.asList(ids.split(",")))).size() == 1) {
                Accessory accessory = (Accessory)((Object)accessories.get(0));
                String url = accessory.getUrl();
                String substring = url.substring(url.lastIndexOf("/"));
                FileOutputStream out = new FileOutputStream(path + "/" + accessory.getName());
                MinioUtil.downFile((String)customBucket, (String)(bizPath + substring), (OutputStream)out, (boolean)false);
                HttpUtil.downLoadFile((HttpServletResponse)response, (String)(filePath + "/" + accessory.getName()), (String)accessory.getName());
                FileUtil.deleteFile((String)(filePath + "/" + accessory.getName()));
                return;
            }
            accessories.forEach(s -> {
                String url = s.getUrl();
                String substring = url.substring(url.lastIndexOf("/"));
                FileOutputStream out = null;
                try {
                    out = new FileOutputStream(path + "/" + s.getName());
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                MinioUtil.downFile((String)customBucket, (String)(bizPath + substring), (OutputStream)out, (boolean)false);
            });
            this.zip(filePath, true);
            String zipPath = filePath + ".zip";
            HttpUtil.downLoadFile((HttpServletResponse)response, (String)zipPath, (String)zipPath.substring(zipPath.lastIndexOf("/") + 1));
            FileUtil.deleteFile((String)zipPath);
        }
    }

    private void zip(String path, Boolean isDelete) {
        ZipFile zipFile = null;
        try {
            ZipParameters parameters = new ZipParameters();
            parameters.setCompressionMethod(8);
            parameters.setCompressionLevel(5);
            File file = new File(path);
            Assert.isTrue((boolean)file.exists(), (String)"\u6587\u4ef6\u4e0d\u5b58\u5728");
            ArrayList list = new ArrayList();
            if (file.isDirectory()) {
                zipFile = new ZipFile(new File(path + ".zip"));
                zipFile.setFileNameCharset("utf-8");
                zipFile.addFolder(path, parameters);
            } else {
                zipFile = new ZipFile(new File(path.split(".")[0] + ".zip"));
                zipFile.setFileNameCharset("utf-8");
                zipFile.addFile(file, parameters);
            }
            if (isDelete.booleanValue()) {
                FileUtil.deleteDir((File)file);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File mergeFile(String fileName) throws FileNotFoundException {
        String dirPath = this.utils.getFileDir(fileName);
        File result = new File(dirPath + "/" + fileName);
        if (result.exists()) {
            result.delete();
        }
        File[] fs = new File(dirPath).listFiles();
        List<File> fileList = Arrays.asList(fs);
        Collections.sort(fileList, (o1, o2) -> Integer.parseInt(o1.getName()) - Integer.parseInt(o2.getName()));
        ArrayList<RandomAccessFile> rafList = new ArrayList<RandomAccessFile>();
        for (File ele : fileList) {
            RandomAccessFile tempFile = new RandomAccessFile(ele, "rw");
            rafList.add(tempFile);
        }
        try (FileChannel outputChannel = new RandomAccessFile(result, "rw").getChannel();){
            for (RandomAccessFile ele : rafList) {
                FileChannel inputChannel = ele.getChannel();
                outputChannel.transferFrom(inputChannel, outputChannel.size(), inputChannel.size());
                inputChannel.close();
            }
            File file = result;
            return file;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String fileToPdf(Accessory accessory) {
        String suffix = accessory.getSuffix();
        if ("pdf".equalsIgnoreCase(suffix)) {
            return null;
        }
        String url = accessory.getUrl();
        String[] urlArr = url.split("/");
        try {
            String downFilePath = this.minIoDownFile(accessory, urlArr[4]);
            String fileName = accessory.getName();
            String inputPath = downFilePath + fileName;
            String outputPath = downFilePath + fileName + ".pdf";
            int i = fileName.lastIndexOf(".");
            if (i > -1 && i < fileName.length() - 1) {
                outputPath = downFilePath + fileName.substring(0, i) + ".pdf";
            }
            this.officeToPdf.office2pdf(inputPath, outputPath);
            return outputPath;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public List<Accessory> getAccessoryByGroup(String group) {
        QueryFilter queryFilter = QueryFilter.build();
        queryFilter.addFilter("GROUP_", (Object)group, QueryOP.EQUAL);
        queryFilter.addFilter("IS_DELE_", (Object)"0", QueryOP.EQUAL);
        return ((AccessoryDao)this.baseMapper).queryByPageAndSourceID((IPage<Accessory>)this.convert2IPage(new PageBean(Integer.valueOf(0), Integer.valueOf(-1), Boolean.valueOf(false))), (Wrapper<Accessory>)this.convert2Wrapper(queryFilter, this.currentModelClass())).getRecords();
    }

    @Override
    public Accessory minioUpload(MultipartFile file, String bizPath, HttpServletResponse response) throws Exception {
        Accessory accessory = new Accessory();
        String fileName = null;
        if (file.isEmpty() || file.getSize() == 0L) {
            throw new com.artfess.uc.exception.BaseException("\u6587\u4ef6\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank(fileName)) {
            fileName = file.getOriginalFilename();
        }
        accessory.setName(fileName);
        String name = DigestUtils.md5Hex((String)UUID.randomUUID().toString()) + fileName.substring(fileName.lastIndexOf("."));
        if (StringUtils.isEmpty((CharSequence)bizPath)) {
            bizPath = "default";
        }
        accessory.setSuffix(fileName.substring(fileName.lastIndexOf(".") + 1));
        String url = MinioUtil.getMinIoUrl((String)bizPath, (String)name);
        accessory.setUrl(url);
        String userId = this.baseContext.getCurrentUserId();
        String userName = this.baseContext.getCurrentUserName();
        accessory.setCreateBy(userId);
        accessory.setUpdateBy(userId);
        accessory.setCreateName(userName);
        accessory.setUpdateName(userName);
        accessory.setCreateTime(LocalDateTime.now());
        accessory.setUpdateTime(LocalDateTime.now());
        accessory.setType(BizUtils.handleFileType(accessory.getSuffix()));
        accessory.setFileSize(new DecimalFormat("#,##0.##").format((double)file.getSize() / 1024.0 / 1024.0) + " MB");
        this.utils.startMinIOUpload(file, bizPath, name);
        return accessory;
    }
}

