/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cgpt.expert.manager.impl;

import com.artfess.base.entity.BizModel;
import com.artfess.base.exception.BaseException;
import com.artfess.base.feign.SystemConfigFeignService;
import com.artfess.base.feign.UCFeignService;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.expert.dao.BizExpertDatabaseDao;
import com.artfess.cgpt.expert.manager.BizExpertDatabaseEvaTypeManager;
import com.artfess.cgpt.expert.manager.BizExpertDatabaseExpertTypeManager;
import com.artfess.cgpt.expert.manager.BizExpertDatabaseManager;
import com.artfess.cgpt.expert.manager.BizExpertDatabaseOrgManager;
import com.artfess.cgpt.expert.manager.BizExpertDatabaseQualificationLabelManager;
import com.artfess.cgpt.expert.manager.BizExpertTypeManager;
import com.artfess.cgpt.expert.model.BizExpertDatabase;
import com.artfess.cgpt.expert.model.BizExpertDatabaseExpertType;
import com.artfess.cgpt.expert.model.BizExpertDatabaseOrg;
import com.artfess.cgpt.expert.model.BizExpertDatabaseQualificationLabel;
import com.artfess.cgpt.expert.model.BizExpertType;
import com.artfess.cgpt.foreignApi.service.ForeignCallService;
import com.artfess.cgpt.qualification.manager.BizQualificationLabelManager;
import com.artfess.cgpt.qualification.model.BizQualificationLabel;
import com.artfess.cgpt.universal.model.Accessory;
import com.artfess.cgpt.universal.service.AccessoryService;
import com.artfess.cgpt.utils.BizUtils;
import com.artfess.uc.manager.OrgManager;
import com.artfess.uc.manager.OrgUserManager;
import com.artfess.uc.manager.RoleManager;
import com.artfess.uc.manager.UserManager;
import com.artfess.uc.model.Org;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizExpertDatabaseManagerImpl
extends BaseManagerImpl<BizExpertDatabaseDao, BizExpertDatabase>
implements BizExpertDatabaseManager {
    @Autowired
    private UCFeignService ucFeignService;
    @Autowired
    private BizExpertDatabaseQualificationLabelManager expertDatabaseQualificationLabelManager;
    @Autowired
    private SystemConfigFeignService service;
    @Autowired
    private BizExpertDatabaseExpertTypeManager bizExpertDatabaseExpertTypeManager;
    @Autowired
    private BizExpertDatabaseOrgManager bizExpertDatabaseOrgManager;
    @Autowired
    private AccessoryService accessoryService;
    @Autowired
    private BizQualificationLabelManager qualificationLabelManager;
    @Autowired
    private BizExpertTypeManager expertTypeManager;
    @Autowired
    private OrgManager orgManager;
    @Autowired
    private UserManager userManager;
    @Autowired
    private OrgUserManager orgUserManager;
    @Autowired
    private ForeignCallService foreignCallService;
    @Autowired
    private BizExpertDatabaseEvaTypeManager evaTypeManager;
    @Autowired
    private RoleManager roleManager;

    @Override
    public PageList<BizExpertDatabase> queryAllByPage(QueryFilter<BizExpertDatabase> queryFilter) {
        queryFilter.addFilter("is_dele_", (Object)0, QueryOP.EQUAL);
        IPage<BizExpertDatabase> materialIPage = ((BizExpertDatabaseDao)this.baseMapper).queryAllByPage((IPage<BizExpertDatabase>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizExpertDatabase>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(materialIPage);
    }

    @Override
    public BizExpertDatabase getDetailById(String id) {
        BizExpertDatabase result = (BizExpertDatabase)((Object)super.getById((Serializable)((Object)id)));
        result.setQualificationLabelList(this.expertDatabaseQualificationLabelManager.getByExpertId(id));
        LambdaQueryWrapper expertTypeQW = new LambdaQueryWrapper();
        expertTypeQW.select(new SFunction[]{BizExpertDatabaseExpertType::getExpertTypeId}).eq(BizExpertDatabaseExpertType::getExpertDatabaseId, (Object)id);
        List typeIdsObj = this.bizExpertDatabaseExpertTypeManager.listObjs((Wrapper)expertTypeQW);
        if (BeanUtils.isNotEmpty((Object)typeIdsObj) && typeIdsObj.size() > 0) {
            List collect = typeIdsObj.stream().map(s -> String.valueOf(s)).collect(Collectors.toList());
            result.setTypeList(this.expertTypeManager.listByIds(collect));
        }
        LambdaQueryWrapper expertDatabaseOrgQW = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)expertDatabaseOrgQW.select(new SFunction[]{BizExpertDatabaseOrg::getOrgId}).eq(BizExpertDatabaseOrg::getExpertDatabaseId, (Object)id)).eq(BizExpertDatabaseOrg::getStatus, (Object)0);
        List orgIdsObj = this.bizExpertDatabaseOrgManager.listObjs((Wrapper)expertDatabaseOrgQW);
        if (BeanUtils.isNotEmpty((Object)orgIdsObj) && orgIdsObj.size() > 0) {
            List collect = orgIdsObj.stream().map(s -> String.valueOf(s)).collect(Collectors.toList());
            result.setOrgList(this.orgManager.listByIds(collect));
        }
        return result;
    }

    @Override
    @Transactional
    public void saveOrUpdateEntity(BizExpertDatabase entity) {
        List<BizQualificationLabel> bizQualificationLabelList = entity.getQualificationLabelList();
        LambdaQueryWrapper hisQW = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)hisQW.eq(BizExpertDatabase::getAccount, (Object)entity.getAccount())).eq(BizModel::getIsDele, (Object)"0")).ne(BeanUtils.isNotEmpty((Object)entity.getId()), BizExpertDatabase::getId, (Object)entity.getId());
        int hisCount = super.count((Wrapper)hisQW);
        if (hisCount > 0) {
            throw new BaseException("\u64cd\u4f5c\u5931\u8d25\uff0c\u4e13\u5bb6\u8d26\u53f7\u3010" + entity.getAccount() + "\u3011\u5df2\u5b58\u5728");
        }
        if (BeanUtils.isEmpty((Object)entity.getId())) {
            if (BeanUtils.isEmpty((Object)entity.getUserNumber())) {
                entity.setUserNumber(BizUtils.getNextSerialNumber(this.service, "cgpt_zjkgl"));
            }
            this.roleManager.saveUserRoles("pbzj", entity.getAccount());
        } else {
            LambdaQueryWrapper qw1 = new LambdaQueryWrapper();
            LambdaQueryWrapper qw3 = new LambdaQueryWrapper();
            qw1.eq(BizExpertDatabaseExpertType::getExpertDatabaseId, (Object)entity.getId());
            qw3.eq(BizExpertDatabaseOrg::getExpertDatabaseId, (Object)entity.getId());
            this.bizExpertDatabaseExpertTypeManager.remove((Wrapper)qw1);
            this.bizExpertDatabaseOrgManager.remove((Wrapper)qw3);
            LambdaQueryWrapper qw2 = new LambdaQueryWrapper();
            qw2.eq(BizExpertDatabaseQualificationLabel::getExpertDatabaseId, (Object)entity.getId());
            this.expertDatabaseQualificationLabelManager.remove((Wrapper)qw2);
        }
        super.saveOrUpdate((Object)entity);
        List<BizExpertType> typeList = entity.getTypeList();
        List<Org> orgList = entity.getOrgList();
        if (typeList != null && typeList.size() > 0) {
            for (BizExpertType bizExpertType : typeList) {
                BizExpertDatabaseExpertType entity1 = new BizExpertDatabaseExpertType();
                entity1.setExpertDatabaseId(entity.getId());
                entity1.setExpertTypeId(bizExpertType.getId());
                this.bizExpertDatabaseExpertTypeManager.save((Object)entity1);
            }
        }
        if (orgList != null && orgList.size() > 0) {
            for (Org org : orgList) {
                BizExpertDatabaseOrg entity3 = new BizExpertDatabaseOrg();
                entity3.setExpertDatabaseId(entity.getId());
                entity3.setOrgId(org.getId());
                entity3.setStatus(0);
                this.bizExpertDatabaseOrgManager.save((Object)entity3);
            }
        }
        if (BeanUtils.isNotEmpty(bizQualificationLabelList) && bizQualificationLabelList.size() > 0) {
            ArrayList expertDatabaseQualificationList = new ArrayList();
            bizQualificationLabelList.stream().forEach(bizQualificationLabel -> {
                List<Accessory> accessoryList;
                boolean quaIsAdd = false;
                if (BeanUtils.isEmpty((Object)bizQualificationLabel.getId())) {
                    quaIsAdd = true;
                    bizQualificationLabel.setQualificationMember(entity.getFullname());
                    bizQualificationLabel.setQualificationMemberId(entity.getUserId());
                    bizQualificationLabel.setQualificationForm(3);
                }
                this.qualificationLabelManager.saveOrUpdateEntity((BizQualificationLabel)((Object)bizQualificationLabel));
                if (quaIsAdd && BeanUtils.isNotEmpty(accessoryList = bizQualificationLabel.getAccessoryList()) && accessoryList.size() > 0) {
                    accessoryList.stream().forEach(s -> s.setSourceId(bizQualificationLabel.getId()));
                }
                BizExpertDatabaseQualificationLabel expertDatabaseQualification = new BizExpertDatabaseQualificationLabel();
                expertDatabaseQualification.setExpertDatabaseId(entity.getId());
                expertDatabaseQualification.setQualificationLabelId(bizQualificationLabel.getId());
                expertDatabaseQualificationList.add(expertDatabaseQualification);
            });
            if (expertDatabaseQualificationList.size() > 0) {
                this.expertDatabaseQualificationLabelManager.saveBatch(expertDatabaseQualificationList);
            }
        }
    }

    @Override
    @Transactional
    public void removeByIds(List<String> ids) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.in(BizExpertDatabaseQualificationLabel::getExpertDatabaseId, ids);
        this.expertDatabaseQualificationLabelManager.remove((Wrapper)wrapper);
        LambdaQueryWrapper qw1 = new LambdaQueryWrapper();
        qw1.in(BizExpertDatabaseExpertType::getExpertDatabaseId, ids);
        this.bizExpertDatabaseExpertTypeManager.remove((Wrapper)qw1);
        LambdaQueryWrapper qw3 = new LambdaQueryWrapper();
        qw3.in(BizExpertDatabaseOrg::getExpertDatabaseId, ids);
        this.bizExpertDatabaseOrgManager.remove((Wrapper)qw3);
        super.removeByIds(ids);
    }
}

