/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cgpt.bidding.manager.impl;

import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.bidding.dao.BidDocumentsDao;
import com.artfess.cgpt.bidding.manager.BidDocumentsManager;
import com.artfess.cgpt.bidding.model.BidDocuments;
import com.artfess.cgpt.universal.model.Accessory;
import com.artfess.cgpt.universal.service.AccessoryService;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.qiyuesuo.sdk.SDKClient;
import net.qiyuesuo.sdk.api.CategoryService;
import net.qiyuesuo.sdk.api.ContractService;
import net.qiyuesuo.sdk.bean.company.TenantType;
import net.qiyuesuo.sdk.bean.contract.CreateContractRequest;
import net.qiyuesuo.sdk.bean.contract.ViewUrlRequest;
import net.qiyuesuo.sdk.bean.document.CreateDocumentRequest;
import net.qiyuesuo.sdk.bean.document.CreateDocumentResult;
import net.qiyuesuo.sdk.bean.sign.Signatory;
import net.qiyuesuo.sdk.common.exception.PrivateAppException;
import net.qiyuesuo.sdk.common.http.FileItem;
import net.qiyuesuo.sdk.common.http.StreamFile;
import net.qiyuesuo.sdk.common.utils.TimeUtils;
import net.qiyuesuo.sdk.impl.CategoryServiceImpl;
import net.qiyuesuo.sdk.impl.ContractServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BidDocumentsManagerImpl
extends BaseManagerImpl<BidDocumentsDao, BidDocuments>
implements BidDocumentsManager {
    private final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    @Autowired
    private AccessoryService accessoryService;
    @Value(value="${contractSys.serverUrl}")
    private String serverUrl;
    @Value(value="${contractSys.accessKey}")
    private String accessKey;
    @Value(value="${contractSys.accessSecret}")
    private String accessSecret;
    @Value(value="${contractSys.onePartyStreamId}")
    private Long bidDocSignStreamId;
    private CategoryService categoryService;
    private ContractService contractService;

    @Override
    public PageList<BidDocuments> queryAllByPage(QueryFilter<BidDocuments> queryFilter) {
        IPage<BidDocuments> result = ((BidDocumentsDao)this.baseMapper).queryAllByPage((IPage<BidDocuments>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BidDocuments>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        List records = result.getRecords();
        if (BeanUtils.isNotEmpty((Object)records) && records.size() > 0) {
            records.stream().forEach(s -> s.setAccessoryList(this.accessoryService.getAccessoryBySourceId(s.getId())));
        }
        return new PageList(result);
    }

    @Override
    @Transactional
    public void saveOrUpdateEntity(BidDocuments entity) {
        List<Accessory> hisFile;
        List<Accessory> accessoryList = entity.getAccessoryList();
        entity.setSupplierId(ContextUtil.getCurrentOrgId());
        entity.setUploadTime(LocalDateTime.now());
        if (BeanUtils.isEmpty((Object)entity.getBidType())) {
            entity.setBidType(2);
        }
        LambdaQueryWrapper bidDocumentsQW = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)bidDocumentsQW.eq(BidDocuments::getProjectApprovalType, (Object)entity.getProjectApprovalType())).eq(BidDocuments::getProjectApprovalId, (Object)entity.getProjectApprovalId())).eq(BidDocuments::getSupplierId, (Object)entity.getSupplierId())).eq(BidDocuments::getQuotationRounds, (Object)entity.getQuotationRounds())).orderByDesc(BidDocuments::getUploadTime)).last("limit 1");
        BidDocuments history = (BidDocuments)((Object)((BidDocumentsDao)this.baseMapper).selectOne((Wrapper)bidDocumentsQW));
        if (BeanUtils.isEmpty((Object)entity.getId()) && BeanUtils.isNotEmpty((Object)((Object)history))) {
            entity.setId(history.getId());
        }
        if (entity.getProjectApprovalType() == 2 && BeanUtils.isNotEmpty((Object)((Object)history)) && entity.getBidType() != history.getBidType() && BeanUtils.isNotEmpty(hisFile = this.accessoryService.getAccessoryBySourceId(history.getId())) && hisFile.size() > 0) {
            throw new BaseException("\u4e0a\u4f20\u5931\u8d25\uff0c\u53ea\u80fd\u9009\u62e9\u4e00\u79cd\u6295\u6807\u6587\u4ef6\u7c7b\u578b\u4e0a\u4f20");
        }
        super.saveOrUpdate((Object)entity);
        if (BeanUtils.isNotEmpty(accessoryList) && accessoryList.size() > 0) {
            accessoryList.stream().forEach(s -> {
                s.setSourceId(entity.getId());
                if (BeanUtils.isNotEmpty((Object)entity.getBidType())) {
                    s.setBidType(entity.getBidType());
                    if (s.getBidType() == 1) {
                        s.setBidSignStatus(1);
                    } else {
                        s.setBidSignStatus(3);
                    }
                }
            });
            this.accessoryService.saveBatch(accessoryList);
        }
    }

    @Override
    public Integer getAllSignStatus(BidDocuments entity) {
        List collect;
        List<Accessory> fileList;
        LambdaQueryWrapper bidDocumentsQW = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)bidDocumentsQW.eq(BidDocuments::getProjectApprovalType, (Object)entity.getProjectApprovalType())).eq(BidDocuments::getProjectApprovalId, (Object)entity.getProjectApprovalId())).eq(BidDocuments::getSupplierId, (Object)entity.getSupplierId())).eq(BidDocuments::getQuotationRounds, (Object)entity.getQuotationRounds())).orderByDesc(BidDocuments::getUploadTime)).last("limit 1");
        BidDocuments data = (BidDocuments)((Object)((BidDocumentsDao)this.baseMapper).selectOne((Wrapper)bidDocumentsQW));
        if (BeanUtils.isNotEmpty((Object)((Object)data)) && BeanUtils.isNotEmpty((Object)data.getBidType()) && BeanUtils.isNotEmpty(fileList = this.accessoryService.getAccessoryBySourceId(data.getId())) && fileList.size() > 0 && (BeanUtils.isEmpty(collect = fileList.stream().filter(s -> s.getBidSignStatus() != 3).collect(Collectors.toList())) || collect.size() <= 0)) {
            return 1;
        }
        return 0;
    }

    @Override
    @Transactional
    public void removeByIds(String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        super.removeByIds(idList);
        this.accessoryService.removeBySourceIds(idList);
    }

    public void init() {
        SDKClient sdkClient = new SDKClient(this.serverUrl, this.accessKey, this.accessSecret);
        this.contractService = new ContractServiceImpl(sdkClient);
        this.categoryService = new CategoryServiceImpl(sdkClient);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String sendDocSign(String fileId) throws Exception {
        Accessory data = (Accessory)((Object)this.accessoryService.getById((Serializable)((Object)fileId)));
        if (BeanUtils.isEmpty((Object)((Object)data))) {
            throw new BaseException("\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5");
        }
        if (data.getBidType() != 1) {
            throw new BaseException("\u53d1\u8d77\u5931\u8d25\uff0c\u5f53\u524d\u6295\u6807\u6587\u4ef6\u7c7b\u578b\u65e0\u6cd5\u53d1\u8d77");
        }
        if (data.getBidSignStatus() != 1) {
            throw new BaseException("\u53d1\u8d77\u5931\u8d25\uff1a\u672a\u7b7e\u7f72\u72b6\u6001\u4e0b\u624d\u53ef\u4ee5\u53d1\u8d77\u7b7e\u7f72");
        }
        this.init();
        Long contrStreamId = this.bidDocSignStreamId;
        ArrayList<Long> documentIdList = new ArrayList<Long>();
        String url = data.getUrl();
        File file = null;
        InputStream inStream = null;
        OutputStream os = null;
        try {
            file = File.createTempFile("net_url", data.getSuffix());
            URL urlfile = new URL(url);
            inStream = urlfile.openStream();
            os = new FileOutputStream(file);
            int bytesRead = 0;
            byte[] buffer = new byte[8192];
            while ((bytesRead = inStream.read(buffer, 0, 8192)) != -1) {
                os.write(buffer, 0, bytesRead);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (null != os) {
                    os.close();
                }
                if (null != inStream) {
                    inStream.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        String contrTitle = BeanUtils.isNotEmpty((Object)data.getName()) ? data.getName() : ContextUtil.getCurrentOrgName() + "\u6295\u6807\u6587\u4ef6";
        CreateDocumentRequest request = new CreateDocumentRequest();
        request.setFile((FileItem)new StreamFile((InputStream)new FileInputStream(file)));
        request.setFileType(data.getSuffix());
        request.setTitle(contrTitle);
        CreateDocumentResult result = this.contractService.createByFile(request);
        Long documentId = result.getDocumentId();
        documentIdList.add(documentId);
        HashMap params = new HashMap();
        CreateContractRequest createContractRequest = new CreateContractRequest();
        createContractRequest.setEndTime(TimeUtils.format((Date)TimeUtils.after((Date)new Date(), (int)7), (String)"yyyy-MM-dd HH:mm:ss"));
        createContractRequest.setSend(Boolean.valueOf(true));
        createContractRequest.setMustSign(Boolean.valueOf(true));
        createContractRequest.setExtraSign(Boolean.valueOf(true));
        createContractRequest.setAutoCreateCounterSign(Boolean.valueOf(true));
        createContractRequest.setSignAll("RECEIVER");
        createContractRequest.setMsgCode(Integer.valueOf(0));
        if (documentIdList.size() > 0) {
            createContractRequest.setDocuments(documentIdList);
        }
        createContractRequest.setSubject(contrTitle);
        createContractRequest.setTenantName("\u91cd\u5e86\u76db\u666e\u7269\u8d44\u6709\u9650\u516c\u53f8");
        ArrayList<Signatory> signatories = new ArrayList<Signatory>();
        Signatory signatory1 = new Signatory();
        signatory1.setTenantType(TenantType.COMPANY);
        signatory1.setTenantName(ContextUtil.getCurrentOrgName());
        signatory1.setSerialNo(Integer.valueOf(1));
        signatories.add(signatory1);
        createContractRequest.setSignatories(signatories);
        createContractRequest.setCategoryId(contrStreamId);
        createContractRequest.setDocumentParams(params);
        Long contractId = null;
        try {
            contractId = this.contractService.createContractByCategory(createContractRequest);
        }
        catch (PrivateAppException e) {
            System.out.println(LocalDateTime.now() + "\u53d1\u8d77\u7b7e\u7f72\u5931\u8d25:" + e.getMessage());
            throw new BaseException("\u53d1\u8d77\u7b7e\u7f72\u5931\u8d25:" + e.getMessage());
        }
        System.out.println("\u521b\u5efa\u5408\u540c\u6210\u529f:" + contractId);
        data.setBidSignStatus(2);
        data.setBidContractId(String.valueOf(contractId));
        ViewUrlRequest viewRequest = new ViewUrlRequest();
        viewRequest.setContractId(contractId);
        viewRequest.setPageType(ViewUrlRequest.PageType.CONTENT);
        String viewUrl = null;
        try {
            viewUrl = this.contractService.viewUrl(viewRequest);
        }
        catch (PrivateAppException e) {
            System.out.println(LocalDateTime.now() + "\u7b7e\u7f72\u9884\u89c8\u5931\u8d25:" + e.getMessage());
            throw new BaseException("\u7b7e\u7f72\u9884\u89c8\u5931\u8d25:" + e.getMessage());
        }
        System.out.println("\u5408\u540c\u67e5\u770b\u94fe\u63a5:" + viewUrl);
        data.setBidContractUrl(viewUrl);
        this.accessoryService.updateById((Object)data);
        return viewUrl;
    }
}

