import { defineStore } from 'pinia'
import { sysDictQuery } from '@/api/system/sysinfo'

interface dictItem {
    [key: string]: any
}

export const useDictStore = defineStore('dict', {
    state: () => ({
        dictData: {} as dictItem
    }),
    getters: {
        getDictData: (state) => state.dictData,
        getDictDataByCode: (state) => (Code: string) => {
            return state.dictData[Code] || []
        }
    },
    actions: {
        async sysDictData() {
            try {
                const response = await sysDictQuery()
                this.dictData = response || ({} as dictItem)
            } catch (error) {
                return Promise.reject(error)
            }
        },
        setDict(dictData: dictItem) {
            this.dictData = dictData || ({} as dictItem)
        },
        clearDict() {
            this.dictData = {} as dictItem
            localStorage.removeItem('dict')
        }
    },
    persist: {
        storage: localStorage,
        key: 'dict',
        pick: ['dictData']
    }
})
