import request from '@/requset/axios'

// 表格分页
export function dataTable(data: object) {
    return new Promise((resolve, reject) => {
        request
            .post(`/bizSupplierEnterprise/v1/queryPage`, data)
            .then((res) => resolve(res?.data || []))
            .catch((err) => reject(err))
    })
}

// 表格回显
export function dataDetail(id: string) {
    return new Promise((resolve, reject) => {
        request
            .get(`/bizSupplierEnterpriseChangeLog/v1/getModel/${id}`)
            .then((res) => resolve(res?.data || {}))
            .catch((err) => reject(err))
    })
}

// 审核通过
export function auditPass(data: object) {
    return new Promise((resolve, reject) => {
        request
            .post(`/bizSupplierEnterpriseChangeLog/v1/review`, data)
            .then((res) => resolve(res?.data || {}))
            .catch((err) => reject(err))
    })
}

// 导出excel
export function exportData(data: object) {
    return new Promise((resolve, reject) => {
        request
            .download('/biz/enterprise/exportDataToExcel', 'post', data, 'arraybuffer')
            .then((res) => resolve(res?.data || {}))
            .catch((err) => reject(err))
    })
}
