interface IOption {
    title: string
    prop: string
    type: string
    value: any
    span?: number
    dateOption?: any
    options?: any[]
    queryHandler?: any
    placeholder?: string
    allowCreate?: boolean
    number?: boolean
    minWidth?: number

    [key: string]: any
}

interface COption {
    title: string
    prop: string
    minWidth: number
    render?: boolean
    formatter?: any
    sortable?: boolean

    [key: string]: any
}

interface TableOptions {
    categoryChange: () => Promise<void>
}

export function useTableOptionConfig({ categoryChange }: TableOptions) {
    const customOptionList: IOption[] = [
        {
            title: '注册资金',
            prop: 'registeredCapital',
            type: 'input',
            value: ''
        }
    ]
    const fixedOptionList: IOption[] = [
        {
            title: '供方名称',
            prop: 'companyName',
            type: 'input',
            span: 4,
            value: ''
        },
        {
            title: '类别',
            prop: 'ownerType',
            type: 'input',
            value: '',
            span: 4
        },
        {
            title: '法定代表人',
            prop: 'companyEbe',
            type: 'input',
            value: '',
            span: 4
        },
        {
            title: '申请时间',
            prop: 'applyDate',
            type: 'date',
            dateOption: {
                type: 'datetimerange',
                format: 'YYYY-MM-DD HH:mm:ss',
                valueFormat: 'YYYY-MM-DD HH:mm:ss',
                defaultTime: [new Date(0, 0, 0, 0, 0, 0), new Date(0, 0, 0, 23, 59, 59)]
            },
            span: 6,
            value: []
        }
    ]
    const columnsList: COption[] = [
        {
            title: '供方名称',
            prop: 'companyName',
            minWidth: 160,
            sortable: true
        },
        {
            title: '类别',
            prop: 'ownerType',
            minWidth: 120,
            sortable: true,
            render: true
        },
        {
            title: '法定代表人',
            prop: 'companyEbe',
            minWidth: 160,
            sortable: true
        },
        {
            title: '注册资金(万元)',
            prop: 'registeredCapital',
            minWidth: 120,
            sortable: true
        },
        {
            title: '申请时间',
            prop: 'applyDate',
            minWidth: 120,
            sortable: true
        }
    ]
    return {
        customOptionList,
        fixedOptionList,
        columnsList
    }
}
