/*
 * ✨ 响应式工具类函数 ✨
 * */

/**
 * 基于设计稿宽度动态计算字体大小
 * @param {Number} pxValue 设计稿字体
 * @param {Number} designWidth 设计稿宽度
 * @return {Number} 计算后像素大小
 * */
export function calcFontSize(pxValue = 14, designWidth = 1920) {
    const viewportWidth = window.innerWidth
    // 计算当前视口宽度与设计稿宽度的比例
    const ratio = viewportWidth / designWidth
    // 根据比例调整px值，以保持视觉上的一致性
    return pxValue * ratio
}

/**
 * @function pxToVw 基于设计稿宽度动态计算字体大小
 * @param {Number} pxValue 设计稿字体
 * @param {Number} designWidth 设计稿宽度
 * @return {Number} 计算后像素大小
 * */
export function pxToVw(pxValue = 14, designWidth = 1920) {
    // 视口宽度被视为100vw，计算pxValue在视口宽度中所占的百分比
    return (pxValue / designWidth) * 100 || 0
}
