package com.artfess.workflow.runtime.params;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 流程终止参数
 * 
 * @company 阿特菲斯信息技术有限公司
 * @author zhangxianwen
 * @email zhangxw@jee-soft.cn
 * @date 2018年6月28日
 */
@ApiModel(value="流程终止参数")
@JsonInclude(Include.NON_NULL)
public class DoEndParamObject {
	
	@ApiModelProperty(name="taskId",notes="任务id",required=true)
	private String taskId;
	
	@ApiModelProperty(name="endReason",notes="终止原因",required=true)
	private String endReason;
	
	@ApiModelProperty(name="messageType",notes="消息通知类型 非必填，默认邮件，inner（内部消息），mail（邮件），sms（短信），多个之单使用英文逗号隔开",allowableValues="mail,inner,sms")
	private String messageType;
    protected String files = ""; /* 附件 */
    
    @ApiModelProperty(name="busDataObjectNode",notes="业务数据,用于执行groovy脚本参数")
    protected ObjectNode busDataObjectNode;

    public String getFiles() {
        return files;
    }

    public void setFiles(String files) {
        this.files = files;
    }

	public String getTaskId() {
		return taskId;
	}

	public void setTaskId(String taskId) {
		this.taskId = taskId;
	}

	public String getEndReason() {
		return endReason;
	}

	public void setEndReason(String endReason) {
		this.endReason = endReason;
	}

	public String getMessageType() {
		return messageType;
	}

	public void setMessageType(String messageType) {
		this.messageType = messageType;
	}

	public ObjectNode getBusDataObjectNode() {
		return busDataObjectNode;
	}

	public void setBusDataObjectNode(ObjectNode busDataObjectNode) {
		this.busDataObjectNode = busDataObjectNode;
	}

}
