package com.artfess.application.job;

import com.artfess.base.util.AppUtil;
import com.artfess.sysConfig.persistence.manager.SysLogsManager;
import com.artfess.sysConfig.persistence.manager.SysLogsSettingsManager;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.annotation.XxlJob;
import com.xxl.job.core.log.XxlJobLogger;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

/**
 * 系统日志定时删除操作
 * 添加定时任务类
 * 开发步骤：
 * 1、在Spring Bean实例中，开发Job方法，方式格式要求为 "public ReturnT<String> execute(String param)"
 * 2、为Job方法添加注解 "@XxlJob(value="自定义jobhandler名称", init = "JobHandler初始化方法", destroy = "JobHandler销毁方法")"，注解value值对应的是调度中心新建任务的JobHandler属性的值。
 * 3、执行日志：需要通过 "XxlJobLogger.log" 打印执行日志；
 * 
 * com.artfess.portal.job.SysLogsXxlJob
 * @author liyanggui
 *
 */
@Component
public class SysLogsXxlJob{
	
	/**
     * 1、简单任务示例（Bean模式）
     */
    @XxlJob("sysLogsXxlJob")
    public ReturnT<String> sysLogsXxlJob(String param) throws Exception {
        XxlJobLogger.log("XXL-JOB, 开始执行系统日志定时删除任务.");
        SysLogsManager sysLogsManager = AppUtil.getBean(SysLogsManager.class);
		SysLogsSettingsManager sysLogsSettingsManager = AppUtil.getBean(SysLogsSettingsManager.class);
		Map<String, Integer> cacheMap = sysLogsSettingsManager.getSysLogsSettingDaysMap();
		List<Map<String, Object>> params = new ArrayList<Map<String,Object>>();
		
		Set<Entry<String, Integer>> entrySet = cacheMap.entrySet();
		for (Entry<String, Integer> entry : entrySet) {
			String key = entry.getKey();
			Integer days = entry.getValue();
			Map<String, Object> map = new HashMap<String, Object>();
			map.put("executionTime", LocalDateTime.now().minusDays(days));
			map.put("moduleType", key);
			params.add(map);
		}
		sysLogsManager.removeByEexcutionTime(params);
        XxlJobLogger.log("XXL-JOB, 成功执行系统日志定时删除任务.");
        return ReturnT.SUCCESS;
		
        
	}
}
