/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.uc.context;

import com.artfess.base.context.BaseContext;
import com.artfess.base.exception.BaseException;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.ContextThread;
import com.artfess.base.util.HttpUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.uc.manager.TenantManageManager;
import com.artfess.uc.model.TenantManage;
import com.artfess.uc.model.User;
import com.artfess.uc.util.ContextUtil;
import java.util.List;
import org.springframework.context.annotation.Primary;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

@Service
@Primary
public class UcContext
implements BaseContext,
ContextThread {
    private ThreadLocal<String> tempTenantId = new ThreadLocal();

    public void setTempTenantId(String tenantId) {
        this.tempTenantId.set(tenantId);
    }

    public void clearTempTenantId() {
        this.tempTenantId.remove();
    }

    public String getCurrentUserId() {
        if (this.authenticationEmpty()) {
            return null;
        }
        return ContextUtil.getCurrentUserId();
    }

    public String getCurrentUserAccout() {
        if (this.authenticationEmpty()) {
            return null;
        }
        return ContextUtil.getCurrentUser().getAccount();
    }

    public String getCurrentUserName() {
        if (this.authenticationEmpty()) {
            return null;
        }
        return ContextUtil.getCurrentUser().getFullname();
    }

    public String getCurrentOrgId() {
        if (this.authenticationEmpty()) {
            return null;
        }
        return ContextUtil.getCurrentOrgId();
    }

    public List<String> getCurrentAndChildOrgIds() {
        if (this.authenticationEmpty()) {
            return null;
        }
        return ContextUtil.getCurrentAndChildOrgIds();
    }

    public String getCurrentOrgName() {
        if (this.authenticationEmpty()) {
            return null;
        }
        return ContextUtil.getCurrentOrgName();
    }

    public String getCurrentDeptId() {
        if (this.authenticationEmpty()) {
            return null;
        }
        return ContextUtil.getCurrentDeptId();
    }

    public String getCurrentDeptName() {
        if (this.authenticationEmpty()) {
            return null;
        }
        return ContextUtil.getCurrentDeptName();
    }

    public String getCurrentTenantId() {
        String tempTenantId = this.tempTenantId.get();
        if (StringUtil.isNotEmpty((String)tempTenantId)) {
            return tempTenantId;
        }
        String tenantId = HttpUtil.getTenantId();
        if (BeanUtils.isNotEmpty((Object)tenantId)) {
            return tenantId;
        }
        if (this.authenticationEmpty()) {
            return "-1";
        }
        User currentUser = ContextUtil.getCurrentUser();
        if (BeanUtils.isEmpty((Object)currentUser)) {
            String tenantCode = HttpUtil.getRequest().getHeader("Tenant-Code");
            TenantManageManager tenantManageManager = (TenantManageManager)AppUtil.getBean(TenantManageManager.class);
            TenantManage tenantManage = tenantManageManager.getByCode(tenantCode);
            if (BeanUtils.isNotEmpty((Object)((Object)tenantManage))) {
                String status = tenantManage.getStatus();
                if ("draft".equals(status)) {
                    throw new BaseException("\u8349\u7a3f\u72b6\u6001\u7684\u79df\u6237\u4e0d\u5141\u8bb8\u767b\u5f55");
                }
                return tenantManage.getId();
            }
            return "-1";
        }
        return ContextUtil.getCurrentUser().getTenantId();
    }

    private boolean authenticationEmpty() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        return BeanUtils.isEmpty((Object)authentication) || authentication instanceof AnonymousAuthenticationToken;
    }

    public void cleanAll() {
        this.clearTempTenantId();
    }
}

