package com.artfess.workflow.bpmModel.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.bpm.persistence.manager.BpmDefAuthorizeManager;
import com.artfess.bpm.persistence.manager.BpmDefinitionManager;
import com.artfess.bpm.persistence.model.BpmDefAuthorize;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.baomidou.mybatisplus.core.metadata.IPage;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.Optional;

/**
 * 对象功能:流程分管授权  控制器类
 * @company 广州宏天软件有限公司
 * @author wanghb
 * @email wanghb@jee-soft.cn
 * @date 2018年6月26日
 */
@RestController
@RequestMapping("/flow/defAuthorize/v1/")
@Api(tags="流程分管授权")
@ApiGroup(group= {ApiGroupConsts.GROUP_BPM})
public class  DefAuthorizeController extends BaseController<BpmDefAuthorizeManager, BpmDefAuthorize>{
	@Resource
	private BpmDefinitionManager bpmDefinitionManager;

	/**
	 * 取得流程定义权限列表
	 * TODO方法名称描述
	 * @param request
	 * @param reponse
	 * @return
	 * @throws Exception
	 * PageJson
	 */
	@RequestMapping(value="listJson", method=RequestMethod.POST, produces={"application/json; charset=utf-8" })
	@ApiOperation(value = "取得流程定义权限列表", httpMethod = "POST", notes = "取得流程定义权限列表")
	public PageList<BpmDefAuthorize> listJson(@ApiParam(name="queryFilter",value="通用查询对象")@RequestBody QueryFilter<BpmDefAuthorize> queryFilter)throws Exception{
		PageList<BpmDefAuthorize> pageList = baseService.getAuthorizeListByFilter(queryFilter);
		return pageList;
	}

	/**
	 * 保存新增或修改授权信息
	 * @param request
	 * @param response
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value="save",method=RequestMethod.POST, produces = { "application/json; charset=utf-8" })
	@ApiOperation(value = "保存新增或修改授权信息", httpMethod = "POST", notes = "保存新增或修改授权信息")
	public CommonResult<String> save(
			@ApiParam(name="author",value="授权信息", required = true) @RequestBody BpmDefAuthorize author) throws Exception {
		//用户
		IUser user = ContextUtil.getCurrentUser();
		String id=author.getId();
		//用ID判断是修改还是新增
		if(StringUtil.isNotEmpty(id)){
			author.setId(id);
		}else{
			author.setId("");
			//增加流程分管授权查询判断
			author.setCreator(user.getFullname());
		}

		String myId = baseService.saveOrUpdateAuthorize(author);
		if(StringUtil.isNotEmpty(myId)){
			return new CommonResult<String>(true,"保存授权信息成功！","");
		}else{
			return new CommonResult<String>(false,"保存授权信息失败！","");
		}
	}


	/**
	 * 删除流程分管授权信息
	 * @param request
	 * @param response
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value="del",method=RequestMethod.DELETE, produces = { "application/json; charset=utf-8" })
	@ApiOperation(value = "删除流程分管授权信息", httpMethod = "DELETE", notes = "删除流程分管授权信息")
	public CommonResult<String> del(
			@ApiParam(name="ids",value="授权信息id字符串", required = true) @RequestParam String ids) throws Exception {
		try{
			String[] aryIds = ids.split(",");
			baseService.deleteAuthorizeByIds(aryIds);

			return new CommonResult<String>(true,"删除授权信息成功！","");
		}catch(Exception ex){
			return new CommonResult<String>(false,"删除授权信息失败！","");
		}
	}


	/**
	 * 获得流程分管授权详情
	 * @param request
	 * @param response
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value="defAuthorizeGet",method=RequestMethod.GET, produces = { "application/json; charset=utf-8" })
	@ApiOperation(value = "获得流程分管授权详情", httpMethod = "GET", notes = "获得流程分管授权详情")
	public Object defAuthorizeGet(
			@ApiParam(name="id",value="分管授权id", required = true) @RequestParam String id) throws Exception {
		BpmDefAuthorize bpmDefAuthorize = null;
		if(StringUtil.isNotEmpty(id)){
			bpmDefAuthorize = baseService.getAuthorizeById(id);
		}else{
			bpmDefAuthorize =new BpmDefAuthorize();
		}
		return bpmDefAuthorize;
	}

	/**
	 * 获得默认权限类型
	 * @param request
	 * @param response
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value="getPermissionList",method=RequestMethod.GET, produces = { "application/json; charset=utf-8" })
	@ApiOperation(value = "获得默认权限类型", httpMethod = "GET", notes = "获得默认权限类型")
	public Object getPermissionList() throws Exception {
		return AppUtil.getBean("defaultObjectRightType");
	}

	/**
	 * 获取流程启动权限
	 * @param userId
	 * @param defId
	 * @param leadId
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value = "startRight", method = RequestMethod.GET , produces = { "application/json; charset=utf-8" })
	@ApiOperation(value = "根据用户ID和流程ID判断是否有启动权限", httpMethod = "GET", notes = "根据用户ID和流程ID判断是否有流程启动权限")
	public CommonResult<Boolean> startRight(@ApiParam(required = true, name = "userId",value = "用户ID") String userId,
											@ApiParam(required = true, name = "defId", value = "流程定义ID") String defId,
											@ApiParam(required = true, name = "leadId", value = "领导id") String leadId,
											@ApiParam(required = true, name = "instId", value = "实例id") Optional<String> instId) throws Exception{
		if (ContextUtil.getCurrentUser().isAdmin()) {
			return new CommonResult<>(true,"管理员",true);
		}
		Boolean hasRight = baseService.getStartRightByUserIdAndDefId(userId,defId,leadId,instId.orElse(null));
		return new CommonResult<>(true,"获取成功",hasRight);
	}

	@SuppressWarnings("unchecked")
	@RequestMapping(value = "getAuthDetailPage", method = RequestMethod.POST, produces = { "application/json; charset=utf-8" })
	@ApiOperation(value = "获取分管授权明细列表", httpMethod = "POST", notes = "获取分管授权明细列表")
	public PageList<HashMap<String,Object>> getUserOrgPage(@ApiParam(name = "filter", value = "查询对象", required = true) @RequestBody QueryFilter filter) throws Exception{
		IPage<HashMap<String,Object>> p = baseService.getAuthDetailPage(filter);
		return  new PageList<HashMap<String,Object>>(p);
	}
}
