package com.artfess.workflow.runtime.jms;

import com.artfess.base.constants.JmsConstant;
import com.artfess.base.context.BaseContext;
import com.artfess.base.jms.JmsProducer;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.Base64;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.ExceptionUtil;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.time.DateUtil;
import com.artfess.bpm.api.constant.OpinionStatus;
import com.artfess.bpm.persistence.manager.BpmProcessInstanceManager;
import com.artfess.bpm.persistence.manager.impl.BpmCheckOpinionManagerImpl;
import com.artfess.bpm.persistence.model.AutoTestModel;
import com.artfess.bpm.persistence.model.DefaultBpmProcessInstance;
import com.artfess.bpm.persistence.util.BpmUtil;
import com.artfess.bpm.persistence.util.PublishAutoTestEventUtil;
import com.artfess.uc.api.impl.model.UserFacade;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.workflow.runtime.constant.SysObjTypeConstants;
import com.artfess.workflow.runtime.manager.BpmTestCaseLogsManager;
import com.artfess.workflow.runtime.manager.BpmTestCaseManager;
import com.artfess.workflow.runtime.manager.IFlowManager;
import com.artfess.workflow.runtime.manager.IProcessManager;
import com.artfess.workflow.runtime.model.BpmTestCase;
import com.artfess.workflow.runtime.model.BpmTestCaseLogs;
import com.artfess.workflow.runtime.params.DoEndParamObject;
import com.artfess.workflow.runtime.params.DoNextParamObject;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.jms.annotation.JmsListener;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

@Service
@ConditionalOnProperty(value="jms.enable", matchIfMissing = true)
public class JmsBpmTestCaseConsumer {
	private static final Logger logger = LoggerFactory.getLogger(JmsBpmTestCaseConsumer.class);
	@Resource
	BpmTestCaseLogsManager bpmTestCaseLogsManager;
	@Resource
	BaseContext baseContext;
	@JmsListener(destination = JmsConstant.BPM_TEST_CASE	, containerFactory="jmsListenerContainerQueue")
	public void receiveQueue(AutoTestModel model) throws Exception {
		logger.debug("[JMS]: queue message is :"+model.getClass().getName()+"---"+model);
		autoTest(model);
	}

	// 流程仿真测试
		private void autoTest(Object obj) throws Exception{
			if(!(obj instanceof AutoTestModel)) return;
			try {
				Thread.sleep(1000);
			} catch (InterruptedException e1) {
				e1.printStackTrace();
			}
			AutoTestModel model = (AutoTestModel) obj;
			
			if(StringUtil.isEmpty(model.getProcInstId())) return;
			baseContext.setTempTenantId(model.getTenantId());
			BpmProcessInstanceManager bean = AppUtil.getBean(BpmProcessInstanceManager.class);
			BpmTestCaseManager testCase = AppUtil.getBean(BpmTestCaseManager.class);
			DefaultBpmProcessInstance instance = bean.get(model.getProcInstId());
			if(BeanUtils.isEmpty(instance)) return;
			String flowKey = instance.getProcDefKey();
			String nodeId = model.getNodeId();
			instance = (DefaultBpmProcessInstance) bean.getTopBpmProcessInstance(instance);
			
			String sysCode = instance.getSysCode();
			if(StringUtil.isEmpty(sysCode) || !sysCode.startsWith(SysObjTypeConstants.BPMX_AUTO_TEST) ) return;
			
			BpmTestCase bpmTestCase = testCase.get(sysCode.replace(SysObjTypeConstants.BPMX_AUTO_TEST, ""));
			
			// 获取当前的审批动作 {nodeId:actionName}==>> {"userTask1":"agree"}
			String actionName = "agree";
			String destination = "";
			int count = 1;
			String actionType = bpmTestCase.getActionType();
			if(StringUtil.isNotEmpty(actionType) &&  JsonUtil.toJsonNode(actionType).has(flowKey) ){
				ArrayNode jsonArray = (ArrayNode) JsonUtil.toJsonNode(actionType).get(flowKey);
				ObjectNode parse = JsonUtil.arrayToObject(jsonArray, "nodeId");
				if(parse.has(model.getNodeId())){
					parse = (ObjectNode) parse.get(model.getNodeId());
					actionName = JsonUtil.getString(parse, "actionName",actionName);
					count =  JsonUtil.getInt(parse, "count",count);
				}
			}
			
		   try {
			   
			   IProcessManager processService = AppUtil.getBean(IProcessManager.class);
			   IFlowManager flowManager = AppUtil.getBean(IFlowManager.class);
			   
			    if("endProcess".equals(actionName)){
			    	DoEndParamObject doEndParamObject = new DoEndParamObject();
			    	doEndParamObject.setEndReason("流程仿真测试--人工结束流程");
			    	doEndParamObject.setTaskId(model.getTaskId());
			    	processService.doEndProcess(doEndParamObject);
			    	return;
				}
			    
			    // bpmDebugger
			    String debugger = bpmTestCase.getBpmDebugger();
			    if(StringUtil.isNotEmpty(debugger) && !model.getSkipDebugger() ){
			    	ObjectNode debuggerJo = (ObjectNode) JsonUtil.toJsonNode(debugger);
			    	if(debuggerJo.has(flowKey)){
			    		ArrayNode jsonArray = (ArrayNode) debuggerJo.get(flowKey);
			    		for (JsonNode jsonNode : jsonArray) {
			    			if(nodeId.equals(jsonNode.asText())){
				    			throw new RuntimeException("设置了断点, 流程审批到该节点停止了测试用例往下执行,需要继续运行的请在流程实例中点击继续运行。 ");
				    		}
						}
			    		
			    	}
			    }
			    
			    if(OpinionStatus.BACK_TO_START.getKey().equals(actionName) || OpinionStatus.REJECT.getKey().equals(actionName)  ){
			    	
			    	if( OpinionStatus.REJECT.getKey().equals(actionName)){
			    		destination = BpmUtil.getRejectPreDestination(model.getTaskId());
			    		if(StringUtil.isEmpty(destination)){
			    			throw new RuntimeException("在审批节点[ "+model.getNodeName()+" ] 不支持驳回到上一步的设置，请修改测试用例。 ");
			    		}
			    	}
			    	
			    	// 判断驳回次数
			    	QueryFilter queryFilter = QueryFilter.build();
			    	queryFilter.addFilter("proc_inst_id_", model.getProcInstId(), QueryOP.EQUAL);
			    	queryFilter.addFilter("task_key_", model.getNodeId(), QueryOP.EQUAL);
			    	queryFilter.addFilter("status_", OpinionStatus.BACK_TO_START.getKey().equals(actionName)?"backToStart":"reject", QueryOP.EQUAL);
			    	BpmCheckOpinionManagerImpl bpmCheckOpinionManagerImpl = (BpmCheckOpinionManagerImpl) AppUtil.getBean("bpmCheckOpinionManager");
			    	PageList query = bpmCheckOpinionManagerImpl.query(queryFilter);
			    	if(BeanUtils.isNotEmpty(query) && query.getTotal()>=count){
			    		actionName = "agree";
			    	}
			    	
			    }
			   
			    //自动下一任务
				
				DoNextParamObject doNextParamObject = new DoNextParamObject();
				doNextParamObject.setAccount(model.getRandomAccount());
				doNextParamObject.setActionName(actionName);
				doNextParamObject.setData(Base64.getBase64(bpmTestCase.getBoFormData()));
				doNextParamObject.setTaskId(model.getTaskId());
				doNextParamObject.setDestination(destination);
				doNextParamObject.setOpinion("流程仿真测试");
				UserFacade userFacade = new UserFacade();
				userFacade.setAccount(doNextParamObject.getAccount());
				SecurityContextHolder.getContext().setAuthentication(null);
				ContextUtil.setCurrentUser(ContextUtil.getUserByAccount(doNextParamObject.getAccount()));
				CommonResult<String> doNext = flowManager.complete(doNextParamObject).get();
				
				if(doNext.getState()){
					PublishAutoTestEventUtil.publishAutoTestEvent(instance.getId());
				}
				
				
			} catch (Exception e) {
				e.printStackTrace();
			 ObjectNode objectNode = JsonUtil.getMapper().createObjectNode();
			 objectNode.put("id", instance.getId());
			 objectNode.put("opeName", "流程[ "+instance.getSubject()+" ]未正常结束： ");
			 objectNode.put("reqUrl", "");
			 objectNode.put("opeContent", "在审批任务【"+model.getNodeName()+"】出现异常" +
					  ExceptionUtil.getExceptionMessage(e)); 
			 objectNode.putPOJO("executionTime", DateUtil.getCurrentDate());
			 JmsProducer jmsProducer = AppUtil.getBean(JmsProducer.class);
			 jmsProducer.sendToQueue(JsonUtil.toJson(objectNode),JmsConstant.SYS_LOG_QUEUE);
			 bpmTestCaseLogsManager.removeById(instance.getId());
			 BpmTestCaseLogs logs = JsonUtil.toBean(objectNode, BpmTestCaseLogs.class);
			 bpmTestCaseLogsManager.create(logs);
			}finally {
				baseContext.clearTempTenantId();
			}
		}
}
