import req from '@/request'

const portal = window.context.portal

// 表格分页
export async function tableData(data) {
  return new Promise((resolve, reject) => {
    req
      .post(portal + `/biz/examIndex/data/query`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 表格详情
export function tableDetail(id) {
  return new Promise((resolve, reject) => {
    req
      .get(portal + `/biz/examIndex/data/${id}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 表格新增
export function tableAdd(data) {
  return new Promise((resolve, reject) => {
    req
      .post(portal + `/biz/examIndex/data/`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 表格修改
export function tableEdit(data) {
  return new Promise((resolve, reject) => {
    req
      .put(portal + `/biz/examIndex/data/`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 表格删除
export function tableDelete(ids) {
  return new Promise((resolve, reject) => {
    req
      .remove(portal + `/biz/examIndex/data/?ids=${ids}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 模板下载
export function downModel() {
  return new Promise((resolve, reject) => {
    req
      .downloadGet(portal + `/biz/examIndex/data/downModel`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 导出
export function exportData(data = {}) {
  return new Promise((resolve, reject) => {
    req
      .post(portal + `/biz/examIndex/data/export`, data, 'arraybuffer')
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}
// 导出明细
export function exportDataMx(data = {}) {
  return new Promise((resolve, reject) => {
    req
      .post(portal + `/biz/training/data/export`, data, 'arraybuffer')
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}
// 明细模板下载
export function downModelMx() {
  return new Promise((resolve, reject) => {
    req
      .downloadGet(portal + `/biz/training/data/downModel`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}
// 修改计划状态
export function updateStatus(id) {
  return new Promise((resolve, reject) => {
    req
      .get(portal + `/biz/examIndex/data/updateStatus?id=${id}`)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 入库出库
export function inboundAndOutbound(data = {}) {
  return new Promise((resolve, reject) => {
    req
      .post(portal + `/biz/training/data/`, data)
      .then(res => resolve(res?.data || {}))
      .catch(err => reject(err))
  })
}

// 入库出库明细
export async function detailed(data) {
  return new Promise((resolve, reject) => {
    req
      .post(portal + `/biz/training/data/query`, data)
      .then(res => resolve(res?.data || []))
      .catch(err => reject(err))
  })
}
