import { Options, ShapeAttr, SizeAttr, StyleAttr } from '../../types';
import { LineOptions } from '../line/types';
import { ColumnOptions } from '../column/types';
export declare enum AxisType {
    Left = "Left",
    Right = "Right"
}
export declare enum DualAxesGeometry {
    Line = "line",
    Column = "column"
}
export interface PointConfig {
    readonly shape?: ShapeAttr;
    readonly size?: SizeAttr;
    readonly style?: StyleAttr;
}
declare type CommonGeometryOption = {
    readonly geometry?: string;
    readonly label?: Options['label'];
    readonly legend?: Options['legend'];
    readonly color?: Options['color'];
    readonly isGroup?: boolean;
    readonly groupField?: string;
};
export declare type GeometryLineOption = Pick<LineOptions, 'seriesField' | 'smooth' | 'connectNulls' | 'lineStyle' | 'point' | 'isStack' | 'stepType'> & CommonGeometryOption;
export declare type GeometryColumnOption = Pick<ColumnOptions, 'seriesField' | 'isGroup' | 'isStack' | 'isRange' | 'isPercent' | 'columnWidthRatio' | 'marginRatio' | 'columnStyle' | 'pattern'> & CommonGeometryOption;
export declare type GeometryOption = GeometryColumnOption | GeometryLineOption;
export declare type DualAxesOptions = Omit<Options, 'data' | 'yAxis' | 'color' | 'annotations'> & {
    /**
     * 具体的数据，左右两边的数据
     */
    readonly data: Array<Record<string, any>[]>;
    /**
     * 双轴图的 x 字段，x 字段名称需要保持一致
     */
    readonly xField: string;
    /**
     * 双轴图左右 y 字段，需要不一致
     */
    readonly yField: string[];
    /**
     * 左右两边的 yAxis 配置，使用 object 的方式，key 为 y 字段名，或者数组分别表示左右
     */
    readonly yAxis?: Options['yAxis'][] | Record<string, Options['yAxis']>;
    /**
     * 左右两边的图形配置
     */
    readonly geometryOptions?: GeometryOption[];
    /**
     * 左右两边的 annotation 配置, 同时支持数组和object 两种形式，以防出现 field 相同无法设置的情况
     */
    readonly annotations?: Options['annotations'][] | Record<string, Options['annotations']>;
};
export {};
