"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.area = void 0;
var tslib_1 = require("tslib");
var tooltip_1 = require("../../utils/tooltip");
var utils_1 = require("../../utils");
var base_1 = require("./base");
/**
 * area geometry 的配置处理
 * @param params
 */
function area(params) {
    var options = params.options;
    var area = options.area, xField = options.xField, yField = options.yField, seriesField = options.seriesField, smooth = options.smooth, tooltip = options.tooltip;
    var _a = tooltip_1.getTooltipMapping(tooltip, [xField, yField, seriesField]), fields = _a.fields, formatter = _a.formatter;
    // 如果存在才处理
    return area
        ? base_1.geometry(utils_1.deepAssign({}, params, {
            options: {
                type: 'area',
                colorField: seriesField,
                tooltipFields: fields,
                mapping: tslib_1.__assign({ shape: smooth ? 'smooth' : 'area', tooltip: formatter }, area),
            },
        }))
        : params;
}
exports.area = area;
//# sourceMappingURL=area.js.map