import { View } from '@antv/g2';
import { LineOptions } from '../line';
import { PieOptions } from '../pie';
import { BarOptions } from '../bar';
import { ColumnOptions } from '../column';
import { AreaOptions } from '../area';
import { GaugeOptions } from '../gauge';
import { TinyLineOptions } from '../tiny-line';
import { TinyAreaOptions } from '../tiny-area';
import { TinyColumnOptions } from '../tiny-column';
import { RingProgressOptions } from '../ring-progress';
import { ProgressOptions } from '../progress';
import { ScatterOptions } from '../scatter';
import { HistogramOptions } from '../histogram';
import { FunnelOptions } from '../funnel';
/**
 * 移除 options 中的 width、height 设置
 */
declare type OmitSize<T> = Omit<T, 'width' | 'height'>;
/**
 * multi-view 中的支持的 plots 类型（带 options 定义）
 */
export declare type IPlotTypes = {
    /**
     * plot 类型
     */
    readonly type: 'line';
    /**
     * plot 配置
     */
    readonly options: OmitSize<LineOptions>;
} | {
    readonly type: 'pie';
    readonly options: OmitSize<PieOptions>;
} | {
    readonly type: 'bar';
    readonly options: OmitSize<BarOptions>;
} | {
    readonly type: 'column';
    readonly options: OmitSize<ColumnOptions>;
} | {
    readonly type: 'area';
    readonly options: OmitSize<AreaOptions>;
} | {
    readonly type: 'gauge';
    readonly options: OmitSize<GaugeOptions>;
} | {
    readonly type: 'tiny-line';
    readonly options: OmitSize<TinyLineOptions>;
} | {
    readonly type: 'tiny-area';
    readonly options: OmitSize<TinyAreaOptions>;
} | {
    readonly type: 'tiny-column';
    readonly options: OmitSize<TinyColumnOptions>;
} | {
    readonly type: 'ring-progress';
    readonly options: OmitSize<RingProgressOptions>;
} | {
    readonly type: 'progress';
    readonly options: OmitSize<ProgressOptions>;
} | {
    readonly type: 'histogram';
    readonly options: OmitSize<HistogramOptions>;
} | {
    readonly type: 'scatter';
    readonly options: OmitSize<ScatterOptions>;
} | {
    readonly type: 'funnel';
    readonly options: OmitSize<FunnelOptions>;
};
/**
 * 执行 plot 的 adaptor, 默认都带上 defaultOptions
 * @param {string} plot
 */
export declare function execPlotAdaptor<T extends IPlotTypes['type']>(plot: T, view: View, options: IPlotTypes['options']): void;
export {};
