export declare const version = "2.4.8";
import * as G2 from '@antv/g2';
export { G2 };
import { registerLocale } from './core/locale';
/** 透出 国际化 工具函数，便于使用 */
export { registerLocale };
/** 全局变量 */
export { setGlobal } from './core/global';
/** G2Plot 的 Plot 基类 */
export { Plot } from './core/plot';
/** Adaptor 及其参数的类型定义 */
export type { Adaptor, Params } from './core/adaptor';
export * from './types';
export { Line } from './plots/line';
export type { LineOptions } from './plots/line';
export { Area } from './plots/area';
export type { AreaOptions } from './plots/area';
export { Column } from './plots/column';
export type { ColumnOptions } from './plots/column';
export { Bar } from './plots/bar';
export type { BarOptions } from './plots/bar';
export { Pie } from './plots/pie';
export type { PieOptions } from './plots/pie';
export { Rose } from './plots/rose';
export type { RoseOptions } from './plots/rose';
export { WordCloud } from './plots/word-cloud';
export type { WordCloudOptions } from './plots/word-cloud';
export { Scatter } from './plots/scatter';
export type { ScatterOptions } from './plots/scatter';
export { Radar } from './plots/radar';
export type { RadarOptions } from './plots/radar';
export { DualAxes } from './plots/dual-axes';
export type { DualAxesOptions } from './plots/dual-axes';
export { TinyLine } from './plots/tiny-line';
export type { TinyLineOptions } from './plots/tiny-line';
export { TinyColumn } from './plots/tiny-column';
export type { TinyColumnOptions } from './plots/tiny-column';
export { TinyArea } from './plots/tiny-area';
export type { TinyAreaOptions } from './plots/tiny-area';
export { Histogram } from './plots/histogram';
export type { HistogramOptions } from './plots/histogram';
export { Progress } from './plots/progress';
export type { ProgressOptions } from './plots/progress';
export { RingProgress } from './plots/ring-progress';
export type { RingProgressOptions } from './plots/ring-progress';
export { Heatmap } from './plots/heatmap';
export type { HeatmapOptions } from './plots/heatmap';
export { Box } from './plots/box';
export type { BoxOptions } from './plots/box';
export { Violin } from './plots/violin';
export type { ViolinOptions } from './plots/violin';
export { Venn } from './plots/venn';
export type { VennOptions } from './plots/venn';
export { Stock } from './plots/stock';
export type { StockOptions } from './plots/stock';
export { Funnel, FUNNEL_CONVERSATION_FIELD } from './plots/funnel';
export type { FunnelOptions } from './plots/funnel';
export { Liquid } from './plots/liquid';
export type { LiquidOptions } from './plots/liquid';
export { Bullet } from './plots/bullet';
export type { BulletOptions } from './plots/bullet';
export { Sunburst } from './plots/sunburst';
export type { SunburstOptions } from './plots/sunburst';
export { Gauge } from './plots/gauge';
export type { GaugeOptions } from './plots/gauge';
export { Waterfall } from './plots/waterfall';
export type { WaterfallOptions } from './plots/waterfall';
export { RadialBar } from './plots/radial-bar';
export type { RadialBarOptions } from './plots/radial-bar';
export { BidirectionalBar } from './plots/bidirectional-bar';
export type { BidirectionalBarOptions } from './plots/bidirectional-bar';
export { Treemap } from './plots/treemap';
export type { TreemapOptions } from './plots/treemap';
export { Sankey } from './plots/sankey';
export type { SankeyOptions } from './plots/sankey';
export { Chord } from './plots/chord';
export type { ChordOptions } from './plots/chord';
export { CirclePacking } from './plots/circle-packing';
export type { CirclePackingOptions } from './plots/circle-packing';
/** 所有开放图表都使用 G2Plot.P 作为入口开发，理论上官方的所有图表都可以走 G2Plot.P 的入口（暂时不处理） */
export { P } from './plugin';
/** 开放 getCanvasPatterng 方法 */
export { getCanvasPattern } from './utils/pattern';
export { Mix as MultiView } from './plots/mix';
export type { MixOptions as MultiViewOptions } from './plots/mix';
/** 开放多图层图表 (mix) */
export { Mix as Mix } from './plots/mix';
export type { MixOptions } from './plots/mix';
export { Facet } from './plots/facet';
export type { FacetOptions } from './plots/facet';
/** 开发 adaptor 可能会用到的方法或一些工具方法，不强制使用 */
export { flow, measureTextWidth } from './utils';
/** 各个 geometry 的 adaptor，可以让开发者更快的构造图形 */
export { line, interval, area, point, polygon, schema } from './adaptor/geometries';
export type { LineGeometryOptions, IntervalGeometryOptions, AreaGeometryOptions, PointGeometryOptions, PolygonGeometryOptions, SchemaGeometryOptions, } from './adaptor/geometries';
/** 开放一些通用的 adaptor 通道方法，实验阶段：不保证稳定性 */
import { scale, legend, tooltip, annotation, interaction, theme, animation } from './adaptor/common';
export declare const adaptors: {
    scale: typeof scale;
    legend: typeof legend;
    tooltip: typeof tooltip;
    annotation: typeof annotation;
    interaction: typeof interaction;
    theme: typeof theme;
    animation: typeof animation;
};
/** 对于没有开发完成的图表，可以暂时先放到 Lab 下面，先做体验，稳定后放到根 export */
export { Lab } from './lab';
