"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getSiblingViews = exports.getViews = exports.findViewById = void 0;
/**
 * 在 Chart 中查找特定 id 的子 View
 * @param chart
 * @param id
 */
function findViewById(chart, id) {
    return chart.views.find(function (view) { return view.id === id; });
}
exports.findViewById = findViewById;
/**
 * 获取同 view 同一级的所有 views
 * @param view 当前 view
 * @returns 同一级的 views
 * @ignore
 */
function getViews(view) {
    var parent = view.parent;
    return parent ? parent.views : [];
}
exports.getViews = getViews;
/**
 * 获取同 view 同一级的 views，不包括自身
 * @param view 当前 view
 * @returns 同一级的 views
 * @ignore
 */
function getSiblingViews(view) {
    return getViews(view).filter(function (sub) { return sub !== view; });
}
exports.getSiblingViews = getSiblingViews;
//# sourceMappingURL=view.js.map