"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isBetween = exports.isRealNumber = void 0;
/**
 * 是否真实的是数字
 * @param v
 */
function isRealNumber(v) {
    return typeof v === 'number' && !isNaN(v);
}
exports.isRealNumber = isRealNumber;
/**
 * @ignore
 * Determines whether between is
 * @param value
 * @param start
 * @param end
 * @returns true if between
 */
function isBetween(value, start, end) {
    var min = Math.min(start, end);
    var max = Math.max(start, end);
    return value >= min && value <= max;
}
exports.isBetween = isBetween;
//# sourceMappingURL=number.js.map