"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getMeta = exports.getPath = exports.getQuadrantDefaultConfig = void 0;
var tslib_1 = require("tslib");
var d3_regression_1 = require("d3-regression");
var util_1 = require("@antv/util");
var utils_1 = require("../../utils");
var REGRESSION_MAP = {
    exp: d3_regression_1.regressionExp,
    linear: d3_regression_1.regressionLinear,
    loess: d3_regression_1.regressionLoess,
    log: d3_regression_1.regressionLog,
    poly: d3_regression_1.regressionPoly,
    pow: d3_regression_1.regressionPow,
    quad: d3_regression_1.regressionQuad,
};
/**
 * 获取四象限默认配置
 * @param {number} xBaseline
 * @param {number} yBaseline
 */
function getQuadrantDefaultConfig(xBaseline, yBaseline) {
    // 文本便宜距离
    var textOffset = 10;
    // 四象限默认样式
    var defaultConfig = {
        regionStyle: [
            {
                position: {
                    start: [xBaseline, 'max'],
                    end: ['max', yBaseline],
                },
                style: {
                    fill: '#d8d0c0',
                    opacity: 0.4,
                },
            },
            {
                position: {
                    start: ['min', 'max'],
                    end: [xBaseline, yBaseline],
                },
                style: {
                    fill: '#a3dda1',
                    opacity: 0.4,
                },
            },
            {
                position: {
                    start: ['min', yBaseline],
                    end: [xBaseline, 'min'],
                },
                style: {
                    fill: '#d8d0c0',
                    opacity: 0.4,
                },
            },
            {
                position: {
                    start: [xBaseline, yBaseline],
                    end: ['max', 'min'],
                },
                style: {
                    fill: '#a3dda1',
                    opacity: 0.4,
                },
            },
        ],
        lineStyle: {
            stroke: '#9ba29a',
            lineWidth: 1,
        },
        labelStyle: [
            {
                position: ['max', yBaseline],
                offsetX: -textOffset,
                offsetY: -textOffset,
                style: {
                    textAlign: 'right',
                    textBaseline: 'bottom',
                    fontSize: 14,
                    fill: '#ccc',
                },
            },
            {
                position: ['min', yBaseline],
                offsetX: textOffset,
                offsetY: -textOffset,
                style: {
                    textAlign: 'left',
                    textBaseline: 'bottom',
                    fontSize: 14,
                    fill: '#ccc',
                },
            },
            {
                position: ['min', yBaseline],
                offsetX: textOffset,
                offsetY: textOffset,
                style: {
                    textAlign: 'left',
                    textBaseline: 'top',
                    fontSize: 14,
                    fill: '#ccc',
                },
            },
            {
                position: ['max', yBaseline],
                offsetX: -textOffset,
                offsetY: textOffset,
                style: {
                    textAlign: 'right',
                    textBaseline: 'top',
                    fontSize: 14,
                    fill: '#ccc',
                },
            },
        ],
    };
    return defaultConfig;
}
exports.getQuadrantDefaultConfig = getQuadrantDefaultConfig;
var splinePath = function (data, config) {
    var view = config.view, _a = config.options, xField = _a.xField, yField = _a.yField;
    var xScaleView = view.getScaleByField(xField);
    var yScaleView = view.getScaleByField(yField);
    var pathData = data.map(function (d) {
        return view.getCoordinate().convert({ x: xScaleView.scale(d[0]), y: yScaleView.scale(d[1]) });
    });
    return utils_1.getSplinePath(pathData, false);
};
exports.getPath = function (config) {
    var options = config.options;
    var xField = options.xField, yField = options.yField, data = options.data, regressionLine = options.regressionLine;
    var _a = regressionLine.type, type = _a === void 0 ? 'linear' : _a, algorithm = regressionLine.algorithm;
    var pathData;
    if (algorithm) {
        pathData = util_1.isArray(algorithm) ? algorithm : algorithm(data);
    }
    else {
        var reg = REGRESSION_MAP[type]()
            .x(function (d) { return d[xField]; })
            .y(function (d) { return d[yField]; });
        pathData = reg(data);
    }
    return splinePath(pathData, config);
};
/**
 * 调整散点图 meta: { min, max } ① data.length === 1 ② 所有数据 y 值相等 ③ 所有数据 x 值相等
 * @param options
 * @returns
 */
exports.getMeta = function (options) {
    var _a;
    var _b = options.meta, meta = _b === void 0 ? {} : _b, xField = options.xField, yField = options.yField, data = options.data;
    var xFieldValue = data[0][xField];
    var yFieldValue = data[0][yField];
    var xIsPositiveNumber = xFieldValue > 0;
    var yIsPositiveNumber = yFieldValue > 0;
    /**
     * 获得对应字段的 min max scale 配置
     */
    function getMetaMinMax(field, axis) {
        var fieldMeta = util_1.get(meta, [field]);
        function getCustomValue(type) {
            return util_1.get(fieldMeta, type);
        }
        var range = {};
        if (axis === 'x') {
            if (util_1.isNumber(xFieldValue)) {
                if (!util_1.isNumber(getCustomValue('min'))) {
                    range['min'] = xIsPositiveNumber ? 0 : xFieldValue * 2;
                }
                if (!util_1.isNumber(getCustomValue('max'))) {
                    range['max'] = xIsPositiveNumber ? xFieldValue * 2 : 0;
                }
            }
            return range;
        }
        if (util_1.isNumber(yFieldValue)) {
            if (!util_1.isNumber(getCustomValue('min'))) {
                range['min'] = yIsPositiveNumber ? 0 : yFieldValue * 2;
            }
            if (!util_1.isNumber(getCustomValue('max'))) {
                range['max'] = yIsPositiveNumber ? yFieldValue * 2 : 0;
            }
        }
        return range;
    }
    return tslib_1.__assign(tslib_1.__assign({}, meta), (_a = {}, _a[xField] = tslib_1.__assign(tslib_1.__assign({}, meta[xField]), getMetaMinMax(xField, 'x')), _a[yField] = tslib_1.__assign(tslib_1.__assign({}, meta[yField]), getMetaMinMax(yField, 'y')), _a));
};
//# sourceMappingURL=util.js.map