import { __assign, __extends } from "tslib";
import { Plot } from '../../core/plot';
import { getDataWhetherPecentage } from '../../utils/transform/percent';
import { adaptor, meta } from './adaptor';
import { DEFAULT_OPTIONS } from './constants';
/**
 * 条形图
 */
var Bar = /** @class */ (function (_super) {
    __extends(Bar, _super);
    function Bar() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        /** 图表类型 */
        _this.type = 'bar';
        return _this;
    }
    /**
     * 获取 条形图 默认配置项
     * 供外部使用
     */
    Bar.getDefaultOptions = function () {
        return DEFAULT_OPTIONS;
    };
    /**
     * @override
     */
    Bar.prototype.changeData = function (data) {
        this.updateOption({ data: data });
        var _a = this, chart = _a.chart, options = _a.options;
        var xField = options.xField, yField = options.yField, isPercent = options.isPercent;
        var switchedFieldOptions = __assign(__assign({}, options), { xField: yField, yField: xField });
        meta({ chart: chart, options: switchedFieldOptions });
        chart.changeData(getDataWhetherPecentage(data, xField, yField, xField, isPercent));
    };
    /**
     * 获取 条形图 默认配置
     */
    Bar.prototype.getDefaultOptions = function () {
        return Bar.getDefaultOptions();
    };
    /**
     * 获取 条形图 的适配器
     */
    Bar.prototype.getSchemaAdaptor = function () {
        return adaptor;
    };
    return Bar;
}(Plot));
export { Bar };
//# sourceMappingURL=index.js.map