"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.drawPoints = exports.HOLLOW_SHAPES = exports.SHAPES = void 0;
var tslib_1 = require("tslib");
var marker_1 = require("../../../util/marker");
var get_style_1 = require("../util/get-style");
exports.SHAPES = ['circle', 'square', 'bowtie', 'diamond', 'hexagon', 'triangle', 'triangle-down'];
exports.HOLLOW_SHAPES = ['cross', 'tick', 'plus', 'hyphen', 'line'];
/**
 * @ignore
 * Draws points
 * @param shape
 * @param cfg
 * @param container
 * @param shapeName
 * @param isStroke
 * @returns points
 */
function drawPoints(shape, cfg, container, shapeName, isStroke) {
    var style = (0, get_style_1.getStyle)(cfg, isStroke, !isStroke, 'r');
    var points = shape.parsePoints(cfg.points);
    var pointPosition = points[0];
    if (cfg.isStack) {
        pointPosition = points[1];
    }
    else if (points.length > 1) {
        var group = container.addGroup();
        for (var _i = 0, points_1 = points; _i < points_1.length; _i++) {
            var point = points_1[_i];
            group.addShape({
                type: 'marker',
                attrs: (0, tslib_1.__assign)((0, tslib_1.__assign)((0, tslib_1.__assign)({}, style), { symbol: marker_1.MarkerSymbols[shapeName] || shapeName }), point),
            });
        }
        return group;
    }
    return container.addShape({
        type: 'marker',
        attrs: (0, tslib_1.__assign)((0, tslib_1.__assign)((0, tslib_1.__assign)({}, style), { symbol: marker_1.MarkerSymbols[shapeName] || shapeName }), pointPosition),
    });
}
exports.drawPoints = drawPoints;
//# sourceMappingURL=util.js.map