"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.uniq = exports.omit = exports.padEnd = exports.isBetween = void 0;
var util_1 = require("@antv/util");
/**
 * @ignore
 * Determines whether between is
 * @param value
 * @param start
 * @param end
 * @returns true if between
 */
function isBetween(value, start, end) {
    var min = Math.min(start, end);
    var max = Math.max(start, end);
    return value >= min && value <= max;
}
exports.isBetween = isBetween;
/**
 * @ignore
 * pads the current string/array with a given value (repeated, if needed) so that the resulting reaches a given length.
 * The padding is applied from the end of the current value.
 *
 * @param source
 * @param targetLength
 * @param padValue
 * @returns
 */
function padEnd(source, targetLength, padValue) {
    if ((0, util_1.isString)(source)) {
        return source.padEnd(targetLength, padValue);
    }
    else if ((0, util_1.isArray)(source)) {
        var sourceLength = source.length;
        if (sourceLength < targetLength) {
            var diff = targetLength - sourceLength;
            for (var i = 0; i < diff; i++) {
                source.push(padValue);
            }
        }
    }
    return source;
}
exports.padEnd = padEnd;
/**
 * @ignore
 * omit keys of an object.
 * @param obj
 * @param keys
 */
function omit(obj, keys) {
    if (typeof obj === 'object') {
        keys.forEach(function (key) {
            delete obj[key];
        });
    }
    return obj;
}
exports.omit = omit;
/**
 * @ignore
 * @param sourceArray
 * @param targetArray
 * @param map
 */
function uniq(sourceArray, targetArray, map) {
    if (targetArray === void 0) { targetArray = []; }
    if (map === void 0) { map = new Map(); }
    for (var _i = 0, sourceArray_1 = sourceArray; _i < sourceArray_1.length; _i++) {
        var source = sourceArray_1[_i];
        if (!map.has(source)) {
            targetArray.push(source);
            map.set(source, true);
        }
    }
    return targetArray;
}
exports.uniq = uniq;
//# sourceMappingURL=helper.js.map