import { __assign } from "tslib";
import { MarkerSymbols } from '../../../util/marker';
import { getStyle } from '../util/get-style';
export var SHAPES = ['circle', 'square', 'bowtie', 'diamond', 'hexagon', 'triangle', 'triangle-down'];
export var HOLLOW_SHAPES = ['cross', 'tick', 'plus', 'hyphen', 'line'];
/**
 * @ignore
 * Draws points
 * @param shape
 * @param cfg
 * @param container
 * @param shapeName
 * @param isStroke
 * @returns points
 */
export function drawPoints(shape, cfg, container, shapeName, isStroke) {
    var style = getStyle(cfg, isStroke, !isStroke, 'r');
    var points = shape.parsePoints(cfg.points);
    var pointPosition = points[0];
    if (cfg.isStack) {
        pointPosition = points[1];
    }
    else if (points.length > 1) {
        var group = container.addGroup();
        for (var _i = 0, points_1 = points; _i < points_1.length; _i++) {
            var point = points_1[_i];
            group.addShape({
                type: 'marker',
                attrs: __assign(__assign(__assign({}, style), { symbol: MarkerSymbols[shapeName] || shapeName }), point),
            });
        }
        return group;
    }
    return container.addShape({
        type: 'marker',
        attrs: __assign(__assign(__assign({}, style), { symbol: MarkerSymbols[shapeName] || shapeName }), pointPosition),
    });
}
//# sourceMappingURL=util.js.map