import { IGroup, IShape } from '../../dependents';
import { GAnimateCfg } from '../../interface';
import { AnimateExtraCfg } from '../interface';
/**
 * @ignore
 * 单个 shape 动画
 * 渐现动画
 * @param shape 执行动画的图形元素
 * @param animateCfg 动画配置
 * @param cfg 额外信息
 */
export declare function fadeIn(shape: IShape | IGroup, animateCfg: GAnimateCfg, cfg: AnimateExtraCfg): void;
/**
 * @ignore
 * 单个 shape 动画
 * 渐隐动画
 * @param shape 执行动画的图形元素
 * @param animateCfg 动画配置
 * @param cfg 额外信息
 */
export declare function fadeOut(shape: IShape | IGroup, animateCfg: GAnimateCfg, cfg: AnimateExtraCfg): void;
