"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var tslib_1 = require("tslib");
var util_1 = require("@antv/util");
var util_2 = require("../util");
var base_1 = (0, tslib_1.__importDefault)(require("./base"));
/**
 * @ignore
 * 圆形辅助框 Action
 */
var CircleMask = /** @class */ (function (_super) {
    (0, tslib_1.__extends)(CircleMask, _super);
    function CircleMask() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.shapeType = 'circle';
        return _this;
    }
    CircleMask.prototype.getMaskAttrs = function () {
        var points = this.points;
        var currentPoint = (0, util_1.last)(this.points);
        var r = 0;
        var x = 0;
        var y = 0;
        if (points.length) {
            var first = points[0];
            r = (0, util_2.distance)(first, currentPoint) / 2;
            x = (currentPoint.x + first.x) / 2;
            y = (currentPoint.y + first.y) / 2;
        }
        return {
            x: x,
            y: y,
            r: r,
        };
    };
    return CircleMask;
}(base_1.default));
exports.default = CircleMask;
//# sourceMappingURL=circle.js.map