package com.artfess.file.config;

import java.io.File;

import org.apache.commons.net.ftp.FTPClient;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

@Component
public class FtpEntity {
	
	@Value("${FTP.FTP.url:''}")
	private String url;		
	
	@Value("${FTP.FTP.port:21}")
	private Integer port = 21;	
	
	@Value("${FTP.FTP.username:''}")
	private String username;	
	
	@Value("${FTP.FTP.password:''}")
	private String password;
	
	private String separator = File.separator;
	
	//private FTPClient ftp = new FTPClient();
	
	private String LOCAL_CHARSET = "GBK";
	
	private String SERVER_CHARSET = "ISO-8859-1";
	

	public String getUrl() {
		return url;
	}

	public void setUrl(String url) {
		this.url = url;
	}

	public Integer getPort() {
		return port;
	}

	public void setPort(Integer port) {
		this.port = port;
	}

	public String getUsername() {
		return username;
	}

	public void setUsername(String username) {
		this.username = username;
	}

	public String getPassword() {
		return password;
	}

	public void setPassword(String password) {
		this.password = password;
	}

	public String getSeparator() {
		return separator;
	}

	public void setSeparator(String separator) {
		this.separator = separator;
	}



	public String getLOCAL_CHARSET() {
		return LOCAL_CHARSET;
	}

	public void setLOCAL_CHARSET(String lOCAL_CHARSET) {
		LOCAL_CHARSET = lOCAL_CHARSET;
	}

	public String getSERVER_CHARSET() {
		return SERVER_CHARSET;
	}

	public void setSERVER_CHARSET(String sERVER_CHARSET) {
		SERVER_CHARSET = sERVER_CHARSET;
	}
	
	
	
	
}