package com.artfess.query.model;

import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * 搜索标签定义表（BIZ_QUERY_TAG）
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wh
 * @since 2025-02-17
 */
@ApiModel(value="BizQueryTag对象", description="搜索标签定义表（BIZ_QUERY_TAG）")
public class BizQueryTag extends BaseModel<BizQueryTag> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "ID_")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "搜索分类【字典】（1个人 2企业）")
    @TableField("TYPE_")
    private String type;

    @ApiModelProperty(value = "搜索标签CODE")
    @TableField("SEARCH_CODE_")
    private String searchCode;

    @ApiModelProperty(value = "搜索标签【字典】（查企业、查老板、查风险）")
    @TableField("SEARCH_NAME_")
    private String searchName;

    @ApiModelProperty(value = "排序")
    @TableField("SN_")
    private Integer sn;

    @ApiModelProperty(value = "数据库表ID")
    @TableField("TABLE_ID_")
    private String tableId;

    @ApiModelProperty(value = "数据源编码")
    @TableField("DATASOURCES_ALIAS_")
    private String datasourcesAlias;

    @ApiModelProperty(value = "数据库表名称")
    @TableField("TABLE_CODE_")
    private String tableCode;

    @ApiModelProperty(value = "数据库表描述")
    @TableField("TABLE_DESC_")
    private String tableDesc;

    @ApiModelProperty(value = "默认查询字段")
    @TableField("SEARCH_FIELD_CODE_")
    private String searchFieldCode;


    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getSearchCode() {
        return searchCode;
    }

    public void setSearchCode(String searchCode) {
        this.searchCode = searchCode;
    }

    public String getSearchName() {
        return searchName;
    }

    public void setSearchName(String searchName) {
        this.searchName = searchName;
    }

    public Integer getSn() {
        return sn;
    }

    public void setSn(Integer sn) {
        this.sn = sn;
    }

    public String getTableId() {
        return tableId;
    }

    public void setTableId(String tableId) {
        this.tableId = tableId;
    }

    public String getDatasourcesAlias() {
        return datasourcesAlias;
    }

    public void setDatasourcesAlias(String datasourcesAlias) {
        this.datasourcesAlias = datasourcesAlias;
    }

    public String getTableCode() {
        return tableCode;
    }

    public void setTableCode(String tableCode) {
        this.tableCode = tableCode;
    }

    public String getTableDesc() {
        return tableDesc;
    }

    public void setTableDesc(String tableDesc) {
        this.tableDesc = tableDesc;
    }

    public String getSearchFieldCode() {
        return searchFieldCode;
    }

    public void setSearchFieldCode(String searchFieldCode) {
        this.searchFieldCode = searchFieldCode;
    }

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "BizQueryTag{" +
                "id='" + id + '\'' +
                ", type='" + type + '\'' +
                ", searchCode='" + searchCode + '\'' +
                ", searchName='" + searchName + '\'' +
                ", sn=" + sn +
                ", tableId='" + tableId + '\'' +
                ", datasourcesAlias='" + datasourcesAlias + '\'' +
                ", tableCode='" + tableCode + '\'' +
                ", tableDesc='" + tableDesc + '\'' +
                ", searchFieldCode='" + searchFieldCode + '\'' +
                '}';
    }
}
