package com.artfess.query.model;

import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * 查询结果配置信息（BIZ_QUERY_RESULT_MAIN）
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wh
 * @since 2025-03-12
 */
@ApiModel(value="BizQueryResultMain对象", description="查询结果配置信息（BIZ_QUERY_RESULT_MAIN）")
@TableName("biz_query_result_main")
public class BizQueryResultMain extends BaseModel<BizQueryResultMain> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "ID_")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "搜索标签ID【外键】（查企业、查老板、查风险）")
    @TableField("TAG_ID_")
    private String tagId;

    @ApiModelProperty(value = "数据源编码")
    @TableField("DATASOURCES_ALIAS_")
    private String datasourcesAlias;

    @ApiModelProperty(value = "数据分类")
    @TableField("GROUP_NAME_")
    private String groupName;

    @ApiModelProperty(value = "资源ID")
    @TableField("CATALOGS_ID_")
    private String catalogsId;

    @ApiModelProperty(value = "资源名称")
    @TableField("CATALOGS_NAME_")
    private String catalogsName;

    @ApiModelProperty(value = "资源编码")
    @TableField("CATALOGS_CODE_")
    private String catalogsCode;

    @ApiModelProperty(value = "数据库表ID")
    @TableField("TABLE_ID_")
    private String tableId;

    @ApiModelProperty(value = "数据库表名称")
    @TableField("TABLE_CODE_")
    private String tableCode;

    @ApiModelProperty(value = "数据库表描述")
    @TableField("TABLE_DESC_")
    private String tableDesc;

    @ApiModelProperty(value = "展现方式（1:列表，2：表单 3：主表）")
    @TableField("SHOW_TYPE_")
    private Integer showType;

    @ApiModelProperty(value = "排序号")
    @TableField("SN_")
    private Integer sn;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTagId() {
        return tagId;
    }

    public void setTagId(String tagId) {
        this.tagId = tagId;
    }

    public String getDatasourcesAlias() {
        return datasourcesAlias;
    }

    public void setDatasourcesAlias(String datasourcesAlias) {
        this.datasourcesAlias = datasourcesAlias;
    }

    public String getGroupName() {
        return groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public String getCatalogsId() {
        return catalogsId;
    }

    public void setCatalogsId(String catalogsId) {
        this.catalogsId = catalogsId;
    }

    public String getCatalogsName() {
        return catalogsName;
    }

    public void setCatalogsName(String catalogsName) {
        this.catalogsName = catalogsName;
    }

    public String getCatalogsCode() {
        return catalogsCode;
    }

    public void setCatalogsCode(String catalogsCode) {
        this.catalogsCode = catalogsCode;
    }

    public String getTableId() {
        return tableId;
    }

    public void setTableId(String tableId) {
        this.tableId = tableId;
    }

    public String getTableCode() {
        return tableCode;
    }

    public void setTableCode(String tableCode) {
        this.tableCode = tableCode;
    }

    public String getTableDesc() {
        return tableDesc;
    }

    public void setTableDesc(String tableDesc) {
        this.tableDesc = tableDesc;
    }

    public Integer getShowType() {
        return showType;
    }

    public void setShowType(Integer showType) {
        this.showType = showType;
    }

    public Integer getSn() {
        return sn;
    }

    public void setSn(Integer sn) {
        this.sn = sn;
    }


    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "BizQueryResultMain{" +
                "id=" + id +
                ", tagId=" + tagId +
                ", datasourcesAlias=" + datasourcesAlias +
                ", catalogsId=" + catalogsId +
                ", catalogsName=" + catalogsName +
                ", catalogsCode=" + catalogsCode +
                ", tableId=" + tableId +
                ", tableCode=" + tableCode +
                ", tableDesc=" + tableDesc +
                ", showType=" + showType +
                ", sn=" + sn +
                "}";
    }
}
