package com.artfess.query.model;

import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 高级查询条件模板表（BIZ_ADVANCE_QUERY_MOULD）
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wh
 * @since 2025-02-17
 */
@ApiModel(value="BizAdvanceQueryMould对象", description="高级查询条件模板表（BIZ_ADVANCE_QUERY_MOULD）")
public class BizAdvanceQueryMould extends BaseModel<BizAdvanceQueryMould> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "ID_")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "组织机构id")
    @TableField("ORG_ID_")
    private String orgId;

    @ApiModelProperty(value = "组织机构名称")
    @TableField("ORG_NAME_")
    private String orgName;

    @ApiModelProperty(value = "搜索分类【字典】（1个人 2企业）")
    @TableField("TYPE_")
    private String type;

    @ApiModelProperty(value = "模版名称")
    @TableField("MOULD_NAME_")
    private String mouldName;

    @ApiModelProperty(value = "是否是默认启用的模版（0：否 1：是）")
    @TableField("IS_DEFAULT_")
    private String isDefault;

    @ApiModelProperty(value = "创建人")
    @TableField("CREATE_BY_")
    private String createBy;

    @ApiModelProperty(value = "创建单位")
    @TableField("CREATE_ORG_ID_")
    private String createOrgId;

    @ApiModelProperty(value = "创建时间")
    @TableField("CREATE_TIME_")
    private LocalDateTime createTime;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getOrgId() {
        return orgId;
    }

    public void setOrgId(String orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getMouldName() {
        return mouldName;
    }

    public void setMouldName(String mouldName) {
        this.mouldName = mouldName;
    }

    public String getIsDefault() {
        return isDefault;
    }

    public void setIsDefault(String isDefault) {
        this.isDefault = isDefault;
    }

    public String getCreateBy() {
        return createBy;
    }

    public void setCreateBy(String createBy) {
        this.createBy = createBy;
    }

    public String getCreateOrgId() {
        return createOrgId;
    }

    public void setCreateOrgId(String createOrgId) {
        this.createOrgId = createOrgId;
    }

    public LocalDateTime getCreateTime() {
        return createTime;
    }

    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }


    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "BizAdvanceQueryMould{" +
            "id=" + id +
            ", orgId=" + orgId +
            ", orgName=" + orgName +
            ", type=" + type +
            ", mouldName=" + mouldName +
            ", isDefault=" + isDefault +
            ", createBy=" + createBy +
            ", createOrgId=" + createOrgId +
            ", createTime=" + createTime +
        "}";
    }
}
