package com.artfess.query.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.query.dao.BizQueryTagHistoryDao;
import com.artfess.query.manager.BizQueryTagHistoryManager;
import com.artfess.query.model.BizQueryTagHistory;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

/**
 * 搜索记录历史日志表（BIZ_QUERY_TAG_HISTORY） 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wh
 * @since 2025-02-17
 */
@Service
public class BizQueryTagHistoryManagerImpl extends BaseManagerImpl<BizQueryTagHistoryDao, BizQueryTagHistory> implements BizQueryTagHistoryManager {

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean deleteUserAll(String userId) {
        Assert.hasText(userId, "用户ID不能为空！");
        QueryWrapper<BizQueryTagHistory> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("USER_ID_", userId);
        Integer num = this.baseMapper.delete(queryWrapper);
        if(num>0){
            return true;
        }
        return false;
    }
}
