package com.artfess.query.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.query.model.BizQueryResultMain;
import com.artfess.query.vo.BizQueryResultVo;
import com.artfess.query.vo.QueryParamVo;

import java.util.List;
import java.util.Map;

/**
 * 查询结果配置信息（BIZ_QUERY_RESULT_CONDITION） 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wh
 * @since 2025-02-17
 */
public interface BizQueryResultMainManager extends BaseManager<BizQueryResultMain> {

    /**
     * 批量保存配置结果
     * @param queryResultVo
     * @return
     */
    Boolean saveOrUpdateBatchResult(BizQueryResultVo queryResultVo ) throws Exception;

    /**
     * 根据ID获取配置结果信息
     * @param id 主表ID
     * @return
     */
    BizQueryResultVo getVoById(String id);

    /**
     * 根据标签ID获取配置结果信息
     * @param tagId 标签ID
     * @return
     */
    List<BizQueryResultVo> qureyResultConfigByTag(String tagId);

}
