package com.artfess.query.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.exception.ApplicationException;
import com.artfess.base.model.CommonResult;
import com.artfess.base.valid.AddGroup;
import com.artfess.query.manager.BizQueryResultConditionManager;
import com.artfess.query.model.BizQueryResultCondition;
import com.artfess.query.vo.QueryParamVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 查询结果配置信息（BIZ_QUERY_RESULT_CONDITION） 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wh
 * @since 2025-02-17
 */
@Api(tags = "企查查--查询结果配置信息")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ_QUERY})
@RestController
@RequestMapping("/query/resultCondition/v1/")
public class BizQueryResultConditionController extends BaseController<BizQueryResultConditionManager, BizQueryResultCondition> {

    @ApiOperation("批量保存查询结果配置信息表")
    @PostMapping("saveBatchResultCondition")
    public CommonResult<String> saveBatchTagCondition(@ApiParam(name = "model",value = "实体信息")
                                                      @RequestBody
                                                      @Validated({AddGroup.class}) List<BizQueryResultCondition> tagList) throws Exception {
        //验证字段不能出现重复
        List<String> fields=tagList.stream().map(t->t.getFieldName()).collect(Collectors.toList());
        List<String> disFields=fields.stream().distinct().collect(Collectors.toList());
        if(fields.size()!=disFields.size()){
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION,"设置字段不能重复");
        }
        boolean status = this.baseService.saveOrUpdateBatch(tagList);
        return status ? CommonResult.success(null,"批量保存查询结果配置信息成功") : new CommonResult<>(ResponseErrorEnums.FAIL_OPTION);
    }


    @ApiOperation("根据查询条件 查询数据 值为多个的时候用逗号隔开")
    @PostMapping("queryDataList")
    public Map<String,Object> queryDataList(@ApiParam(name = "model",value = "查询实体信息") @RequestBody  QueryParamVo queryParamVos) throws Exception {
        return this.baseService.queryDataList(queryParamVos);
    }

    @ApiOperation("根据ID查询详情")
    @PostMapping("queryDataById")
    public List<Map<String,Object>> queryDataById(@ApiParam(name = "tagId",value = "查询标签ID") @RequestParam String tagId,
                                                  @ApiParam(name = "tableName",value = "表名") @RequestParam String tableName,
                                                  @ApiParam(name = "fieldName",value = "查询字段") @RequestParam String fieldName,
                                                  @ApiParam(name = "fieldValue",value = "查询字段值") @RequestParam String fieldValue) throws Exception {
        return this.baseService.queryDataById(tagId,tableName,fieldName,fieldValue);
    }



    @ApiOperation("根据搜索标签查询详情页及指定分类下的各表数据")
    @PostMapping("queryGroupDataByTag")
    public List<Map<String,Object>> queryGroupDataByTag(@ApiParam(name = "tagId",value = "搜索标签ID") @RequestParam  String tagId,
                                                                @ApiParam(name = "groupName",value = "分组名称") @RequestParam  String groupName,
                                                                @ApiParam(name = "fieldName",value = "查询字段") @RequestParam  String fieldName,
                                                                @ApiParam(name = "fieldValue",value = "查询字段值") @RequestParam  String fieldValue) throws Exception {
        return this.baseService.queryGroupDataByTag(tagId,groupName,fieldName,fieldValue);
    }

    @ApiOperation("根据搜索标签查询详情页各个分类下对应表的数据量")
    @PostMapping("queryGroupCountByTag")
    public Map<String,List<Map<String, Object>>> queryGroupCountByTag(@ApiParam(name = "tagId",value = "查询标签ID") @RequestParam String tagId,
                                                                        @ApiParam(name = "fieldName",value = "关联字段名称") @RequestParam String fieldName,
                                                                        @ApiParam(name = "fieldVal",value = "关联字段值") @RequestParam String fieldVal) throws Exception {
        return this.baseService.queryGroupCountByTag(tagId, fieldName, fieldVal);
    }
}
