package com.artfess.query.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.valid.AddGroup;
import com.artfess.query.manager.BizAdvanceQueryMouldManager;
import com.artfess.query.model.BizAdvanceQueryMould;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 高级查询条件模板表（BIZ_ADVANCE_QUERY_MOULD） 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wh
 * @since 2025-02-17
 */
@Api(tags = "企查查--高级查询条件模板表")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ_QUERY})
@RestController
@RequestMapping("/query/queryMould/v1/")
public class BizAdvanceQueryMouldController extends BaseController<BizAdvanceQueryMouldManager, BizAdvanceQueryMould> {

    @ApiOperation("批量保存高级查询条件模板表")
    @PostMapping("saveBatchTag")
    public CommonResult<String> saveBatchTag(@ApiParam(name = "model",value = "实体信息")
                                             @RequestBody
                                             @Validated({AddGroup.class}) List<BizAdvanceQueryMould> tagList) throws Exception {
        boolean status = this.baseService.saveOrUpdateBatch(tagList);
        return status ? CommonResult.success(null,"批量高级查询条件模板表成功") : new CommonResult<>(ResponseErrorEnums.FAIL_OPTION);
    }
}
