/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.table.operator.impl.sqlserver;

import com.artfess.base.util.AppUtil;
import com.artfess.table.model.Index;
import com.artfess.table.model.impl.DefaultIndex;
import com.artfess.table.operator.ITableOperator;
import com.artfess.table.operator.impl.BaseIndexOperator;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.jdbc.core.RowMapper;

public class SQLServerIndexOperator
extends BaseIndexOperator {
    protected int BATCH_SIZE = 100;

    @Override
    public void createIndex(Index index) throws SQLException {
        String sql = this.genIndexDDL(index);
        this.jdbcTemplate.execute(sql);
    }

    private String genIndexDDL(Index index) {
        StringBuffer sql = new StringBuffer();
        sql.append("CREATE ");
        if (index.isUnique()) {
            sql.append(" UNIQUE ");
        }
        if (!StringUtils.isEmpty((String)index.getIndexType()) && index.getIndexType().equalsIgnoreCase("CLUSTERED")) {
            sql.append(" CLUSTERED ");
        }
        sql.append(" INDEX ");
        sql.append(index.getIndexName());
        sql.append(" ON ");
        sql.append(index.getTableName());
        sql.append(" (");
        for (String field : index.getColumnList()) {
            sql.append(field);
            sql.append(",");
        }
        sql.deleteCharAt(sql.length() - 1);
        sql.append(")");
        return sql.toString();
    }

    @Override
    public void dropIndex(String tableName, String indexName) {
        String sql = "DROP INDEX " + indexName + " ON " + tableName;
        this.jdbcTemplate.execute(sql);
    }

    private List<Index> getIndexesBySql(String sql) {
        List indexes = this.jdbcTemplate.query(sql, (RowMapper)new RowMapper<Index>(){

            public Index mapRow(ResultSet rs, int rowNum) throws SQLException {
                DefaultIndex index = new DefaultIndex();
                ArrayList<String> columns = new ArrayList<String>();
                index.setIndexName(rs.getString("INDEX_NAME"));
                index.setIndexType(SQLServerIndexOperator.this.mapIndexType(rs.getInt("INDEX_TYPE")));
                index.setTableName(rs.getString("TABLE_NAME"));
                index.setTableType(SQLServerIndexOperator.this.mapTableType(rs.getString("TABLE_TYPE")));
                index.setUnique(SQLServerIndexOperator.this.mapIndexUnique(rs.getInt("IS_UNIQUE")));
                index.setPkIndex(SQLServerIndexOperator.this.mapPKIndex(rs.getInt("IS_PK_INDEX")));
                columns.add(rs.getString("COLUMN_NAME"));
                index.setIndexStatus(SQLServerIndexOperator.this.mapIndexStatus(rs.getInt("IS_DISABLED")));
                index.setColumnList(columns);
                return index;
            }
        });
        return indexes;
    }

    private String mapTableType(String type) {
        type = type.trim();
        String tableType = null;
        if (type.equalsIgnoreCase("U")) {
            tableType = "TABLE";
        } else if (type.equalsIgnoreCase("V")) {
            tableType = "VIEW";
        }
        return tableType;
    }

    private String mapIndexType(int type) {
        String indexType = null;
        switch (type) {
            case 0: {
                indexType = "HEAP";
                break;
            }
            case 1: {
                indexType = "CLUSTERED";
                break;
            }
            case 2: {
                indexType = "NONCLUSTERED";
                break;
            }
            case 3: {
                indexType = "XML";
                break;
            }
            case 4: {
                indexType = "SPATIAL";
                break;
            }
        }
        return indexType;
    }

    private boolean mapIndexUnique(int type) {
        boolean indexUnique = false;
        switch (type) {
            case 0: {
                indexUnique = false;
                break;
            }
            case 1: {
                indexUnique = true;
                break;
            }
        }
        return indexUnique;
    }

    private boolean mapPKIndex(int type) {
        boolean pkIndex = false;
        switch (type) {
            case 0: {
                pkIndex = false;
                break;
            }
            case 1: {
                pkIndex = true;
                break;
            }
        }
        return pkIndex;
    }

    private String mapIndexStatus(int type) {
        String tableType = null;
        switch (type) {
            case 0: {
                tableType = "VALIDATE";
                break;
            }
            case 1: {
                tableType = "INVALIDATE";
            }
        }
        return tableType;
    }

    private List<Index> mergeIndex(List<Index> indexes) {
        ArrayList<Index> indexList = new ArrayList<Index>();
        for (Index index : indexes) {
            boolean found = false;
            for (Index index1 : indexList) {
                if (!index.getIndexName().equals(index1.getIndexName()) || !index.getTableName().equals(index1.getTableName())) continue;
                index1.getColumnList().add(index.getColumnList().get(0));
                found = true;
                break;
            }
            if (found) continue;
            indexList.add(index);
        }
        return indexList;
    }

    private List<String> getPKColumns(String tableName) throws SQLException {
        ITableOperator tableOperator = (ITableOperator)AppUtil.getBean(ITableOperator.class);
        return tableOperator.getPKColumns(tableName);
    }

    private Index dedicatePKIndex(Index index) {
        try {
            List<String> pkCols = this.getPKColumns(index.getIndexName());
            if (this.isListEqual(index.getColumnList(), pkCols)) {
                index.setPkIndex(true);
            } else {
                index.setPkIndex(false);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return index;
    }

    private boolean isListEqual(List<String> list1, List<String> list2) {
        if (list1 == null && list2 == null) {
            return true;
        }
        if (list1 == null || list2 == null) {
            return false;
        }
        if (list1.size() != list2.size()) {
            return false;
        }
        return list1.containsAll(list2);
    }

    @Override
    public void rebuildIndex(String tableName, String indexName) {
        String sql = "DBCC DBREINDEX ('" + tableName + "','" + indexName + "',80)";
        this.jdbcTemplate.execute(sql);
    }

    @Override
    public Index getIndex(String tableName, String indexName) throws SQLException {
        String sql = "SELECT IDX.NAME AS INDEX_NAME,IDX.TYPE AS INDEX_TYPE,OBJ.NAME AS TABLE_NAME,OBJ.TYPE AS TABLE_TYPE, IDX.IS_DISABLED AS IS_DISABLED,IDX.IS_UNIQUE AS IS_UNIQUE, IDX.IS_PRIMARY_KEY AS IS_PK_INDEX, COL.NAME AS COLUMN_NAME FROM  SYS.INDEXES  IDX  JOIN SYS.OBJECTS OBJ ON IDX.OBJECT_ID=OBJ.OBJECT_ID  JOIN SYS.INDEX_COLUMNS IDC ON OBJ.OBJECT_ID=IDC.OBJECT_ID AND IDX.INDEX_ID=IDC.INDEX_ID JOIN SYS.COLUMNS COL ON COL.OBJECT_ID=IDC.OBJECT_ID AND COL.COLUMN_ID = IDC.COLUMN_ID WHERE  IDX.NAME ='" + indexName + "'";
        List<Index> indexList = this.getIndexesBySql(sql);
        indexList = this.mergeIndex(indexList);
        for (Index index : indexList) {
            index.setIndexDdl(this.genIndexDDL(index));
        }
        if (indexList.size() > 0) {
            Index index = indexList.get(0);
            return this.dedicatePKIndex(index);
        }
        return null;
    }

    @Override
    public List<Index> getIndexByName(String indexName) throws SQLException {
        return null;
    }

    @Override
    public List<Index> getIndexsByTable(String tableName) throws SQLException {
        String sql = "SELECT IDX.NAME AS INDEX_NAME,IDX.TYPE AS INDEX_TYPE,OBJ.NAME AS TABLE_NAME,OBJ.TYPE AS TABLE_TYPE, IDX.IS_DISABLED AS IS_DISABLED,IDX.IS_UNIQUE AS IS_UNIQUE, IDX.IS_PRIMARY_KEY AS IS_PK_INDEX, COL.NAME AS COLUMN_NAME FROM  SYS.INDEXES  IDX  JOIN SYS.OBJECTS OBJ ON IDX.OBJECT_ID=OBJ.OBJECT_ID  JOIN SYS.INDEX_COLUMNS IDC ON OBJ.OBJECT_ID=IDC.OBJECT_ID AND IDX.INDEX_ID=IDC.INDEX_ID JOIN SYS.COLUMNS COL ON COL.OBJECT_ID=IDC.OBJECT_ID AND COL.COLUMN_ID = IDC.COLUMN_ID WHERE OBJ.NAME ='" + tableName + "' ";
        List<Index> indexList = this.getIndexesBySql(sql);
        indexList = this.mergeIndex(indexList);
        for (Index index : indexList) {
            index.setIndexDdl(this.genIndexDDL(index));
        }
        return indexList;
    }
}

