/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.table.colmap;

import com.artfess.table.model.Column;
import com.artfess.table.model.impl.DefaultColumn;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.springframework.jdbc.core.RowMapper;

public class DmColumnMap
implements RowMapper<Column> {
    public Column mapRow(ResultSet rs, int row) throws SQLException {
        DefaultColumn column = new DefaultColumn();
        String name = rs.getString("NAME");
        String typeName = rs.getString("TYPENAME");
        int length = rs.getInt("LENGTH");
        int precision = rs.getInt("PRECISION");
        int scale = rs.getInt("SCALE");
        boolean isNull = rs.getString("NULLABLE").equals("Y");
        String comments = rs.getString("DESCRIPTION");
        String tableName = rs.getString("TABLE_NAME");
        int isPK = rs.getInt("IS_PK");
        column.setFieldName(name);
        column.setComment(comments);
        column.setIsNull(isNull);
        column.setTableName(tableName);
        column.setIsPk(isPK == 1);
        this.setType(typeName, length, precision, scale, column);
        return column;
    }

    private void setType(String dbtype, int length, int precision, int scale, Column column) {
        if (dbtype.indexOf("CHAR") > -1) {
            column.setColumnType("varchar");
            column.setCharLen(length);
            return;
        }
        if (dbtype.equals("NUMBER")) {
            column.setColumnType("number");
            column.setIntLen(precision - scale);
            column.setDecimalLen(scale);
            return;
        }
        if (dbtype.equals("DATE")) {
            column.setColumnType("date");
            return;
        }
        if (dbtype.equals("CLOB")) {
            column.setColumnType("clob");
            return;
        }
    }
}

