/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.sysConfig.persistence.manager.impl;

import com.artfess.base.cache.annotation.Cacheable;
import com.artfess.base.cache.annotation.FirstCache;
import com.artfess.base.exception.BaseException;
import com.artfess.base.feign.FormFeignService;
import com.artfess.base.feign.UCFeignService;
import com.artfess.base.feign.WorkflowFeignService;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.FileUtil;
import com.artfess.base.util.JAXBUtil;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.ThreadMsgUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.base.util.ZipUtil;
import com.artfess.sysConfig.persistence.dao.AppTagsRelationDao;
import com.artfess.sysConfig.persistence.dao.PortalAppParamDao;
import com.artfess.sysConfig.persistence.dao.SysAppDao;
import com.artfess.sysConfig.persistence.dao.SysAppMenuDao;
import com.artfess.sysConfig.persistence.dao.SysAuthUserDao;
import com.artfess.sysConfig.persistence.dao.SysTagDao;
import com.artfess.sysConfig.persistence.manager.AppTagsRelationManager;
import com.artfess.sysConfig.persistence.manager.CurrentUserService;
import com.artfess.sysConfig.persistence.manager.SysAppManager;
import com.artfess.sysConfig.persistence.manager.SysAuthUserManager;
import com.artfess.sysConfig.persistence.manager.SysMenuManager;
import com.artfess.sysConfig.persistence.manager.SysModuleManager;
import com.artfess.sysConfig.persistence.manager.SysTypeManager;
import com.artfess.sysConfig.persistence.model.AppTagsRelation;
import com.artfess.sysConfig.persistence.model.PortalAppParam;
import com.artfess.sysConfig.persistence.model.SysApp;
import com.artfess.sysConfig.persistence.model.SysAppMenu;
import com.artfess.sysConfig.persistence.model.SysAppXml;
import com.artfess.sysConfig.persistence.model.SysAppXmlList;
import com.artfess.sysConfig.persistence.model.SysAuthUser;
import com.artfess.sysConfig.persistence.model.SysMenu;
import com.artfess.sysConfig.persistence.model.SysModule;
import com.artfess.sysConfig.persistence.model.SysTag;
import com.artfess.sysConfig.persistence.model.SysType;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service(value="sysAppManager")
public class SysAppManagerImpl
extends BaseManagerImpl<SysAppDao, SysApp>
implements SysAppManager {
    @Resource
    SysAuthUserManager sysAuthUserManager;
    @Resource
    AppTagsRelationManager appTagsRelationManager;
    @Resource
    CurrentUserService currentUserService;
    @Resource
    SysAppMenuDao sysAppMenuDao;
    @Resource
    PortalAppParamDao portalAppParamDao;
    @Resource
    SysTagDao sysTagDao;
    @Resource
    AppTagsRelationDao appTagsRelationDao;
    @Resource
    SysTypeManager sysTypeManager;
    @Resource
    SysMenuManager sysMenuManager;
    @Resource
    SysAuthUserDao sysAuthUserDao;
    @Resource
    UCFeignService ucFeignService;
    @Resource
    FormFeignService formFeignService;
    @Resource
    SysModuleManager sysModuleManager;
    @Resource
    WorkflowFeignService workflowFeignService;

    @Transactional
    public void create(SysApp sysApp) {
        String id = UniqueIdUtil.getSuid();
        sysApp.setId(id);
        sysApp.setIsPublish(SysApp.NOT_PUBLISH);
        ((SysAppDao)this.baseMapper).insert((Object)sysApp);
        this.sysAuthUserManager.createDefault(id);
    }

    @Override
    public List<SysApp> queryByAuth(SysApp sysApp) throws Exception {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"is_publish_", (Object)SysApp.IS_PUBLISH);
        queryWrapper.eq((Object)"menu_id_", (Object)sysApp.getMenuId());
        List sysApps = this.list((Wrapper)queryWrapper);
        if (ContextUtil.getCurrentUser().isAdmin()) {
            return sysApps;
        }
        if (BeanUtils.isNotEmpty((Object)sysApps)) {
            ArrayList<String> ids = new ArrayList<String>();
            for (SysApp app2 : sysApps) {
                ids.add(app2.getId());
            }
            List<String> authIds = this.sysAuthUserManager.filterAuth(ids);
            if (BeanUtils.isEmpty(authIds)) {
                return new ArrayList<SysApp>();
            }
            return sysApps.parallelStream().filter(app -> authIds.contains(app.getId())).collect(Collectors.toList());
        }
        return new ArrayList<SysApp>();
    }

    @Override
    public List<SysApp> queryByFilter(QueryFilter<SysApp> queryFilter) {
        PageList query;
        queryFilter.addFilter("is_publish_", (Object)SysApp.IS_PUBLISH, QueryOP.EQUAL);
        if (BeanUtils.isEmpty((Object)queryFilter.getPageBean())) {
            queryFilter.setPageBean(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE));
        }
        if (BeanUtils.isNotEmpty((Object)(query = this.query(queryFilter)).getRows())) {
            if (ContextUtil.getCurrentUser().isAdmin()) {
                return query.getRows();
            }
            ArrayList<String> ids = new ArrayList<String>();
            for (SysApp app2 : query.getRows()) {
                ids.add(app2.getId());
            }
            List<String> authIds = this.sysAuthUserManager.filterAuth(ids);
            return query.getRows().stream().filter(app -> authIds.contains(app.getId())).collect(Collectors.toList());
        }
        return new ArrayList<SysApp>();
    }

    @Override
    public List<SysApp> queryByTagIds(String menuId, List<Map<String, String>> maps) {
        QueryWrapper qw = new QueryWrapper();
        qw.eq((Object)"is_publish_", (Object)SysApp.IS_PUBLISH);
        qw.eq((Object)"menu_id_", (Object)menuId);
        if (BeanUtils.isNotEmpty(maps)) {
            Set<String> appIds = this.getAppIdByTags(maps);
            if (BeanUtils.isNotEmpty(appIds)) {
                qw.in((Object)"id_", appIds);
            } else {
                return new ArrayList<SysApp>();
            }
        }
        List sysApps = this.list((Wrapper)qw);
        if (ContextUtil.getCurrentUser().isAdmin()) {
            return sysApps;
        }
        return sysApps.stream().filter(app -> this.sysAuthUserManager.hasRights(app.getId())).collect(Collectors.toList());
    }

    private Set<String> getAppIdByTags(List<Map<String, String>> maps) {
        Set<String> relList = new HashSet<String>();
        for (Map<String, String> map : maps) {
            String tagIds = map.get("tagIds");
            if (StringUtil.isEmpty((String)tagIds)) continue;
            Set<String> list = this.appTagsRelationManager.getAppIdsByTagIds(tagIds.split(","));
            if (BeanUtils.isEmpty(relList)) {
                relList = list;
                continue;
            }
            relList.retainAll(list);
            if (!relList.isEmpty()) continue;
            return new HashSet<String>();
        }
        return relList;
    }

    @Override
    @Cacheable(value={"bpm:sys:appAuthMenu:new"}, key="#userId", firstCache=@FirstCache(expireTime=10, timeUnit=TimeUnit.MINUTES))
    public List<String> getValidMenu(String userId) {
        Map<String, Set<String>> userRightMap = this.currentUserService.getUserRightMap();
        Map<String, String> userRightMapStr = this.currentUserService.getMapStringByMayList(userRightMap);
        List<String> ids = ((SysAppDao)this.baseMapper).getValidMenu();
        if (BeanUtils.isEmpty(ids)) {
            return new ArrayList<String>();
        }
        return ids.stream().filter(menuId -> this.sysAuthUserManager.getAuthorizeAppMenuId((String)menuId, userRightMapStr)).collect(Collectors.toList());
    }

    @Override
    public Map<String, String> exportData(List<String> ids) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        SysAppXmlList sysAppXmlList = new SysAppXmlList();
        for (String id : ids) {
            JsonNode contentNode;
            String contentId;
            SysMenu sysMenu;
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"app_id_", (Object)id);
            List sysAppMenuList = this.sysAppMenuDao.selectList((Wrapper)wrapper);
            List sysAppMenuTree = BeanUtils.listToTree((List)sysAppMenuList);
            List portalAppParamList = this.portalAppParamDao.selectList((Wrapper)wrapper);
            List<SysTag> sysTagList = this.sysTagDao.getSysTagsByAppId(id);
            HashMap<String, String> condition = new HashMap<String, String>();
            condition.put("authorize_id_", id);
            List sysAuthUserList = this.sysAuthUserDao.selectByMap(condition);
            for (SysAuthUser sysAuthUser : sysAuthUserList) {
                String code;
                CommonResult result;
                String rightType = sysAuthUser.getRightType();
                String ownerId = sysAuthUser.getOwnerId();
                if ("user".equals(rightType)) {
                    result = this.ucFeignService.getUserById(ownerId);
                    if (!BeanUtils.isNotEmpty((Object)result)) continue;
                    JsonNode userNode = (JsonNode)result.getValue();
                    String account = JsonUtil.getString((JsonNode)userNode, (String)"account");
                    sysAuthUser.setOwnerCode(account);
                    continue;
                }
                if ("org".equals(rightType)) {
                    ObjectNode orgObjNode = this.ucFeignService.getOrgByIdOrCode(ownerId);
                    if (!BeanUtils.isNotEmpty((Object)orgObjNode)) continue;
                    String code2 = orgObjNode.get("code").asText();
                    sysAuthUser.setOwnerCode(code2);
                    continue;
                }
                if ("pos".equals(rightType)) {
                    result = this.ucFeignService.getPostByIdOrCode(ownerId);
                    if (!BeanUtils.isNotEmpty((Object)result)) continue;
                    ObjectNode posObjNode = (ObjectNode)result.getValue();
                    code = posObjNode.get("code").asText();
                    sysAuthUser.setOwnerCode(code);
                    continue;
                }
                if (!"role".equals(rightType) || !BeanUtils.isNotEmpty((Object)(result = this.ucFeignService.getRoleByIdOrCode(ownerId)))) continue;
                ObjectNode roleObjNode = (ObjectNode)result.getValue();
                code = roleObjNode.get("code").asText();
                sysAuthUser.setOwnerCode(code);
            }
            SysAppXml sysAppXml = new SysAppXml();
            SysApp sysApp = (SysApp)this.get((Serializable)((Object)id));
            String sysMenuId = sysApp.getMenuId();
            if (StringUtil.isNotEmpty((String)sysMenuId) && (sysMenu = (SysMenu)this.sysMenuManager.get((Serializable)((Object)sysApp.getMenuId()))) != null) {
                sysApp.setMenuAlias(sysMenu.getAlias());
            }
            String content = sysApp.getContent();
            if (sysApp.getType() != null && BeanUtils.isNotEmpty((Object)content) && content.startsWith("{") && content.endsWith("}") && BeanUtils.isNotEmpty((Object)(contentId = (contentNode = JsonUtil.toJsonNode((String)content)).get("id").asText())) && !"null".equals(contentId)) {
                String contentAlias = null;
                switch (sysApp.getType()) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        ObjectNode formDataTemplateObjNode = this.formFeignService.getFormDataTemplateById(contentId);
                        if (!BeanUtils.isNotEmpty((Object)formDataTemplateObjNode)) break;
                        contentAlias = formDataTemplateObjNode.get("alias").asText();
                        break;
                    }
                    case 3: {
                        contentAlias = contentNode.get("alias").asText();
                        break;
                    }
                    case 4: {
                        ObjectNode customChartObjNode = this.formFeignService.getCustomChartById(contentId);
                        if (!BeanUtils.isNotEmpty((Object)customChartObjNode)) break;
                        contentAlias = customChartObjNode.get("alias").asText();
                        break;
                    }
                    case 5: {
                        break;
                    }
                    case 6: {
                        contentAlias = contentNode.get("key").asText();
                        break;
                    }
                    case 7: {
                        SysModule sysModule = (SysModule)this.sysModuleManager.get((Serializable)((Object)contentId));
                        if (!BeanUtils.isNotEmpty((Object)((Object)sysModule))) break;
                        contentAlias = sysModule.getCode();
                        break;
                    }
                    case 8: {
                        contentAlias = contentNode.get("key").asText();
                        break;
                    }
                }
                if (BeanUtils.isNotEmpty(contentAlias) && !"null".equals(contentAlias)) {
                    sysApp.setContentAlias(contentAlias);
                }
            }
            sysAppXml.setSysApp(sysApp);
            sysAppXml.setSysAppMenuList(sysAppMenuTree);
            sysAppXml.setPortalAppParamList(portalAppParamList);
            sysAppXml.setSysTagList(sysTagList);
            sysAppXml.setSysAuthUserList(sysAuthUserList);
            sysAppXmlList.addSysAppXml(sysAppXml);
        }
        try {
            String xml = JAXBUtil.marshall((Object)sysAppXmlList, SysAppXmlList.class);
            map.put("sysApps.portal.xml", xml);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("\u5bfc\u51fa\u5931\u8d25\uff01" + e.getMessage(), e);
        }
        return map;
    }

    @Override
    @Transactional
    public void importData(MultipartFile file) {
        File formDir;
        String unZipFilePath = null;
        try {
            String rootRealPath = Paths.get(FileUtil.getIoTmpdir(), "attachFiles/unZip").toString();
            FileUtil.createFolder((String)rootRealPath, (boolean)true);
            ZipUtil.unZipFile((MultipartFile)file, (String)rootRealPath);
            String name = file.getOriginalFilename();
            String fileDir = StringUtil.substringBeforeLast((String)name, (String)".");
            unZipFilePath = Paths.get(rootRealPath, fileDir).toString();
            String xml = FileUtil.readFile((String)Paths.get(unZipFilePath, "sysApps.portal.xml").toString());
            if (StringUtil.isEmpty((String)xml)) {
                throw new BaseException("\u5bfc\u5165\u7684xml\u6587\u4ef6\u6ca1\u6709\u5185\u5bb9\uff01");
            }
            SysAppXmlList list = (SysAppXmlList)JAXBUtil.unmarshall((String)xml, SysAppXmlList.class);
            List<SysAppXml> sysAppXmlList = list.getSysAppXmlList();
            for (SysAppXml sysAppXml : sysAppXmlList) {
                this.importData(sysAppXml);
            }
        }
        catch (Exception e) {
            try {
                throw new BaseException(e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                File formDir2;
                if (StringUtil.isNotEmpty(unZipFilePath) && (formDir2 = new File(unZipFilePath)).exists()) {
                    FileUtil.deleteDir((File)formDir2);
                }
                throw throwable;
            }
        }
        if (StringUtil.isNotEmpty((String)unZipFilePath) && (formDir = new File(unZipFilePath)).exists()) {
            FileUtil.deleteDir((File)formDir);
        }
    }

    private void importData(SysAppXml sysAppXml) throws IOException {
        List<SysAuthUser> list;
        List<SysTag> list2;
        List<PortalAppParam> portalAppParamList;
        SysMenu sysMenu;
        SysApp sysApp = sysAppXml.getSysApp();
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"name_", (Object)sysApp.getName());
        List sysAppList = ((SysAppDao)this.baseMapper).selectList((Wrapper)wrapper);
        if (sysAppList != null && !sysAppList.isEmpty()) {
            ThreadMsgUtil.addMapMsg2((String)"sysAppsSkipped", (String)String.format("<div style='margin-left:12px; margin-top:6px;'>%s</div>", sysApp.getName() + ""));
            return;
        }
        String appId = UniqueIdUtil.getSuid();
        sysApp.setId(appId);
        String sysMenuAlias = sysApp.getMenuAlias();
        if (StringUtil.isNotEmpty((String)sysMenuAlias) && BeanUtils.isNotEmpty((Object)((Object)(sysMenu = this.sysMenuManager.getByAlias(sysMenuAlias))))) {
            sysApp.setMenuId(sysMenu.getId());
        }
        String contentAlias = sysApp.getContentAlias();
        String content = sysApp.getContent();
        if (sysApp.getType() != null && BeanUtils.isNotEmpty((Object)contentAlias) && BeanUtils.isNotEmpty((Object)content) && content.startsWith("{") && content.endsWith("}")) {
            String contentId = null;
            Object contentName = null;
            switch (sysApp.getType()) {
                case 1: {
                    break;
                }
                case 2: {
                    ObjectNode objectNode = this.formFeignService.getFormDataTemplateByAlias(contentAlias);
                    if (!BeanUtils.isNotEmpty((Object)objectNode)) break;
                    contentId = objectNode.get("id").asText();
                    contentName = objectNode.get("name").asText();
                    break;
                }
                case 3: {
                    ObjectNode objectNode = this.formFeignService.getQueryViewByAlias(contentAlias);
                    if (!BeanUtils.isNotEmpty((Object)objectNode)) break;
                    contentId = objectNode.get("id").asText();
                    contentName = objectNode.get("name").asText();
                    break;
                }
                case 4: {
                    ObjectNode customChartObjNode = this.formFeignService.getCustomChartByAlias(contentAlias);
                    if (!BeanUtils.isNotEmpty((Object)customChartObjNode)) break;
                    contentId = customChartObjNode.get("id").asText();
                    contentName = customChartObjNode.get("name").asText();
                    break;
                }
                case 5: {
                    break;
                }
                case 6: {
                    ObjectNode formObjNode = this.formFeignService.getFormDefByKey(contentAlias);
                    if (!BeanUtils.isNotEmpty((Object)formObjNode)) break;
                    contentId = formObjNode.get("id").asText();
                    contentName = formObjNode.get("name").asText();
                    break;
                }
                case 7: {
                    QueryWrapper queryWrapper = new QueryWrapper();
                    queryWrapper.eq((Object)"code_", (Object)contentAlias);
                    SysModule sysModule = (SysModule)((Object)this.sysModuleManager.getOne((Wrapper)queryWrapper, false));
                    if (!BeanUtils.isNotEmpty((Object)((Object)sysModule))) break;
                    contentId = sysModule.getId();
                    contentName = sysModule.getName();
                    break;
                }
                case 8: {
                    ObjectNode procDefObjNode = this.workflowFeignService.getProcDefByDefKey(contentAlias);
                    if (!BeanUtils.isNotEmpty((Object)procDefObjNode)) break;
                    contentId = procDefObjNode.get("defId").asText();
                    contentName = procDefObjNode.get("name").asText();
                    break;
                }
            }
            ObjectNode objectNode = (ObjectNode)JsonUtil.toJsonNode((String)content).deepCopy();
            if (BeanUtils.isNotEmpty(contentId) && !"null".equals(contentId)) {
                objectNode.put("id", contentId);
            }
            if (BeanUtils.isNotEmpty(contentName) && !"null".equals(contentName)) {
                objectNode.put("name", (String)contentName);
            }
            sysApp.setContent(objectNode.toString());
        }
        ((SysAppDao)this.baseMapper).insert((Object)sysApp);
        wrapper = new QueryWrapper();
        wrapper.eq((Object)"app_id_", (Object)appId);
        List<SysAppMenu> sysAppMenuList = sysAppXml.getSysAppMenuList();
        if (BeanUtils.isNotEmpty(sysAppMenuList)) {
            for (SysAppMenu sysAppMenu : sysAppMenuList) {
                String string = UniqueIdUtil.getSuid();
                sysAppMenu.setId(string);
                sysAppMenu.setParentId("0");
                sysAppMenu.setAppId(appId);
                this.sysAppMenuDao.insert((Object)sysAppMenu);
                if (!"true".equals(sysAppMenu.getIsParent())) continue;
                for (SysAppMenu sysAppMenuChild : sysAppMenu.getChildren()) {
                    String menuChildId = UniqueIdUtil.getSuid();
                    sysAppMenuChild.setId(menuChildId);
                    sysAppMenuChild.setParentId(string);
                    sysAppMenuChild.setAppId(appId);
                    this.sysAppMenuDao.insert((Object)sysAppMenuChild);
                }
            }
        }
        if (BeanUtils.isNotEmpty(portalAppParamList = sysAppXml.getPortalAppParamList())) {
            for (PortalAppParam portalAppParam : portalAppParamList) {
                String paramId = UniqueIdUtil.getSuid();
                portalAppParam.setId(paramId);
                portalAppParam.setAppId(appId);
                this.portalAppParamDao.insert((Object)portalAppParam);
            }
        }
        if (BeanUtils.isNotEmpty(list2 = sysAppXml.getSysTagList())) {
            for (SysTag sysTag : list2) {
                SysType sysType = this.sysTypeManager.getByTypeKeyAndGroupKey("TAG", sysTag.getTypeKey());
                if (sysType == null) continue;
                wrapper = new QueryWrapper();
                wrapper.eq((Object)"key_", (Object)sysTag.getKey());
                SysTag existSysTag = null;
                List existSysTags = this.sysTagDao.selectList((Wrapper)wrapper);
                if (BeanUtils.isNotEmpty((Object)existSysTags)) {
                    existSysTag = (SysTag)((Object)existSysTags.get(0));
                }
                String tagId = UniqueIdUtil.getSuid();
                if (BeanUtils.isNotEmpty(existSysTag)) {
                    tagId = existSysTag.getId();
                } else {
                    sysTag.setId(tagId);
                    sysTag.setTypeId(sysType.getId());
                    this.sysTagDao.insert((Object)sysTag);
                }
                String relationId = UniqueIdUtil.getSuid();
                AppTagsRelation appTagsRelation = new AppTagsRelation();
                appTagsRelation.setId(relationId);
                appTagsRelation.setAppId(appId);
                appTagsRelation.setTagId(tagId);
                this.appTagsRelationDao.insert((Object)appTagsRelation);
            }
        }
        if (BeanUtils.isEmpty(list = sysAppXml.getSysAuthUserList())) {
            this.sysAuthUserManager.createDefault(appId);
        } else {
            for (SysAuthUser sysAuthUser : list) {
                String ownerName;
                String ownerId;
                CommonResult result;
                String authId = UniqueIdUtil.getSuid();
                sysAuthUser.setId(authId);
                sysAuthUser.setAuthorizeId(appId);
                String rightType = sysAuthUser.getRightType();
                String ownerCode = sysAuthUser.getOwnerCode();
                if ("user".equals(rightType)) {
                    JsonNode userNode = this.ucFeignService.getUser(ownerCode, null);
                    if (BeanUtils.isNotEmpty((Object)userNode)) {
                        String ownerId2 = JsonUtil.getString((JsonNode)userNode, (String)"id");
                        String ownerName2 = JsonUtil.getString((JsonNode)userNode, (String)"fullname");
                        sysAuthUser.setOwnerId(ownerId2);
                        sysAuthUser.setOwnerName(ownerName2);
                    }
                } else if ("org".equals(rightType)) {
                    ObjectNode orgObjNode = this.ucFeignService.getOrgByIdOrCode(ownerCode);
                    if (BeanUtils.isNotEmpty((Object)orgObjNode)) {
                        String ownerId2 = orgObjNode.get("id").asText();
                        String ownerName2 = orgObjNode.get("name").asText();
                        sysAuthUser.setOwnerId(ownerId2);
                        sysAuthUser.setOwnerName(ownerName2);
                    }
                } else if ("pos".equals(rightType)) {
                    result = this.ucFeignService.getPostByIdOrCode(ownerCode);
                    if (BeanUtils.isNotEmpty((Object)result)) {
                        ObjectNode posObjNode = (ObjectNode)result.getValue();
                        ownerId = posObjNode.get("id").asText();
                        ownerName = posObjNode.get("name").asText();
                        sysAuthUser.setOwnerId(ownerId);
                        sysAuthUser.setOwnerName(ownerName);
                    }
                } else if ("role".equals(rightType) && BeanUtils.isNotEmpty((Object)(result = this.ucFeignService.getRoleByIdOrCode(ownerCode)))) {
                    ObjectNode roleObjNode = (ObjectNode)result.getValue();
                    ownerId = roleObjNode.get("id").asText();
                    ownerName = roleObjNode.get("name").asText();
                    sysAuthUser.setOwnerId(ownerId);
                    sysAuthUser.setOwnerName(ownerName);
                }
                this.sysAuthUserDao.insert((Object)sysAuthUser);
            }
        }
        ThreadMsgUtil.addMapMsg2((String)"sysAppsSaved", (String)String.format("<div style='margin-left:12px; margin-top:6px;'>%s</div>", sysApp.getName() + ""));
    }
}

