/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.sysConfig.enums;

import com.artfess.base.exception.ApplicationException;
import java.util.HashMap;
import java.util.Map;

public enum BaseInfoStatus {
    DRAFT(-1, "\u8349\u7a3f"),
    DISABLED(0, "\u7981\u7528"),
    ENABLED(1, "\u542f\u7528");

    private final int id;
    private final String displayName;

    private BaseInfoStatus(int id, String displayName) {
        this.id = id;
        this.displayName = displayName;
    }

    public String toString() {
        return String.valueOf(this.id);
    }

    public int getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public static BaseInfoStatus fromId(int id) {
        switch (id) {
            case 0: {
                return DISABLED;
            }
            case 1: {
                return ENABLED;
            }
            case -1: {
                return DRAFT;
            }
        }
        throw new ApplicationException(String.format("\u65e0\u6548\u7684\u72b6\u6001\u201c%s\u201d\u3002", id));
    }

    public static Map<Integer, String> getData() {
        HashMap<Integer, String> result = new HashMap<Integer, String>(2);
        for (BaseInfoStatus item : BaseInfoStatus.values()) {
            if (item == DRAFT) continue;
            result.put(item.getId(), item.getDisplayName());
        }
        return result;
    }

    public static boolean isDraft(int id) {
        return DRAFT.getId() == id;
    }
}

