/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.integrate.persistence.manager.impl;

import com.artfess.base.feign.UCFeignService;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.HttpUtil;
import com.artfess.base.util.JsonUtil;
import com.artfess.integrate.consts.WeChatWorkConsts;
import com.artfess.integrate.model.WxOrg;
import com.artfess.integrate.persistence.manager.IWXOrgService;
import com.artfess.integrate.util.OrgConvertUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class WxOrgService
implements IWXOrgService {
    protected Logger logger = LoggerFactory.getLogger(WxOrgService.class);
    @Resource
    UCFeignService orgManager;

    @Override
    public void create(ObjectNode org) {
        WxOrg wxorg = OrgConvertUtil.sysOrgToWxOrg((JsonNode)org);
        ObjectNode result = null;
        try {
            String resultJson = HttpUtil.sendHttpsRequest((String)WeChatWorkConsts.getCreateOrgUrl(), (String)wxorg.toString(), (String)"POST");
            result = (ObjectNode)JsonUtil.toJsonNode((String)resultJson);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
        String errcode = result.get("errcode").asText();
        if ("0".equals(errcode)) {
            return;
        }
        this.logger.debug(wxorg.toString());
        if ("60008".equals(errcode)) {
            return;
        }
        if ("60004".equals(errcode)) {
            return;
        }
        throw new RuntimeException(org.get("name").asText() + " \u6dfb\u52a0\u5fae\u4fe1\u901a\u8baf\u5f55\u7ec4\u7ec7\u5931\u8d25 \uff1a " + result.get("errmsg").asText());
    }

    @Override
    public void update(ObjectNode org) {
        WxOrg wxorg = OrgConvertUtil.sysOrgToWxOrg((JsonNode)org);
        ObjectNode result = null;
        try {
            String resultJson = HttpUtil.sendHttpsRequest((String)WeChatWorkConsts.getUpdateOrgUrl(), (String)wxorg.toString(), (String)"POST");
            result = (ObjectNode)JsonUtil.toJsonNode((String)resultJson);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
        String errcode = result.get("errcode").asText();
        if ("0".equals(errcode)) {
            return;
        }
        throw new RuntimeException(org.get("name").asText() + "\u6dfb\u52a0\u5fae\u4fe1\u901a\u8baf\u5f55\u7ec4\u7ec7\u5931\u8d25 \uff1a " + result.get("errmsg").asText());
    }

    @Override
    public void delete(String orgId) {
        ObjectNode result = null;
        try {
            String url = WeChatWorkConsts.getDeleteOrgUrl() + orgId;
            String resultJson = HttpUtil.sendHttpsRequest((String)url, (String)"", (String)"POST");
            result = (ObjectNode)JsonUtil.toJsonNode((String)resultJson);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
        if ("0".equals(result.get("errcode").asText())) {
            return;
        }
        if ("60003".equals(result.get("errcode").asText())) {
            this.logger.error(orgId + "\u5220\u9664\u5fae\u4fe1\u901a\u8baf\u5f55\u5931\u8d25 \uff1a " + result.get("errmsg").asText());
            return;
        }
        throw new RuntimeException(orgId + "\u5220\u9664\u5fae\u4fe1\u901a\u8baf\u5f55\u5931\u8d25 \uff1a " + result.get("errmsg").asText());
    }

    @Override
    public void deleteAll(String orgIds) {
        ObjectNode result = null;
        try {
            String delUrl = WeChatWorkConsts.getDeleteAllUserUrl();
            HashMap<String, String[]> users = new HashMap<String, String[]>();
            users.put("useridlist", orgIds.split(","));
            String resultJson = HttpUtil.sendHttpsRequest((String)delUrl, (String)JsonUtil.toJson(users), (String)"POST");
            result = (ObjectNode)JsonUtil.toJsonNode((String)resultJson);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
        if ("0".equals(result.get("errcode").asText())) {
            return;
        }
        throw new RuntimeException("\u6279\u91cf\u5220\u9664\u5fae\u4fe1\u901a\u8baf\u5f55\u7528\u6237\u5931\u8d25 \uff1a " + result.get("errmsg").asText());
    }

    @Override
    public String getDepartmentUser(String orgCode) {
        ObjectNode departmentResult = null;
        try {
            String departmentUrl = WeChatWorkConsts.getDepartmentUrl(orgCode);
            String departmentJson = HttpUtil.sendHttpsRequest((String)departmentUrl, (String)"", (String)"GET");
            departmentResult = (ObjectNode)JsonUtil.toJsonNode((String)departmentJson);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
        if ("0".equals(departmentResult.get("errcode").asText())) {
            ArrayNode users = departmentResult.putArray("userlist");
            Object[] userAccounts = new String[users.size()];
            for (int i = 0; i < users.size(); ++i) {
                ObjectNode user = null;
                try {
                    user = (ObjectNode)JsonUtil.toJsonNode((Object)i);
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage());
                }
                userAccounts[i] = user.get("userid").asText();
            }
            return StringUtils.join((Object[])userAccounts, (String)",");
        }
        throw new RuntimeException("\u6279\u91cf\u5220\u9664\u5fae\u4fe1\u901a\u8baf\u5f55\u7528\u6237\u5931\u8d25 \uff1a " + departmentResult.get("errmsg").asText());
    }

    @Override
    public void addAll(List<ObjectNode> orgList) {
        for (ObjectNode org : orgList) {
            this.create(org);
        }
    }

    @Override
    public void syncAllOrg() {
        List orgs = this.orgManager.getOrgsByparentId("1");
        if (orgs.size() >= 0) {
            this.addAll(orgs);
            for (ObjectNode rootOrg : orgs) {
                this.syncOrgsByParentId(rootOrg.get("id").asText());
            }
        }
    }

    public void syncOrgsByParentId(String parentId) {
        List orgs = this.orgManager.getChildOrg(parentId);
        if (BeanUtils.isNotEmpty((Object)orgs) && orgs.size() > 0) {
            this.addAll(orgs);
            for (ObjectNode org : orgs) {
                this.syncOrgsByParentId(org.get("id").asText());
            }
        }
    }
}

