/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.easyExcel.handler;

import com.alibaba.excel.write.handler.SheetWriteHandler;
import com.alibaba.excel.write.metadata.holder.WriteSheetHolder;
import com.alibaba.excel.write.metadata.holder.WriteWorkbookHolder;
import com.artfess.easyExcel.util.excel.ExcelSelectedResolve;
import java.util.Map;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddressList;

public class SelectedSheetWriteHandler
implements SheetWriteHandler {
    private final Map<Integer, ExcelSelectedResolve> selectedMap;

    public void beforeSheetCreate(WriteWorkbookHolder writeWorkbookHolder, WriteSheetHolder writeSheetHolder) {
    }

    public void afterSheetCreate(WriteWorkbookHolder writeWorkbookHolder, WriteSheetHolder writeSheetHolder) {
        Sheet sheet = writeSheetHolder.getSheet();
        DataValidationHelper helper = sheet.getDataValidationHelper();
        this.selectedMap.forEach((k, v) -> {
            CellRangeAddressList rangeList = new CellRangeAddressList(v.getFirstRow(), v.getLastRow(), k.intValue(), k.intValue());
            DataValidationConstraint constraint = helper.createExplicitListConstraint(v.getSource());
            DataValidation validation = helper.createValidation(constraint, rangeList);
            validation.setErrorStyle(0);
            validation.setShowErrorBox(true);
            validation.setSuppressDropDownArrow(true);
            validation.createErrorBox("\u63d0\u793a", "\u8bf7\u8f93\u5165\u4e0b\u62c9\u9009\u9879\u4e2d\u7684\u5185\u5bb9");
            sheet.addValidationData(validation);
        });
    }

    public Map<Integer, ExcelSelectedResolve> getSelectedMap() {
        return this.selectedMap;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SelectedSheetWriteHandler)) {
            return false;
        }
        SelectedSheetWriteHandler other = (SelectedSheetWriteHandler)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<Integer, ExcelSelectedResolve> this$selectedMap = this.getSelectedMap();
        Map<Integer, ExcelSelectedResolve> other$selectedMap = other.getSelectedMap();
        return !(this$selectedMap == null ? other$selectedMap != null : !((Object)this$selectedMap).equals(other$selectedMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SelectedSheetWriteHandler;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<Integer, ExcelSelectedResolve> $selectedMap = this.getSelectedMap();
        result = result * 59 + ($selectedMap == null ? 43 : ((Object)$selectedMap).hashCode());
        return result;
    }

    public String toString() {
        return "SelectedSheetWriteHandler(selectedMap=" + this.getSelectedMap() + ")";
    }

    public SelectedSheetWriteHandler(Map<Integer, ExcelSelectedResolve> selectedMap) {
        this.selectedMap = selectedMap;
    }
}

