/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bpm.persistence.manager.impl;

import com.artfess.base.exception.BaseException;
import com.artfess.base.feign.SystemConfigFeignService;
import com.artfess.base.feign.UCFeignService;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.FileUtil;
import com.artfess.base.util.JAXBUtil;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.ThreadMsgUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.base.util.ZipUtil;
import com.artfess.bpm.persistence.dao.BpmReportActDao;
import com.artfess.bpm.persistence.dao.BpmReportListDao;
import com.artfess.bpm.persistence.manager.BpmReportActManager;
import com.artfess.bpm.persistence.manager.BpmReportListManager;
import com.artfess.bpm.persistence.model.BpmReportAct;
import com.artfess.bpm.persistence.model.BpmReportList;
import com.artfess.bpm.persistence.model.BpmReportXml;
import com.artfess.bpm.persistence.model.BpmReportXmlList;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service(value="bpmReportListManager")
public class BpmReportListManagerImpl
extends BaseManagerImpl<BpmReportListDao, BpmReportList>
implements BpmReportListManager {
    @Resource
    BpmReportActManager bpmReportActManager;
    @Resource
    BpmReportActDao bpmReportActDao;
    @Resource
    SystemConfigFeignService systemConfigFeignService;
    @Resource
    UCFeignService ucFeignService;

    @Transactional
    public void removeByIds(String ... ids) {
        for (String id : ids) {
            this.remove(id);
        }
    }

    @Transactional
    public void remove(String id) {
        BpmReportList reportList = (BpmReportList)super.get((Serializable)((Object)id));
        if (BeanUtils.isNotEmpty((Object)((Object)reportList))) {
            this.bpmReportActManager.removeByReportId(id);
        }
        super.remove((Serializable)((Object)id));
    }

    @Override
    public Map<String, String> exportData(List<String> ids) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        BpmReportXmlList bpmReportXmlList = new BpmReportXmlList();
        for (String id : ids) {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"report_id_", (Object)id);
            List bpmReportActList = this.bpmReportActDao.selectList((Wrapper)wrapper);
            for (BpmReportAct bpmReportAct : bpmReportActList) {
                ArrayNode userArrayNode;
                String userIds;
                ArrayNode orgArrayNode;
                String orgIds;
                String flowTypeIds;
                ObjectNode prop = (ObjectNode)JsonUtil.toJsonNode((String)bpmReportAct.getPorp());
                String flowType = JsonUtil.getString((JsonNode)prop, (String)"flowType", (String)"1");
                ArrayList<String> flowTypeKeys = new ArrayList<String>();
                if ("2".equals(flowType) && StringUtil.isNotEmpty((String)(flowTypeIds = JsonUtil.getString((JsonNode)prop, (String)"id")))) {
                    QueryFilter queryFilter = QueryFilter.build();
                    queryFilter.addFilter("id_", (Object)flowTypeIds, QueryOP.IN);
                    ObjectNode sysTypeObjNode = this.systemConfigFeignService.getAllSysType(queryFilter);
                    if (BeanUtils.isNotEmpty((Object)sysTypeObjNode) && BeanUtils.isNotEmpty((Object)sysTypeObjNode.get("rows"))) {
                        for (JsonNode sysTypeNode : sysTypeObjNode.get("rows")) {
                            String flowTypeKey = JsonUtil.getString((JsonNode)sysTypeNode, (String)"typeKey");
                            if (!StringUtil.isNotEmpty((String)flowTypeKey)) continue;
                            flowTypeKeys.add(flowTypeKey);
                        }
                        if (!flowTypeKeys.isEmpty()) {
                            bpmReportAct.setFlowTypeKeys(flowTypeKeys);
                        }
                    }
                }
                if (StringUtil.isNotEmpty((String)(orgIds = JsonUtil.getString((JsonNode)prop, (String)"orgIds"))) && BeanUtils.isNotEmpty((Object)(orgArrayNode = this.ucFeignService.getOrgsByIds(orgIds)))) {
                    ArrayList<String> orgCodes = new ArrayList<String>();
                    for (JsonNode orgNode : orgArrayNode) {
                        String code = JsonUtil.getString((JsonNode)orgNode, (String)"code");
                        if (!StringUtil.isNotEmpty((String)code)) continue;
                        orgCodes.add(code);
                    }
                    if (!orgCodes.isEmpty()) {
                        bpmReportAct.setOrgCodes(orgCodes);
                    }
                }
                if (!StringUtil.isNotEmpty((String)(userIds = JsonUtil.getString((JsonNode)prop, (String)"userIds"))) || !BeanUtils.isNotEmpty((Object)(userArrayNode = this.ucFeignService.getUserByIds(userIds)))) continue;
                ArrayList<String> userAccounts = new ArrayList<String>();
                for (JsonNode userNode : userArrayNode) {
                    String userAccount = JsonUtil.getString((JsonNode)userNode, (String)"account");
                    if (!StringUtil.isNotEmpty((String)userAccount)) continue;
                    userAccounts.add(userAccount);
                }
                if (userAccounts.isEmpty()) continue;
                bpmReportAct.setUserAccounts(userAccounts);
            }
            BpmReportXml bpmReportXml = new BpmReportXml();
            BpmReportList bpmReport = (BpmReportList)this.get((Serializable)((Object)id));
            bpmReportXml.setBpmReport(bpmReport);
            bpmReportXml.setBpmReportActList(bpmReportActList);
            bpmReportXmlList.addBpmReportXml(bpmReportXml);
        }
        try {
            String xml = JAXBUtil.marshall((Object)bpmReportXmlList, BpmReportXmlList.class);
            map.put("bpmReports.bpm.xml", xml);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("\u5bfc\u51fa\u5931\u8d25\uff01" + e.getMessage(), e);
        }
        return map;
    }

    @Override
    @Transactional
    public void importData(MultipartFile file) {
        File formDir;
        String unZipFilePath = null;
        try {
            String rootRealPath = Paths.get(FileUtil.getIoTmpdir(), "attachFiles/unZip").toString();
            FileUtil.createFolder((String)rootRealPath, (boolean)true);
            ZipUtil.unZipFile((MultipartFile)file, (String)rootRealPath);
            String name = file.getOriginalFilename();
            String fileDir = StringUtil.substringBeforeLast((String)name, (String)".");
            unZipFilePath = Paths.get(rootRealPath, fileDir).toString();
            String xml = FileUtil.readFile((String)Paths.get(unZipFilePath, "bpmReports.bpm.xml").toString());
            if (StringUtil.isEmpty((String)xml)) {
                throw new BaseException("\u5bfc\u5165\u7684xml\u6587\u4ef6\u6ca1\u6709\u5185\u5bb9\uff01");
            }
            BpmReportXmlList list = (BpmReportXmlList)JAXBUtil.unmarshall((String)xml, BpmReportXmlList.class);
            List<BpmReportXml> bpmReportXmlList = list.getBpmReportXmlList();
            for (BpmReportXml bpmReportxml : bpmReportXmlList) {
                this.importData(bpmReportxml);
            }
        }
        catch (Exception e) {
            try {
                throw new BaseException(e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                File formDir2;
                if (StringUtil.isNotEmpty(unZipFilePath) && (formDir2 = new File(unZipFilePath)).exists()) {
                    FileUtil.deleteDir((File)formDir2);
                }
                throw throwable;
            }
        }
        if (StringUtil.isNotEmpty((String)unZipFilePath) && (formDir = new File(unZipFilePath)).exists()) {
            FileUtil.deleteDir((File)formDir);
        }
    }

    private void importData(BpmReportXml bpmReportxml) throws Exception {
        BpmReportList bpmReport = bpmReportxml.getBpmReport();
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"name_", (Object)bpmReport.getName());
        List bpmReportList = ((BpmReportListDao)this.baseMapper).selectList((Wrapper)wrapper);
        if (bpmReportList != null && !bpmReportList.isEmpty()) {
            ThreadMsgUtil.addMapMsg2((String)"bpmReportsSkipped", (String)String.format("<div style='margin-left:12px; margin-top:6px;'>%s</div>", bpmReport.getName() + ""));
            return;
        }
        String reportId = UniqueIdUtil.getSuid();
        bpmReport.setId(reportId);
        this.create((Model)bpmReport);
        wrapper = new QueryWrapper();
        wrapper.eq((Object)"report_id_", (Object)reportId);
        List<BpmReportAct> bpmReportActList = bpmReportxml.getBpmReportActList();
        for (BpmReportAct bpmReportAct : bpmReportActList) {
            String userAccountsStr;
            ArrayNode userArrayNode;
            List<String> userAccounts;
            String orgCodesStr;
            ArrayNode orgArrayNode;
            List<String> orgCodes;
            List<String> flowTypeKeys;
            ObjectNode prop = (ObjectNode)JsonUtil.toJsonNode((String)bpmReportAct.getPorp());
            String flowType = JsonUtil.getString((JsonNode)prop, (String)"flowType", (String)"1");
            if ("2".equals(flowType) && (flowTypeKeys = bpmReportAct.getFlowTypeKeys()) != null && !flowTypeKeys.isEmpty()) {
                String flowTypeKeysStr = String.join((CharSequence)",", flowTypeKeys);
                QueryFilter queryFilter = QueryFilter.build();
                queryFilter.addFilter("typeGroupKey", (Object)"FLOW_TYPE", QueryOP.EQUAL);
                queryFilter.addFilter("typeKey", (Object)flowTypeKeysStr, QueryOP.IN);
                ObjectNode sysTypeObjNode = this.systemConfigFeignService.getAllSysType(queryFilter);
                if (BeanUtils.isNotEmpty((Object)sysTypeObjNode) && BeanUtils.isNotEmpty((Object)sysTypeObjNode.get("rows"))) {
                    ArrayList<String> flowTypeIds = new ArrayList<String>();
                    for (JsonNode sysTypeNode : sysTypeObjNode.get("rows")) {
                        String flowTypeId = JsonUtil.getString((JsonNode)sysTypeNode, (String)"id");
                        if (!StringUtil.isNotEmpty((String)flowTypeId)) continue;
                        flowTypeIds.add(flowTypeId);
                    }
                    if (!flowTypeIds.isEmpty()) {
                        String flowTypeIdsStr = String.join((CharSequence)",", flowTypeIds);
                        prop.put("id", flowTypeIdsStr);
                    }
                }
            }
            if ((orgCodes = bpmReportAct.getOrgCodes()) != null && !orgCodes.isEmpty() && BeanUtils.isNotEmpty((Object)(orgArrayNode = this.ucFeignService.getOrgsByCodes(orgCodesStr = String.join((CharSequence)",", orgCodes))))) {
                ArrayList<String> orgIds = new ArrayList<String>();
                ArrayList<String> orgNames = new ArrayList<String>();
                for (Iterator orgNode : orgArrayNode) {
                    String orgName;
                    String orgId = JsonUtil.getString((JsonNode)orgNode, (String)"id");
                    if (StringUtil.isNotEmpty((String)orgId)) {
                        orgIds.add(orgId);
                    }
                    if (!StringUtil.isNotEmpty((String)(orgName = JsonUtil.getString((JsonNode)orgNode, (String)"name")))) continue;
                    orgNames.add(orgName);
                }
                if (!orgIds.isEmpty()) {
                    String orgIdsStr = String.join((CharSequence)",", orgIds);
                    prop.put("orgIds", orgIdsStr);
                }
                if (!orgNames.isEmpty()) {
                    String orgNamesStr = String.join((CharSequence)",", orgNames);
                    prop.put("orgNames", orgNamesStr);
                }
            }
            if ((userAccounts = bpmReportAct.getUserAccounts()) != null && !userAccounts.isEmpty() && BeanUtils.isNotEmpty((Object)(userArrayNode = this.ucFeignService.getUserByAccounts(userAccountsStr = String.join((CharSequence)",", userAccounts))))) {
                Iterator orgNode;
                ArrayList<String> userIds = new ArrayList<String>();
                ArrayList<String> userNames = new ArrayList<String>();
                orgNode = userArrayNode.iterator();
                while (orgNode.hasNext()) {
                    String userName;
                    JsonNode userNode = (JsonNode)orgNode.next();
                    String userId = JsonUtil.getString((JsonNode)userNode, (String)"id");
                    if (StringUtil.isNotEmpty((String)userId)) {
                        userIds.add(userId);
                    }
                    if (!StringUtil.isNotEmpty((String)(userName = JsonUtil.getString((JsonNode)userNode, (String)"fullname")))) continue;
                    userNames.add(userName);
                }
                if (!userIds.isEmpty()) {
                    String userIdsStr = String.join((CharSequence)",", userIds);
                    prop.put("orgIds", userIdsStr);
                }
                if (!userNames.isEmpty()) {
                    String userNamesStr = String.join((CharSequence)",", userNames);
                    prop.put("orgNames", userNamesStr);
                }
            }
            bpmReportAct.setPorp(JsonUtil.toJsonString((Object)prop));
            String actId = UniqueIdUtil.getSuid();
            bpmReportAct.setId(actId);
            bpmReportAct.setReportId(reportId);
            this.bpmReportActDao.insert((Object)bpmReportAct);
        }
        ThreadMsgUtil.addMapMsg2((String)"bpmReportsSaved", (String)String.format("<div style='margin-left:12px; margin-top:6px;'>%s</div>", bpmReport.getName() + ""));
    }
}

